/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui.discover;

import com.jidesoft.wizard.DefaultWizardPage;
import com.mathworks.jmi.Callback;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.toolbox.distcomp.ui.discover.PageActionProvider;
import com.mathworks.toolbox.distcomp.ui.discover.model.DiscoverClusterWizardModel;
import com.mathworks.toolbox.distcomp.ui.resources.icons.ParallelIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

final class SetDefaultProfilePage
extends DefaultWizardPage
implements PropertyChangeListener,
PageActionProvider {
    private final DiscoverClusterWizardModel fDiscoverClusterModel;
    private final Callback fSetDefaultProfileCallback = new Callback();
    private final JLabel fOverallStatusLabel;
    private JCheckBox fSetDefaultCheckBox;
    private JLabel fAdditionalLabel;
    private static final ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.toolbox.distcomp.ui.resources.RES_profile");

    SetDefaultProfilePage(DiscoverClusterWizardModel discoverClusterWizardModel) {
        super(sRes.getString("DiscoverDialog.SetDefaultProfilePage"));
        this.fDiscoverClusterModel = discoverClusterWizardModel;
        this.fDiscoverClusterModel.addPropertyChangeListener(this);
        this.fSetDefaultCheckBox = new MJCheckBox(sRes.getString("DiscoverDialog.SetDefaultCheckBox"), true);
        this.fSetDefaultCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SetDefaultProfilePage.this.fDiscoverClusterModel.setCreatedProfileAsDefault(SetDefaultProfilePage.this.fSetDefaultCheckBox.isSelected());
            }
        });
        this.fSetDefaultCheckBox.setEnabled(false);
        this.fOverallStatusLabel = new MJLabel();
        this.fAdditionalLabel = new MJLabel(sRes.getString("DiscoverDialog.AdditionalLabel.ProfileCreated"));
        this.addComponent(this.fOverallStatusLabel);
        this.addComponent(this.fSetDefaultCheckBox);
        this.addComponent(this.fAdditionalLabel);
        this.addComponent(new JPanel(), true);
        this.fSetDefaultCheckBox.setName("SetDefaultCheckBox");
        this.fOverallStatusLabel.setName("SetDefaultProfilePage.StatusLabel");
    }

    public void setupWizardButtons() {
        super.setupWizardButtons();
        this.fireButtonEvent(3300, "BACK");
        this.fireButtonEvent(3300, "NEXT");
        this.fireButtonEvent(3300, "CANCEL");
        this.fireButtonEvent(3299, "FINISH");
        this.fireButtonEvent(3302, "FINISH");
    }

    public boolean showBannerPane() {
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("SetAsDefault")) {
            this.fSetDefaultCheckBox.setSelected(this.fDiscoverClusterModel.isCreatedProfileAsDefault());
        } else if (string.equals("ProfileName")) {
            String string2 = this.fDiscoverClusterModel.getCreatedProfileName();
            this.fOverallStatusLabel.setText(MessageFormat.format(sRes.getString("DiscoverDialog.StatusLabel.ProfileCreated"), string2));
            this.fOverallStatusLabel.setIcon(ParallelIcon.PASSED.getIcon());
            this.fAdditionalLabel.setEnabled(true);
            this.fSetDefaultCheckBox.setEnabled(true);
            this.fireButtonEvent(3301, "FINISH");
        } else if (string.equals("DiscoveryStarted")) {
            this.fOverallStatusLabel.setText(sRes.getString("DiscoverDialog.StatusLabel.ProfileCreating"));
            this.fOverallStatusLabel.setIcon(ParallelIcon.BUSY.getIcon());
            this.fAdditionalLabel.setEnabled(false);
            this.fSetDefaultCheckBox.setEnabled(false);
        }
    }

    @Override
    public void doCancel() {
    }

    @Override
    public void doNext() {
        assert (false) : "Finish should not be called";
    }

    @Override
    public void doFinish() {
        this.fireButtonEvent(3302, "FINISH");
        this.fSetDefaultProfileCallback.postCallback();
    }

    public Callback getCallback() {
        return this.fSetDefaultProfileCallback;
    }
}

