/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.storage.fileblobs;

import com.mathworks.toolbox.distcomp.storage.fileblobs.DirectoryIterator;
import com.mathworks.toolbox.distcomp.storage.fileblobs.FilePathAllocator;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;

public class FilePathAllocationChecker {
    private final File fRootDirectory;
    private final DirectoryIterator fDirectoryIterator;
    private final int fMaxFilesPerDirectory;
    private final TreeMap<File, Integer> fFreeDirectories = new TreeMap(new FilePathAllocator.PathLengthComparator());
    private final Set<File> fFullDirectories = new HashSet<File>();

    public FilePathAllocationChecker(File file, int n, DirectoryIterator directoryIterator) {
        this.fRootDirectory = file;
        this.fDirectoryIterator = directoryIterator;
        this.fMaxFilesPerDirectory = n;
    }

    public int getDirectorySpace(File file) {
        File[] fileArray = file.listFiles();
        int n = this.fMaxFilesPerDirectory;
        if (fileArray != null) {
            n -= fileArray.length;
        }
        return n;
    }

    public void checkDirectories(File file) {
        File file2 = this.fDirectoryIterator.nextDirectory();
        File file3 = new File(this.fRootDirectory, file2.getPath());
        while (!file2.equals(file)) {
            if (!file3.exists()) {
                this.fFreeDirectories.put(file2, this.fMaxFilesPerDirectory);
            } else {
                int n = this.getDirectorySpace(file3);
                if (n > 0) {
                    this.fFreeDirectories.put(file2, n);
                } else {
                    this.fFullDirectories.add(file2);
                }
            }
            file2 = this.fDirectoryIterator.nextDirectory();
            file3 = new File(this.fRootDirectory, file2.getPath());
        }
    }

    public void updateAllocator(FilePathAllocator filePathAllocator) {
        filePathAllocator.update(this.fFreeDirectories, this.fFullDirectories);
    }
}

