/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.remote.spi.plugin;

import com.mathworks.toolbox.distcomp.remote.Command;
import com.mathworks.toolbox.distcomp.remote.CopyCommand;
import com.mathworks.toolbox.distcomp.remote.CopyFromRemoteCommand;
import com.mathworks.toolbox.distcomp.remote.CopyToRemoteCommand;
import com.mathworks.toolbox.distcomp.remote.DispatchException;
import com.mathworks.toolbox.distcomp.remote.ListFileAttributesCommand;
import com.mathworks.toolbox.distcomp.remote.Logger;
import com.mathworks.toolbox.distcomp.remote.MakeDirectoryCommand;
import com.mathworks.toolbox.distcomp.remote.MakeDirectoryFuture;
import com.mathworks.toolbox.distcomp.remote.ParameterMap;
import com.mathworks.toolbox.distcomp.remote.ParameterSet;
import com.mathworks.toolbox.distcomp.remote.ProtocolDispatchException;
import com.mathworks.toolbox.distcomp.remote.RemoveFileCommand;
import com.mathworks.toolbox.distcomp.remote.RemoveFileFuture;
import com.mathworks.toolbox.distcomp.remote.spi.FileSystemManipulator;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.JSchSFTPCopyFuture;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.SshParameter;
import java.util.Iterator;
import java.util.Set;

public final class JSchSFTPCopier
implements FileSystemManipulator {
    private static final String PROTOCOL_NAME = "jschsftpcopy";
    private static final String PROTOCOL_TYPE = "sftp";

    @Override
    public ParameterSet getParameterSet() {
        return SshParameter.SSH_PARAMETER_SET;
    }

    @Override
    public String getProtocolName() {
        return PROTOCOL_NAME;
    }

    @Override
    public String getProtocolType() {
        return PROTOCOL_TYPE;
    }

    @Override
    public Class<? extends Command> getCommandClass() {
        return CopyCommand.class;
    }

    private String createLogIdString(Command command, String string) throws ProtocolDispatchException {
        if (command instanceof CopyToRemoteCommand) {
            CopyToRemoteCommand copyToRemoteCommand = (CopyToRemoteCommand)command;
            String string2 = "Copy " + copyToRemoteCommand.getLocalFile() + " to " + string + ":" + copyToRemoteCommand.getRemoteFile();
            if (!copyToRemoteCommand.getLocalFile().exists()) {
                throw new ProtocolDispatchException(string2 + ": local file " + copyToRemoteCommand.getLocalFile() + " does not exist.");
            }
            return string2;
        }
        if (command instanceof CopyFromRemoteCommand) {
            CopyFromRemoteCommand copyFromRemoteCommand = (CopyFromRemoteCommand)command;
            return "Copy " + string + ":" + copyFromRemoteCommand.getRemoteFile() + " to " + copyFromRemoteCommand.getLocalFile();
        }
        if (command instanceof ListFileAttributesCommand) {
            String string3;
            Set<String> set = ((ListFileAttributesCommand)command).getRemotePaths();
            if (!set.isEmpty()) {
                Iterator<String> iterator = set.iterator();
                String string4 = iterator.next();
                string3 = set.size() > 1 ? string4 + " and " + (set.size() - 1) + " more." : string4;
            } else {
                string3 = "no files";
            }
            return string + ": sftp ls -lr " + string3;
        }
        if (command instanceof RemoveFileCommand) {
            String string5;
            Set<String> set = ((RemoveFileCommand)command).getRemotePaths();
            if (!set.isEmpty()) {
                Iterator<String> iterator = set.iterator();
                String string6 = iterator.next();
                string5 = set.size() > 1 ? string6 + " and " + (set.size() - 1) + " more." : string6;
            } else {
                string5 = "no files";
            }
            return string + ": sftp rm -r " + string5;
        }
        if (command instanceof MakeDirectoryCommand) {
            String string7 = ((MakeDirectoryCommand)command).getRemotePath();
            return string + ": sftp mkdir " + string7;
        }
        throw new UnsupportedOperationException(command.getClass().getName() + " is not supported by " + this.getClass().getName());
    }

    @Override
    public JSchSFTPCopyFuture copyFile(CopyCommand copyCommand, String string, ParameterMap parameterMap) throws DispatchException {
        return this.execute(copyCommand, string, parameterMap);
    }

    @Override
    public JSchSFTPCopyFuture list(ListFileAttributesCommand listFileAttributesCommand, String string, ParameterMap parameterMap) throws DispatchException {
        return this.execute(listFileAttributesCommand, string, parameterMap);
    }

    @Override
    public RemoveFileFuture remove(RemoveFileCommand removeFileCommand, String string, ParameterMap parameterMap) throws DispatchException {
        return this.execute(removeFileCommand, string, parameterMap);
    }

    @Override
    public MakeDirectoryFuture makeDirectory(MakeDirectoryCommand makeDirectoryCommand, String string, ParameterMap parameterMap) throws DispatchException {
        return this.execute(makeDirectoryCommand, string, parameterMap);
    }

    @Override
    public JSchSFTPCopyFuture execute(Command command, String string, ParameterMap parameterMap) throws DispatchException {
        String string2 = this.createLogIdString(command, string);
        parameterMap.checkParameters(this.getParameterSet());
        JSchSFTPCopyFuture jSchSFTPCopyFuture = JSchSFTPCopyFuture.createJschSFTPCopyFuture(command, string, parameterMap, string2);
        Logger.LOGGER.fine(string2 + ": started");
        return jSchSFTPCopyFuture;
    }
}

