/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.MatlabMCR;
import com.mathworks.toolbox.distcomp.pmode.FevalResult;
import com.mathworks.toolbox.distcomp.pmode.MDispatchableCommand;
import com.mathworks.toolbox.distcomp.pmode.MatlabOutputWriters;
import com.mathworks.toolbox.distcomp.pmode.Session;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.ReturnGroup;
import com.mathworks.toolbox.distcomp.util.MatlabRefStore;

public class MFevalCommand
extends MDispatchableCommand
implements MatlabOutputWriters.MatlabOutputListener {
    private final String fFunction;
    private final Object[] fInputArguments;
    private final int fnlhs;
    private final ConsoleOutput fConsoleOutput;
    protected transient ReturnGroup fReturnGroup;

    public MFevalCommand(String string, Object[] objectArray, int n) {
        this.fFunction = string;
        this.fInputArguments = objectArray;
        this.fnlhs = n;
        this.fConsoleOutput = ConsoleOutput.Discard;
    }

    public MFevalCommand(String string, Object[] objectArray, int n, ConsoleOutput consoleOutput) {
        this.fFunction = string;
        this.fInputArguments = objectArray;
        this.fnlhs = n;
        this.fConsoleOutput = consoleOutput;
    }

    @Override
    public void dispatch(final ReturnGroup returnGroup, Instance instance, Session session) {
        this.fReturnGroup = returnGroup;
        MatlabMCR matlabMCR = MatlabRefStore.getMatlabRef();
        CompletionObserver completionObserver = new CompletionObserver(){

            public void completed(int n, Object object) {
                if (MFevalCommand.this.fConsoleOutput == ConsoleOutput.Return) {
                    MatlabOutputWriters.getInstance().flushAllPendingOutputNoException();
                    MatlabOutputWriters.getInstance().removeOutputListener(MFevalCommand.this);
                }
                FevalResult fevalResult = MFevalCommand.this.buildResult(n, object, MFevalCommand.this.fnlhs, MFevalCommand.this.getSequenceNumber());
                returnGroup.returnTo(MFevalCommand.this.getSourceProcess(), fevalResult);
                fevalResult.dispose();
            }
        };
        if (this.fConsoleOutput == ConsoleOutput.Return) {
            MatlabOutputWriters.getInstance().flushAllPendingOutputNoException();
            MatlabOutputWriters.getInstance().addOutputListener(this);
            matlabMCR.fevalConsoleOutput(this.fFunction, this.getInputArguments(), this.fnlhs, completionObserver);
        } else {
            matlabMCR.feval(this.fFunction, this.getInputArguments(), this.fnlhs, completionObserver);
        }
    }

    protected FevalResult buildResult(int n, Object object, int n2, long l) {
        return new FevalResult(n, object, n2, l);
    }

    protected Object[] getInputArguments() {
        return this.fInputArguments;
    }

    @Override
    public void stdout(String string) {
        this.sendCommandOutput(string);
    }

    @Override
    public void stderr(String string) {
        this.sendCommandOutput(string);
    }

    private void sendCommandOutput(String string) {
        assert (this.fReturnGroup != null) : "Unable to return command output if the return group is null";
        MatlabOutputWriters.returnCommandOutput(string, this.fReturnGroup, this.getSequenceNumber(), this.getSourceProcess());
    }

    static enum ConsoleOutput {
        Return,
        Discard;

    }
}

