/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.nativedmatlab;

import com.mathworks.toolbox.distcomp.nativedmatlab.ByteBuffAndKey;
import com.mathworks.toolbox.distcomp.nativedmatlab.FreeableDirectByteBuffer;
import com.mathworks.toolbox.distcomp.nativedmatlab.PhantomRefToBBAK;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;

final class PhantomReferenceReaper
extends Thread {
    private ReferenceQueue<ByteBuffAndKey> fRefQueue = new ReferenceQueue();
    private static final int sTHREAD_SLEEP_AMOUNT = 100;

    private PhantomReferenceReaper() {
        super("FreeableDirectByteBuffer reference reaper");
        this.setDaemon(true);
    }

    private void init() {
        this.start();
    }

    static PhantomReferenceReaper build() {
        PhantomReferenceReaper phantomReferenceReaper = new PhantomReferenceReaper();
        phantomReferenceReaper.init();
        return phantomReferenceReaper;
    }

    ReferenceQueue<ByteBuffAndKey> getRefQueue() {
        return this.fRefQueue;
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    Reference<ByteBuffAndKey> reference;
                    if ((reference = this.fRefQueue.poll()) instanceof PhantomRefToBBAK) {
                        PhantomRefToBBAK phantomRefToBBAK = (PhantomRefToBBAK)reference;
                        FreeableDirectByteBuffer.freeByKey(phantomRefToBBAK.getAllocationKey());
                    } else assert (reference == null) : "Reference queue unexpectedly got: " + reference;
                    if (reference != null) continue;
                    PhantomReferenceReaper.sleep(100L);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                continue;
            }
            break;
        }
    }
}

