/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.jobmanager;

import com.mathworks.toolbox.distcomp.auth.AuthorisationModule;
import com.mathworks.toolbox.distcomp.auth.credentials.CredentialRole;
import com.mathworks.toolbox.distcomp.auth.credentials.NontransferableCredentials;
import com.mathworks.toolbox.distcomp.auth.credentials.UserCredentials;
import com.mathworks.toolbox.distcomp.auth.credentials.UserIdentity;
import com.mathworks.toolbox.distcomp.auth.credentials.store.CredentialProviderImpl;
import com.mathworks.toolbox.distcomp.auth.credentials.store.SingleUserCredentialStore;
import com.mathworks.toolbox.distcomp.distcompobjects.Identifiable;
import com.mathworks.toolbox.distcomp.jobmanager.PackageInfo;
import com.mathworks.toolbox.distcomp.jobmanager.WorkerPool;
import com.mathworks.toolbox.distcomp.jobmanager.permissions.ClientPermission;
import com.mathworks.toolbox.distcomp.jobmanager.permissions.PermissionChecker;
import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.mjs.MJSException;
import com.mathworks.toolbox.distcomp.service.DistcompServiceProxy;
import com.mathworks.toolbox.distcomp.service.ExporterFactory;
import com.mathworks.toolbox.distcomp.storage.CredentialsNotFoundException;
import com.mathworks.toolbox.distcomp.storage.JobManagerStorage;
import com.mathworks.toolbox.distcomp.storage.WorkUnitNotFoundException;
import com.mathworks.toolbox.distcomp.worker.InvalidCredentialsException;
import com.mathworks.toolbox.distcomp.worker.WorkerProxy;
import com.mathworks.toolbox.distcomp.worker.matlab.TaskLicenseErrorException;
import com.mathworks.toolbox.distcomp.workunit.JobAndTaskIdentifier;
import com.mathworks.toolbox.distcomp.workunit.JobImpl;
import com.mathworks.toolbox.distcomp.workunit.TaskImpl;
import com.mathworks.toolbox.distcomp.workunit.WorkerTaskInfo;
import java.util.ArrayList;
import java.util.List;
import net.jini.id.Uuid;

public abstract class TaskDispatcher {
    protected final JobManagerStorage fStorage;
    protected final AuthorisationModule fAuthorisationModule;
    private final ExporterFactory fExporterFactory;
    private final PermissionChecker fPermissionChecker;

    protected TaskDispatcher(JobManagerStorage jobManagerStorage, AuthorisationModule authorisationModule, ExporterFactory exporterFactory, PermissionChecker permissionChecker) {
        this.fStorage = jobManagerStorage;
        this.fAuthorisationModule = authorisationModule;
        this.fExporterFactory = exporterFactory;
        this.fPermissionChecker = permissionChecker;
    }

    protected abstract int dispatchTasks(Uuid var1, int var2, boolean var3, Uuid[] var4, int var5);

    protected int dispatchTasks(Uuid uuid, int n, boolean bl, List<Uuid> list, int n2) {
        int n3 = 0;
        while (true) {
            int n4 = Math.min(list.size(), n2);
            Uuid[] uuidArray = this.fStorage.readTasksByJobIDAndState(uuid, 0, n4);
            if ((n4 = Math.min(uuidArray.length, n4)) <= 0) break;
            TaskIDAndWorkerID[] taskIDAndWorkerIDArray = new TaskIDAndWorkerID[n4];
            for (int i = 0; i < n4; ++i) {
                Uuid uuid2 = list.remove(0);
                Uuid uuid3 = uuidArray[i];
                taskIDAndWorkerIDArray[i] = new TaskIDAndWorkerID(uuid3, uuid2);
            }
            ArrayList<Uuid> arrayList = new ArrayList<Uuid>();
            int n5 = this.sendTasksToWorkers(taskIDAndWorkerIDArray, uuid, n, bl, arrayList);
            n2 -= n5;
            list.addAll(0, arrayList);
            n3 += n5;
        }
        return n3;
    }

    private int sendTasksToWorkers(TaskIDAndWorkerID[] taskIDAndWorkerIDArray, Uuid uuid, int n, boolean bl, List<Uuid> list) {
        int n2;
        int n3 = 0;
        int n4 = taskIDAndWorkerIDArray.length;
        SendTask[] sendTaskArray = new SendTask[n4];
        for (n2 = 0; n2 < n4; ++n2) {
            Uuid uuid2 = taskIDAndWorkerIDArray[n2].getTaskID();
            Uuid uuid3 = taskIDAndWorkerIDArray[n2].getWorkerID();
            sendTaskArray[n2] = new SendTask(uuid2, uuid3, uuid, n, bl);
            sendTaskArray[n2].start();
        }
        block3: for (n2 = 0; n2 < n4; ++n2) {
            while (true) {
                try {
                    sendTaskArray[n2].join();
                    if (sendTaskArray[n2].isSendSuccessful()) {
                        ++n3;
                        continue block3;
                    }
                    if (!sendTaskArray[n2].isWorkerStillIdle()) continue block3;
                    list.add(sendTaskArray[n2].getWorkerID());
                    continue block3;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
        return n3;
    }

    private class TaskIDAndWorkerID {
        private Uuid iTaskID;
        private Uuid iWorkerID;

        TaskIDAndWorkerID(Uuid uuid, Uuid uuid2) {
            this.iTaskID = uuid;
            this.iWorkerID = uuid2;
        }

        Uuid getTaskID() {
            return this.iTaskID;
        }

        Uuid getWorkerID() {
            return this.iWorkerID;
        }
    }

    private class SendTask
    extends Thread {
        private Uuid iTaskID;
        private Uuid iWorkerID;
        private Uuid iJobID;
        private int iJobMLType;
        private boolean iJobRestartWorker;
        private boolean iSendSuccessful = false;
        private boolean iWorkerStillIdle = true;

        SendTask(Uuid uuid, Uuid uuid2, Uuid uuid3, int n, boolean bl) {
            this.iTaskID = uuid;
            this.iWorkerID = uuid2;
            this.iJobID = uuid3;
            this.iJobMLType = n;
            this.iJobRestartWorker = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            NontransferableCredentials nontransferableCredentials;
            Identifiable identifiable;
            UserIdentity userIdentity;
            int n;
            TaskImpl taskImpl;
            try {
                taskImpl = (TaskImpl)TaskDispatcher.this.fStorage.readWorkUnit(this.iTaskID);
                n = taskImpl.getLogLevel();
                userIdentity = new UserIdentity(taskImpl.getUserName());
            }
            catch (WorkUnitNotFoundException workUnitNotFoundException) {
                return;
            }
            try {
                identifiable = (JobImpl)TaskDispatcher.this.fStorage.readWorkUnit(this.iJobID);
                nontransferableCredentials = ((JobImpl)identifiable).getCredentials();
            }
            catch (MJSException mJSException) {
                return;
            }
            try {
                identifiable = this.dispatchBegun(taskImpl);
                if (identifiable == null) {
                    return;
                }
            }
            catch (MJSException mJSException) {
                return;
            }
            SingleUserCredentialStore<UserCredentials> singleUserCredentialStore = new SingleUserCredentialStore<UserCredentials>();
            CredentialProviderImpl credentialProviderImpl = new CredentialProviderImpl(singleUserCredentialStore, TaskDispatcher.this.fExporterFactory.createExporter());
            try {
                UserCredentials userCredentials;
                if (TaskDispatcher.this.fPermissionChecker.checkPermissions(identifiable, ClientPermission.ALL_PERMISSIONS)) {
                    userCredentials = TaskDispatcher.this.fAuthorisationModule.getCredentials(userIdentity);
                    if (nontransferableCredentials != null) {
                        userCredentials.putCredentialsForRole(CredentialRole.WEB_LICENSE_INFO, nontransferableCredentials);
                    }
                } else {
                    PackageInfo.LOGGER.log(DistcompLevel.SIX, "Task dispatch failed as the worker did not have the permissions required to run this task.");
                    this.dispatchFailed(taskImpl);
                    return;
                }
                singleUserCredentialStore.putCredentials(userCredentials);
                JobAndTaskIdentifier jobAndTaskIdentifier = new JobAndTaskIdentifier(this.iJobID, taskImpl);
                PackageInfo.LOGGER.log(DistcompLevel.THREE, "Sending task " + taskImpl.getNum() + " " + jobAndTaskIdentifier.getTaskAttemptIdentifier() + " to worker " + ((DistcompServiceProxy)identifiable).getName() + " on computer " + ((DistcompServiceProxy)identifiable).getHostName());
                ((WorkerProxy)identifiable).executeTask(jobAndTaskIdentifier, this.iJobMLType, this.iJobRestartWorker, n, userIdentity, credentialProviderImpl.getProxy());
                this.dispatchSucceeded(taskImpl);
                return;
            }
            catch (CredentialsNotFoundException credentialsNotFoundException) {
                PackageInfo.LOGGER.log(DistcompLevel.ONE, "Task dispatch failed as the required credentials were not provided.", credentialsNotFoundException);
                this.dispatchFailedExceptionOnWorker(taskImpl, credentialsNotFoundException, (WorkerProxy)identifiable);
            }
            catch (InvalidCredentialsException invalidCredentialsException) {
                PackageInfo.LOGGER.log(DistcompLevel.ONE, "Task dispatch failed as the specified credentials were invalid.", invalidCredentialsException);
                this.dispatchFailedExceptionOnWorker(taskImpl, invalidCredentialsException, (WorkerProxy)identifiable);
            }
            catch (TaskLicenseErrorException taskLicenseErrorException) {
                PackageInfo.LOGGER.log(DistcompLevel.ONE, "Task dispatch failed due to a MATLAB license error.", taskLicenseErrorException);
                this.dispatchFailedExceptionOnWorker(taskImpl, taskLicenseErrorException, (WorkerProxy)identifiable);
            }
            catch (Throwable throwable) {
                PackageInfo.LOGGER.log(DistcompLevel.ONE, "An exception occurred during dispatch of task " + taskImpl.getNum(), throwable);
                this.dispatchFailed(taskImpl);
            }
            finally {
                credentialProviderImpl.unexport();
            }
        }

        private WorkerProxy dispatchBegun(TaskImpl taskImpl) throws MJSException {
            this.iWorkerStillIdle = false;
            WorkerProxy workerProxy = WorkerPool.instance().taskDispatchBegun(this.iWorkerID);
            if (workerProxy != null) {
                try {
                    taskImpl.dispatchBegun(workerProxy);
                }
                catch (MJSException mJSException) {
                    WorkerPool.instance().returnWorkerToIdle(this.iWorkerID);
                    this.iWorkerStillIdle = true;
                    throw mJSException;
                }
            }
            return workerProxy;
        }

        private void dispatchFailed(TaskImpl taskImpl) {
            if (!taskImpl.isFinishedAbnormally()) {
                PackageInfo.LOGGER.log(DistcompLevel.ONE, "Task " + taskImpl.getNum() + " failed to dispatch, but didn't finish abnormally");
                WorkerPool.instance().taskDispatchFailed(this.iWorkerID);
            } else {
                PackageInfo.LOGGER.log(DistcompLevel.ONE, "Task " + taskImpl.getNum() + " finished abnormally during failed dispatch");
                WorkerPool.instance().taskDispatchFailedForAbnormallyFinishedTask(this.iWorkerID, new JobAndTaskIdentifier(this.iJobID, taskImpl));
            }
            taskImpl.dispatchFailed();
        }

        private void dispatchFailedExceptionOnWorker(TaskImpl taskImpl, Exception exception, WorkerProxy workerProxy) {
            taskImpl.dispatchFailed();
            taskImpl.cancel(exception.getMessage());
            WorkerPool.instance().cancelTaskOnWorker(new WorkerTaskInfo(workerProxy, new JobAndTaskIdentifier(this.iJobID, taskImpl)));
        }

        private void dispatchSucceeded(TaskImpl taskImpl) {
            this.iSendSuccessful = true;
            WorkerPool.instance().taskDispatchSucceeded(this.iWorkerID, new JobAndTaskIdentifier(this.iJobID, taskImpl));
            taskImpl.dispatchSucceeded();
        }

        boolean isSendSuccessful() {
            return this.iSendSuccessful;
        }

        boolean isWorkerStillIdle() {
            return this.iWorkerStillIdle;
        }

        Uuid getWorkerID() {
            return this.iWorkerID;
        }
    }
}

