/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.jobmanager;

public final class JobCounter {
    private static JobCounter sJobCounter = null;
    private static int fNumQueuedJobs = 0;
    private static int fNumRunningJobs = 0;

    private JobCounter() {
    }

    static void clear() {
        sJobCounter = null;
    }

    public static JobCounter instance() {
        if (sJobCounter == null) {
            sJobCounter = new JobCounter();
        }
        return sJobCounter;
    }

    public synchronized void incQueuedJobs() {
        ++fNumQueuedJobs;
    }

    public synchronized void decQueuedJobs() {
        --fNumQueuedJobs;
    }

    public synchronized void incRunningJobs() {
        ++fNumRunningJobs;
    }

    public synchronized void decRunningJobs() {
        --fNumRunningJobs;
    }

    public synchronized void incQueuedJobs(int n) {
        fNumQueuedJobs += n;
    }

    public synchronized void decQueuedJobs(int n) {
        fNumQueuedJobs -= n;
    }

    public synchronized void incRunningJobs(int n) {
        fNumRunningJobs += n;
    }

    public synchronized void decRunningJobs(int n) {
        fNumRunningJobs -= n;
    }

    public synchronized boolean queuedOrRunningJobsPresent() {
        return fNumQueuedJobs != 0 || fNumRunningJobs != 0;
    }

    public synchronized int getNumQueuedJobs() {
        return fNumQueuedJobs;
    }

    public synchronized int getNumRunningJobs() {
        return fNumRunningJobs;
    }
}

