/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.cwo;

import com.mathworks.mvm.exec.FutureFevalResult;
import com.mathworks.mvm.exec.MatlabFevalRequest;
import com.mathworks.mvm.exec.MvmExecutionException;
import com.mathworks.toolbox.distcomp.cwo.FevalErrorHandler;
import com.mathworks.toolbox.distcomp.cwo.WriterStack;
import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.util.ArraySerializer;
import com.mathworks.toolbox.distcomp.util.MatlabRefStore;
import com.mathworks.toolbox.distcomp.worker.matlab.PackageInfo;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class FevalGateway {
    private FevalGateway() {
    }

    public static void feval(byte[] byArray) throws Exception {
        List<Object> list = FevalGateway.createLinkedList(ArraySerializer.deserialize(byArray));
        String string = (String)list.remove(0);
        FevalErrorHandler fevalErrorHandler = (FevalErrorHandler)list.remove(0);
        FevalGateway.feval(string, fevalErrorHandler, list);
    }

    public static void feval(String string, FevalErrorHandler fevalErrorHandler, List<Object> list) {
        WriterStack writerStack = new WriterStack();
        writerStack.pushWriter(new OutputStreamWriter(System.out));
        list.add(0, writerStack);
        Object[] objectArray = list.toArray();
        int n = 0;
        MatlabFevalRequest matlabFevalRequest = new MatlabFevalRequest(string, n, (Writer)writerStack, (Writer)writerStack, objectArray);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        executorService.execute(new FevalRunner(matlabFevalRequest, string, fevalErrorHandler));
        executorService.shutdown();
    }

    private static <T> List<T> createLinkedList(T[] TArray) {
        return new LinkedList<T>(Arrays.asList(TArray));
    }

    private static class FevalRunner
    implements Runnable {
        private String fFunction;
        private FevalErrorHandler fFevalErrorHandler;
        private MatlabFevalRequest fMatlabFevalRequest;

        public FevalRunner(MatlabFevalRequest matlabFevalRequest, String string, FevalErrorHandler fevalErrorHandler) {
            this.fFunction = string;
            this.fFevalErrorHandler = fevalErrorHandler;
            this.fMatlabFevalRequest = matlabFevalRequest;
        }

        @Override
        public void run() {
            PackageInfo.LOGGER.log(DistcompLevel.TWO, "FevalGateway: Calling " + this.fFunction);
            FutureFevalResult futureFevalResult = MatlabRefStore.getMVMRef().getExecutor().submit(this.fMatlabFevalRequest);
            try {
                futureFevalResult.get();
            }
            catch (MvmExecutionException mvmExecutionException) {
                this.handleMvmExecutionException(mvmExecutionException, this.fFevalErrorHandler);
            }
            catch (Throwable throwable) {
                PackageInfo.LOGGER.log(DistcompLevel.ONE, "Error submitting fevalRequest: ", throwable);
                this.fFevalErrorHandler.handleError("Error submitting fevalRequest: " + throwable.getMessage());
            }
        }

        private void handleMvmExecutionException(MvmExecutionException mvmExecutionException, FevalErrorHandler fevalErrorHandler) {
            String string = "Error submitting fevalRequest: ";
            if (mvmExecutionException.getCause() != null) {
                PackageInfo.LOGGER.log(DistcompLevel.ONE, "Error submitting fevalRequest (cause inside MATLAB): ", mvmExecutionException.getCause());
                string = string + mvmExecutionException.getCause().getMessage() + System.getProperty("line.separator");
            } else if (mvmExecutionException.getMvmCause() != null) {
                PackageInfo.LOGGER.log(DistcompLevel.ONE, "Error submitting fevalRequest (cause outside MATLAB): " + mvmExecutionException.getMvmCause().getMessage());
                string = string + mvmExecutionException.getMvmCause().getMessage() + System.getProperty("line.separator");
                for (StackTraceElement stackTraceElement : mvmExecutionException.getMvmCause().getStackTrace()) {
                    PackageInfo.LOGGER.log(DistcompLevel.ONE, "Stack trace: " + stackTraceElement.toString());
                    string = string + stackTraceElement.toString() + System.getProperty("line.separator");
                }
            }
            fevalErrorHandler.handleError(string);
        }
    }
}

