/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.clusteraccess;

import com.mathworks.toolbox.distcomp.clusteraccess.SharedPath;
import com.mathworks.toolbox.distcomp.remote.ListFileAttributesFuture;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class MirrorFilesInfo {
    private final int fJobId;
    private final String fRemoteDataLocation;
    private final boolean fMakeRemoteDataLocationOnFirstUse;
    private final File fLocalDataLocation;
    private final Set<SharedPath> fDataFilePaths;
    private final Set<SharedPath> fStateFilePaths;
    private final Set<SharedPath> fExcludeFromUpload;
    private final Set<SharedPath> fExcludeFromMirror;
    private final Set<SharedPath> fExcludeFromRemove;
    private final boolean fDeleteDataFiles;
    private final boolean fDeleteStateFiles;
    private final Lock fLock = new ReentrantLock();
    private final Map<SharedPath, ListFileAttributesFuture.FileAttributes> fSentFiles = new LinkedHashMap<SharedPath, ListFileAttributesFuture.FileAttributes>();

    public MirrorFilesInfo(int n, File file, String string, boolean bl, Set<String> set, Set<String> set2, Set<String> set3, Set<String> set4, Set<String> set5, boolean bl2, boolean bl3) {
        this.fJobId = n;
        this.fRemoteDataLocation = string;
        this.fMakeRemoteDataLocationOnFirstUse = bl;
        this.fLocalDataLocation = file;
        this.fDataFilePaths = SharedPath.relativePathsToSharedPaths(set);
        this.fStateFilePaths = SharedPath.relativePathsToSharedPaths(set2);
        this.fExcludeFromUpload = SharedPath.relativePathsToSharedPaths(set3);
        this.fExcludeFromMirror = SharedPath.relativePathsToSharedPaths(set4);
        this.fExcludeFromRemove = SharedPath.relativePathsToSharedPaths(set5);
        this.fDeleteDataFiles = bl2;
        this.fDeleteStateFiles = bl3;
    }

    public int getJobId() {
        return this.fJobId;
    }

    public File getLocalDataLocation() {
        return this.fLocalDataLocation;
    }

    public String getRemoteDataLocation() {
        return this.fRemoteDataLocation;
    }

    public boolean getMakeRemoteDataLocationOnFirstUse() {
        return this.fMakeRemoteDataLocationOnFirstUse;
    }

    public Set<SharedPath> getDataFilePaths() {
        return this.fDataFilePaths;
    }

    public Set<SharedPath> getStateFilePaths() {
        return this.fStateFilePaths;
    }

    public Set<SharedPath> getExcludeFromUpload() {
        return this.fExcludeFromUpload;
    }

    public Set<SharedPath> getExcludeFromMirror() {
        return this.fExcludeFromMirror;
    }

    public Set<SharedPath> getExcludeFromRemove() {
        return this.fExcludeFromRemove;
    }

    public boolean deleteDataFiles() {
        return this.fDeleteDataFiles;
    }

    public boolean deleteStateFiles() {
        return this.fDeleteStateFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToSentFiles(Map<SharedPath, ListFileAttributesFuture.FileAttributes> map) {
        try {
            this.fLock.lock();
            this.fSentFiles.putAll(map);
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<SharedPath, ListFileAttributesFuture.FileAttributes> getSentFiles() {
        try {
            this.fLock.lock();
            LinkedHashMap<SharedPath, ListFileAttributesFuture.FileAttributes> linkedHashMap = new LinkedHashMap<SharedPath, ListFileAttributesFuture.FileAttributes>(this.fSentFiles);
            return linkedHashMap;
        }
        finally {
            this.fLock.unlock();
        }
    }
}

