/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.testing.model;

import com.mathworks.toolbox.distcomp.admincenter.testing.model.TestResultData;
import com.mathworks.toolbox.distcomp.admincenter.testing.model.TestResultDataFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class TestResultsContainer
implements Serializable {
    static final long serialVersionUID = -1648461134481841012L;
    private final ArrayList<TestResultData> fResults;
    private final Date fStartTime;
    private final Date fStopTime;

    public TestResultsContainer(Date date, Date date2, List<TestResultData> list) {
        this.fStartTime = date;
        this.fStopTime = date2;
        this.fResults = new ArrayList<TestResultData>(list);
    }

    public TestResultData[] getTestResults(TestResultDataFilter testResultDataFilter) {
        if (testResultDataFilter == null) {
            return this.fResults.toArray(new TestResultData[0]);
        }
        ArrayList<TestResultData> arrayList = new ArrayList<TestResultData>();
        for (TestResultData testResultData : this.fResults) {
            if (!testResultDataFilter.include(testResultData)) continue;
            arrayList.add(testResultData);
        }
        return arrayList.toArray(new TestResultData[0]);
    }

    public TestResultData[] getTestResults() {
        return this.getTestResults(null);
    }

    public int getResultsCount() {
        return this.fResults.size();
    }

    public Date getStartTime() {
        return this.fStartTime;
    }

    public Date getStopTime() {
        return this.fStopTime;
    }

    public long getRunTime() {
        return this.fStopTime.getTime() - this.fStartTime.getTime();
    }
}

