/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.testing.infra.test;

import com.mathworks.toolbox.distcomp.admincenter.TimeOutConstants;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.TestCleanupManager;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.internal.CommandSet;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.test.PackageInfo;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.test.Result;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.test.RunIdentifier;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.util.LockingException;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.util.TestFailureException;
import com.mathworks.toolbox.distcomp.admincenter.testing.shared.TestCategory;
import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import java.io.Serializable;

abstract class RunnableTest<TResult extends Result>
implements Serializable {
    private CommandSet fCommandSet = null;
    private String fDescription = null;
    private RunIdentifier fRunID = null;
    private TResult fResult = null;
    private TestCategory fTestCategory = null;
    private long fTimeout;

    public RunnableTest() {
        this(TimeOutConstants.RUNNABLE_TEST_TIMEOUT_MILLIS);
    }

    public RunnableTest(long l) {
        this.setTimeout(l);
    }

    protected RunIdentifier getRunID() {
        return this.fRunID;
    }

    void setRunID(RunIdentifier runIdentifier) {
        this.fRunID = runIdentifier;
    }

    protected abstract TResult createResult();

    protected abstract void run();

    public final void failedToRun(Exception exception) {
        if (this.getResult() != null) {
            return;
        }
        TResult TResult = this.createResult();
        ((Result)TResult).setFailure(exception);
        this.setResult(TResult);
    }

    public final void startTest() {
        this.log("Calling startTest for " + this.getDescription());
        try {
            TestCleanupManager.instance().validateRunID(this.fRunID);
        }
        catch (LockingException lockingException) {
            this.failedToRun(lockingException);
            return;
        }
        final Throwable[] throwableArray = new Throwable[1];
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    RunnableTest.this.run();
                }
                catch (Throwable throwable) {
                    throwableArray[0] = throwable;
                }
            }
        });
        thread.start();
        try {
            thread.join(this.getTimeout());
        }
        catch (InterruptedException interruptedException) {
            String string = this.getDescription() + " has been interrupted.";
            this.failedToRun(new TestFailureException(string));
        }
        if (thread.isAlive()) {
            this.log("Calling interrupt for " + this.getDescription() + "because we have timed out (" + this.getTimeout() + " milliseconds)");
            thread.interrupt();
            String string = "Timeout (" + this.getTimeout() + " milliseconds)" + " occurred while waiting for " + this.getDescription() + " to finish.";
            this.failedToRun(new TestFailureException(string));
            this.log("The test " + this.getDescription() + " did not finish properly due to " + string);
        } else if (throwableArray[0] != null) {
            String string = "Runnable test did not finish properly.";
            this.failedToRun(new TestFailureException(string));
            this.log("The test " + this.getDescription() + "did not finish properly due to " + throwableArray[0]);
        } else {
            this.log("The test " + this.getDescription() + "finished properly.");
        }
    }

    public String getDescription() {
        return this.fDescription;
    }

    public void setDescription(String string) {
        assert (string != null) : "attempt to setDescription to null";
        this.fDescription = string;
    }

    public CommandSet getCommandSet() {
        return this.fCommandSet;
    }

    public void setCommandSet(CommandSet commandSet) {
        this.fCommandSet = commandSet;
    }

    public TestCategory getTestCategory() {
        return this.fTestCategory;
    }

    public void setTestCategory(TestCategory testCategory) {
        assert (testCategory != null) : "attempt to setTestCategory to null";
        this.fTestCategory = testCategory;
    }

    public String toString() {
        return this.getDescription() + " (" + (Object)((Object)this.getTestCategory()) + ")";
    }

    public TResult getResult() {
        return this.fResult;
    }

    protected void setResult(TResult TResult) {
        assert (TResult != null) : "attempt to setResult to null";
        this.fResult = TResult;
    }

    private long getTimeout() {
        return this.fTimeout;
    }

    protected void setTimeout(long l) {
        assert (l >= 0L) : "Timeout was set to invalid value " + l;
        this.fTimeout = l;
    }

    protected void log(String string) {
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, this.getDescription() + ": " + string);
    }

    protected void warn(String string, Exception exception) {
        PackageInfo.LOGGER.log(DistcompLevel.ONE, this.getDescription() + ": " + string + " (" + exception.toString() + ")");
    }
}

