/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.testing.infra.test;

import com.mathworks.toolbox.distcomp.admincenter.TimeOutConstants;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.test.ResolveHostnameResult;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.test.RunnableTest;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.util.TestFailureException;
import java.io.Serializable;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Set;
import java.util.Vector;

class ResolveHostname
extends RunnableTest<ResolveHostnameResult> {
    private String fHostname = null;
    private Boolean fIsLoopbackTest = null;
    private Boolean fUseIPv6 = null;

    public ResolveHostname(String string, Boolean bl, Boolean bl2) {
        super(TimeOutConstants.RESOLVE_HOSTNAME_TIMEOUT_MILLIS);
        this.fHostname = string;
        this.fIsLoopbackTest = bl2;
        this.fUseIPv6 = bl;
    }

    @Override
    protected ResolveHostnameResult createResult() {
        return new ResolveHostnameResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void run() {
        ResolveHostnameResult resolveHostnameResult = this.createResult();
        try {
            Serializable serializable;
            if (this.getCommandSet().getLocalHostName().equalsIgnoreCase("localhost")) {
                throw new TestFailureException("The hostname " + this.fHostname + " resolves " + "locally to 'localhost'.");
            }
            if (this.getCommandSet().isLoopbackAddress(this.fHostname).booleanValue()) {
                throw new TestFailureException("The current machine (" + this.fHostname + ") resolves " + "to a loopback address.");
            }
            String string = this.getCommandSet().getCanonicalHostName(this.fHostname);
            Set<InetAddress> set = this.getCommandSet().getAddressList(this.fHostname);
            Object object = set.iterator();
            while (object.hasNext()) {
                serializable = (InetAddress)object.next();
                if (!(this.fUseIPv6 ^ serializable instanceof Inet6Address)) continue;
                object.remove();
            }
            object = new Vector();
            serializable = new Vector();
            for (InetAddress inetAddress : set) {
                if (inetAddress.isLoopbackAddress()) {
                    ((Vector)object).add(inetAddress);
                    continue;
                }
                ((Vector)serializable).add(inetAddress);
            }
            if (this.fIsLoopbackTest.booleanValue()) {
                if (((Vector)serializable).isEmpty()) {
                    resolveHostnameResult.addInfo("No non-local IP address found.");
                }
            } else {
                if (((Vector)serializable).isEmpty()) {
                    throw new TestFailureException("No non-local IP address found.");
                }
                if (!((Vector)object).isEmpty()) {
                    resolveHostnameResult.addWarning("Hostname " + this.fHostname + " resolves " + "to local addresses " + object);
                }
            }
            if (((Vector)serializable).size() > 1) {
                resolveHostnameResult.addInfo("Multiple IP addresses found: " + serializable);
            }
            resolveHostnameResult.setHostname(System.getProperty("com.mathworks.toolbox.distcomp.hostname", ""));
            resolveHostnameResult.setCanonicalHostname(string);
            resolveHostnameResult.setAddressList((Collection<InetAddress>)((Object)serializable));
            resolveHostnameResult.setSuccess();
        }
        catch (Exception exception) {
            this.log("Unable to resolve hostname (" + this.fHostname + ") due to " + exception.getMessage());
            resolveHostnameResult.setFailure(exception);
        }
        finally {
            this.setResult(resolveHostnameResult);
        }
    }
}

