/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.testing.infra;

import com.mathworks.toolbox.distcomp.admincenter.testing.infra.CompletionObserver;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.PackageInfo;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.test.Test;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.test.Uncancellable;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.util.AlreadyInUseException;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.util.UnresolvableDependencyException;
import com.mathworks.toolbox.distcomp.admincenter.testing.shared.TestCategory;
import com.mathworks.toolbox.distcomp.admincenter.testing.shared.TestingToken;
import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.util.concurrent.NamedThreadFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

class TestExecutor
implements TestingToken {
    private static AtomicBoolean alreadyInUse = new AtomicBoolean();
    private final int DEFAULT_CHECK_THREAD_POOLSIZE = 1;
    private final int DEFAULT_TEST_THREAD_POOLSIZE = 16;
    private final int DEFAULT_RESUBMISSION_DELAY_MILLIS = 500;
    private CompletionObserver fCallback = null;
    private ScheduledExecutorService fCheckExecutor = null;
    private boolean fIsCancelled = false;
    private AtomicInteger fNumActiveTests = null;
    private Collection<Test> fTestCollection;
    private ExecutorService fTestExecutor = null;

    public TestExecutor(CompletionObserver completionObserver) throws AlreadyInUseException {
        this.initialize(completionObserver, 1, 16);
    }

    public TestExecutor(CompletionObserver completionObserver, int n, int n2) throws AlreadyInUseException {
        this.initialize(completionObserver, n, n2);
    }

    @Override
    public synchronized void cancel() {
        if (this.isDone() || this.isCancelled()) {
            this.log(DistcompLevel.TWO, "Ignoring cancel command (already done or cancelled).");
        } else {
            this.log(DistcompLevel.TWO, "Received cancel command. Shutting down.");
            this.fIsCancelled = true;
        }
    }

    @Override
    public synchronized boolean isCancelled() {
        return this.fIsCancelled;
    }

    @Override
    public boolean isDone() {
        assert (this.fTestCollection != null) : "No tests have been submitted yet.";
        return this.allActiveTestsFinished();
    }

    public HashMap<TestCategory, Integer> getExpectedResultCounts() {
        HashMap<TestCategory, Integer> hashMap = new HashMap<TestCategory, Integer>();
        for (Test test : this.fTestCollection) {
            Integer n = hashMap.get((Object)test.getTestCategory());
            if (n == null) {
                n = 0;
            }
            hashMap.put(test.getTestCategory(), n + 1);
        }
        return hashMap;
    }

    void submit(Collection<Test> collection) throws AlreadyInUseException {
        if (this.fTestCollection != null) {
            throw new AlreadyInUseException("Tests already submitted");
        }
        this.fTestCollection = collection;
        this.incrementActiveTests(collection.size());
        for (Test test : collection) {
            this.log(DistcompLevel.SIX, "received for execution: " + test);
            Future<?> future = this.fCheckExecutor.submit(this.createCheckRunnable(test));
            test.setFuture(future);
        }
    }

    private void initialize(CompletionObserver completionObserver, int n, int n2) throws AlreadyInUseException {
        if (!alreadyInUse.compareAndSet(false, true)) {
            throw new AlreadyInUseException("TestExecutor is already in use");
        }
        NamedThreadFactory namedThreadFactory = new NamedThreadFactory("AdminCenter TestExecutor", PackageInfo.LOGGER);
        this.fCallback = completionObserver;
        this.fCheckExecutor = Executors.newScheduledThreadPool(n);
        this.fTestExecutor = Executors.newFixedThreadPool(n2, namedThreadFactory);
        this.fNumActiveTests = new AtomicInteger(0);
    }

    private Runnable createCheckRunnable(final Test test) {
        return new Runnable(){

            @Override
            public void run() {
                TestExecutor.this.log(DistcompLevel.FIVE, "check if ready: " + test);
                if (TestExecutor.this.isCancelled() && !(test instanceof Uncancellable)) {
                    test.skip("test suite is being shut down.");
                }
                try {
                    if (test.isReadyToRun()) {
                        TestExecutor.this.log(DistcompLevel.FIVE, "The test " + test + "has been submitted to run.");
                        TestExecutor.this.fTestExecutor.execute(TestExecutor.this.createTestRunnable(test));
                    } else {
                        TestExecutor.this.fCheckExecutor.schedule(TestExecutor.this.createCheckRunnable(test), 500L, TimeUnit.MILLISECONDS);
                    }
                }
                catch (Throwable throwable) {
                    String string = throwable instanceof UnresolvableDependencyException ? "skipped by TestExecutor due to unresolvable dependencies (" + throwable + ")" : "skipped by TestExecutor before running (" + throwable + ")";
                    TestExecutor.this.log(DistcompLevel.TWO, string + ": " + test);
                    test.skip(string);
                    TestExecutor.this.decrementActiveTests();
                    TestExecutor.this.checkAndCleanup();
                }
            }
        };
    }

    private Runnable createTestRunnable(final Test test) {
        return new Runnable(){

            @Override
            public void run() {
                TestExecutor.this.log(DistcompLevel.FOUR, "starting " + test);
                try {
                    test.sendAndRun();
                }
                catch (Throwable throwable) {
                    String string = throwable instanceof UnresolvableDependencyException ? "skipped by TestExecutor due to unresolved dependencies (" + throwable + ")" : "skipped by TestExecutor after aborting (" + throwable + ")";
                    TestExecutor.this.log(DistcompLevel.TWO, string + ": " + test);
                    test.skip(string);
                }
                TestExecutor.this.decrementActiveTests();
                TestExecutor.this.checkAndCleanup();
            }
        };
    }

    private synchronized void checkAndCleanup() {
        if (this.isDone()) {
            this.log(DistcompLevel.TWO, "shutting down");
            this.fCheckExecutor.shutdown();
            this.fTestExecutor.shutdown();
            alreadyInUse.set(false);
            this.fCallback.allComplete();
        }
    }

    private void incrementActiveTests(int n) {
        this.fNumActiveTests.addAndGet(n);
    }

    private void decrementActiveTests() {
        this.fNumActiveTests.decrementAndGet();
    }

    private boolean allActiveTestsFinished() {
        return this.fNumActiveTests.get() == 0;
    }

    private void log(Level level, String string) {
        PackageInfo.LOGGER.log(level, "TestExecutor: " + string);
    }

    Collection<Test> getTestCollection() {
        return this.fTestCollection;
    }
}

