/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.testing.infra;

import com.mathworks.toolbox.distcomp.admincenter.TimeOutConstants;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.PackageInfo;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.test.CleanableTest;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.test.RunIdentifier;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.util.CleanupFailureException;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.util.LockingException;
import com.mathworks.toolbox.distcomp.admincenter.testing.shared.TestCategory;
import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import java.util.Vector;
import java.util.logging.Level;

public class TestCleanupManager {
    private Vector<CleanableTest> fTestVector = null;
    private Watchdog fWatchdog = null;
    private static TestCleanupManager sTestCleanupManager = null;
    private final RunIdentifier fDefaultRunID = new RunIdentifier();
    private boolean fLockedForTesting = false;
    private RunIdentifier fRunID = this.fDefaultRunID;

    private TestCleanupManager() {
        this.fTestVector = new Vector();
        this.fWatchdog = new Watchdog(TimeOutConstants.WATCHDOG_TIMEOUT_MILLIS);
    }

    public static synchronized TestCleanupManager instance() {
        if (sTestCleanupManager == null) {
            sTestCleanupManager = new TestCleanupManager();
        }
        return sTestCleanupManager;
    }

    public synchronized void lockDownForTesting(RunIdentifier runIdentifier) throws LockingException {
        this.log(DistcompLevel.TWO, "received lock down command. Currently locked: " + this.fLockedForTesting);
        if (!this.fLockedForTesting) {
            this.validateRunID(runIdentifier);
            this.lockDown(runIdentifier);
            try {
                this.fWatchdog.wakeup();
            }
            catch (Exception exception) {
                this.releaseLock();
                throw new LockingException("could not wake up watchdog", exception);
            }
            return;
        }
        throw new LockingException("Unable to lock MDCS as it is already in lockdown. Another test is probably running.");
    }

    public synchronized void releaseLockDownForTesting(RunIdentifier runIdentifier) throws LockingException {
        this.log(DistcompLevel.TWO, "received release command. Currently locked: " + this.fLockedForTesting);
        if (this.fLockedForTesting) {
            this.validateRunID(runIdentifier);
            this.releaseLock();
            try {
                this.fWatchdog.sleep();
            }
            catch (Exception exception) {
                this.log(DistcompLevel.TWO, "watchdog died prematurely: " + exception.toString());
            }
            return;
        }
        throw new LockingException("MDCS was not in lockdown");
    }

    public void validateRunID(RunIdentifier runIdentifier) throws LockingException {
        if (this.fRunID != this.fDefaultRunID && !this.fRunID.equals(runIdentifier)) {
            throw new LockingException("Invalid RunIdentifier received.");
        }
    }

    private void lockDown(RunIdentifier runIdentifier) {
        this.fLockedForTesting = true;
        this.fRunID = runIdentifier;
        this.log(DistcompLevel.TWO, "locked down");
    }

    private void releaseLock() {
        this.fLockedForTesting = false;
        this.fRunID = this.fDefaultRunID;
        this.log(DistcompLevel.TWO, "lock released");
    }

    public void addTestToCleanupManager(CleanableTest cleanableTest, RunIdentifier runIdentifier) throws LockingException {
        this.validateRunID(runIdentifier);
        this.fWatchdog.reset();
        this.log(DistcompLevel.FOUR, "adding cleanable test " + cleanableTest);
        this.fTestVector.addElement(cleanableTest);
    }

    public synchronized void cleanupTests(TestCategory testCategory, RunIdentifier runIdentifier) throws CleanupFailureException, LockingException {
        this.validateRunID(runIdentifier);
        this.fWatchdog.reset();
        this.log(DistcompLevel.FOUR, "contains " + this.fTestVector.size() + " cleanable test(s).");
        Vector<CleanupFailureException> vector = new Vector<CleanupFailureException>();
        Object object = this.fTestVector.iterator();
        while (object.hasNext()) {
            CleanableTest cleanableTest = object.next();
            if (!cleanableTest.getTestCategory().equals((Object)testCategory)) continue;
            try {
                this.log(DistcompLevel.FOUR, "cleaning up " + cleanableTest);
                object.remove();
                cleanableTest.cleanup();
            }
            catch (CleanupFailureException cleanupFailureException) {
                vector.add(cleanupFailureException);
            }
        }
        if (!vector.isEmpty()) {
            object = "TestCleanupManager failed to clean up following tests: " + vector;
            this.log(DistcompLevel.ONE, (String)object);
            throw new CleanupFailureException((String)object);
        }
        this.log(DistcompLevel.FOUR, "finished cleaning up.");
    }

    public void log(Level level, String string) {
        PackageInfo.LOGGER.log(level, "TestCleanupManager: " + string);
    }

    private class Watchdog
    implements Runnable {
        private long fEndTime;
        private boolean fOnDuty;
        private final long fTimeout;
        private Thread fThread = null;

        public Watchdog(long l) {
            this.fTimeout = l;
            this.fOnDuty = false;
            this.reset();
        }

        public void reset() {
            this.fEndTime = System.currentTimeMillis() + this.fTimeout;
        }

        public void wakeup() {
            this.fThread = new Thread(this);
            this.fOnDuty = true;
            this.fThread.start();
        }

        public void sleep() throws Exception {
            if (!this.fThread.isAlive()) {
                throw new Exception("Watchdog is dead.");
            }
            this.fOnDuty = false;
        }

        @Override
        public void run() {
            this.reset();
            while (this.fOnDuty) {
                if (System.currentTimeMillis() > this.fEndTime) {
                    TestCleanupManager.this.log(DistcompLevel.TWO, "watchdog timeout occurred. Releasing the lockdown.");
                    TestCleanupManager.this.releaseLock();
                    this.fOnDuty = false;
                }
                try {
                    Thread.sleep(TimeOutConstants.WATCHDOG_RUN_THREAD_SLEEP_MILLIS);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

