/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.services.model;

import com.mathworks.toolbox.distcomp.admincenter.services.model.ServiceDetailModel;
import com.mathworks.toolbox.distcomp.admincenter.services.model.StatusModel;
import com.mathworks.toolbox.distcomp.admincenter.services.model.WorkerDetailProperty;
import com.mathworks.toolbox.distcomp.control.serviceinfo.WorkerServiceInfo;

public class WorkerDetailModel
extends ServiceDetailModel<WorkerServiceInfo> {
    protected WorkerDetailModel() {
        super(WorkerDetailProperty.class);
    }

    @Override
    public Object getValue(WorkerServiceInfo workerServiceInfo, ServiceDetailModel.Property<WorkerServiceInfo> property) {
        switch ((WorkerDetailProperty)property) {
            case HOST: {
                return this.getBestHostname(workerServiceInfo);
            }
            case NAME: {
                return workerServiceInfo.getServiceName();
            }
            case STATUS: {
                return StatusModel.getWorkerStatusModel(workerServiceInfo);
            }
        }
        switch (workerServiceInfo.getStatus()) {
            case RUNNING: {
                switch ((WorkerDetailProperty)property) {
                    case FILE_DEP_DIR: {
                        return workerServiceInfo.getFileDependenciesDir();
                    }
                    case JOB_MANAGER: {
                        return workerServiceInfo.getJobManagerName();
                    }
                    case JOB_MANAGER_CONNECTION: {
                        return StatusModel.getWorkerConnectionStatusModel(workerServiceInfo);
                    }
                    case JOB_MANAGER_HOST: {
                        return workerServiceInfo.getJobManagerHostName();
                    }
                    case PORT: {
                        return workerServiceInfo.getPort();
                    }
                    case LOOKUP_URLS_IN_CONFIG: {
                        return this.getLookupURLsInConfiguration(workerServiceInfo);
                    }
                    case LOOKUP_URLS: {
                        return workerServiceInfo.getLookupURLs();
                    }
                    case STARTUP_DIR: {
                        return workerServiceInfo.getWorkDir();
                    }
                    case START_TIME: {
                        return workerServiceInfo.getStartTime();
                    }
                }
                return null;
            }
        }
        return null;
    }
}

