/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.services.model;

import com.mathworks.jmi.Matlab;
import com.mathworks.toolbox.distcomp.control.servicerequest.MdceShellCommand;
import com.mathworks.toolbox.distcomp.remote.Command;
import com.mathworks.toolbox.distcomp.remote.NoCommonProtocolSetException;
import com.mathworks.toolbox.distcomp.remote.ParameterMap;
import com.mathworks.toolbox.distcomp.remote.ParameterSet;
import com.mathworks.toolbox.distcomp.remote.RemoteExecutor;
import com.mathworks.toolbox.distcomp.remote.util.NetworkInfo;
import com.mathworks.toolbox.distcomp.remote.util.PathUtils;
import com.mathworks.util.NativeJava;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class StartMDCEWizardModel {
    private List<String> fHostNames;
    private PathUtils.PlatformType fPlatformType;
    private String fMatlabRoot;
    private boolean fTypingMatlabRoot;
    private String fTypingMatlabRootValue;
    private boolean fUseDefaultMdceDefFile;
    private String fUserDefinedMdceDefFile;
    private boolean fTypingUserDefinedMdceDefFile;
    private String fTypingUserDefinedMdceDefFileValue;
    private ParameterMap fParameterMap;
    private final int fBasePort;
    private PropertyChangeSupport fPropertyChangeSupport;
    public static final String PLATFORM_CHANGED_PROPERTY = "Wizard_PlatformChanged";
    public static final String MATLABROOT_CHANGED_PROPERTY = "Wizard_MatlabRootChanged";
    public static final String MATLABROOT_TYPING_PROPERTY = "Wizard_MatlabRootTyping";
    public static final String PARAMETERMAP_CHANGED_PROPERTY = "Wizard_ParameterMapChanged";
    public static final String USER_DEFINED_MDCE_DEF_FILE_CHANGED_PROPERTY = "Wizard_UserDefinedMDCEDefChanged";
    public static final String USER_DEFINED_MDCE_DEF_FILE_TYPING_PROPERTY = "Wizard_UserDefinedMDCEDefTyping";
    public static final String USE_DEFAULT_MDCE_DEF_FILE_CHANGED_PROPERTY = "Wizard_UseDefaultMDCEDefChanged";
    public static final String DEFAULT_WINDOWS_MDCE_DEFFILE_PATH = "toolbox\\distcomp\\bin\\mdce_def.bat";
    public static final String DEFAULT_UNIX_MDCE_DEFFILE_PATH = "toolbox/distcomp/bin/mdce_def.sh";

    public StartMDCEWizardModel(List<String> list, int n) {
        this.fHostNames = list;
        this.fBasePort = n;
        this.fPlatformType = PathUtils.Platform.getLocal().getPlatformType();
        this.fMatlabRoot = this.resolveMatlabrootWithTrailingSlash(this.resolveMappedDrive(StartMDCEWizardModel.getLocalMatlabRoot()));
        this.fUseDefaultMdceDefFile = true;
        this.fUserDefinedMdceDefFile = "";
        this.fPropertyChangeSupport = new PropertyChangeSupport(this);
        this.fParameterMap = new ParameterMap();
    }

    public List<String> getHostNames() {
        return Collections.unmodifiableList(this.fHostNames);
    }

    public PathUtils.PlatformType getPlatformType() {
        return this.fPlatformType;
    }

    public void setPlatformType(PathUtils.PlatformType platformType) {
        PathUtils.PlatformType platformType2 = this.fPlatformType;
        this.fPlatformType = platformType;
        if (!platformType2.equals((Object)this.fPlatformType)) {
            this.fMatlabRoot = this.fPlatformType.equals((Object)PathUtils.Platform.getLocal().getPlatformType()) ? this.resolveMatlabrootWithTrailingSlash(StartMDCEWizardModel.getLocalMatlabRoot()) : "";
            this.fUseDefaultMdceDefFile = true;
            this.fUserDefinedMdceDefFile = "";
            this.fParameterMap = new ParameterMap();
            this.fPropertyChangeSupport.firePropertyChange(PLATFORM_CHANGED_PROPERTY, (Object)platformType2, (Object)this.fPlatformType);
        }
    }

    public String getMatlabRoot() {
        return this.fMatlabRoot;
    }

    public void setMatlabRoot(String string) {
        String string2 = this.fPlatformType.getDefaultSeparator().convertSeparators(string);
        string2 = this.resolveMatlabrootWithTrailingSlash(string2);
        string2 = this.resolveMappedDrive(string2);
        string2 = this.resolveMatlabrootWithTrailingSlash(string2);
        String string3 = this.fMatlabRoot;
        this.fMatlabRoot = string2;
        this.fTypingMatlabRoot = false;
        if (!string2.equals(string) && string2.equals(this.fMatlabRoot)) {
            this.fPropertyChangeSupport.firePropertyChange(MATLABROOT_CHANGED_PROPERTY, null, this.fMatlabRoot);
        } else {
            this.fPropertyChangeSupport.firePropertyChange(MATLABROOT_CHANGED_PROPERTY, string3, this.fMatlabRoot);
        }
    }

    public void typingMatlabRoot(String string) {
        string = this.fPlatformType.getDefaultSeparator().convertSeparators(string);
        string = this.resolveMatlabrootWithTrailingSlash(string);
        this.fTypingMatlabRoot = true;
        String string2 = this.fTypingMatlabRootValue;
        this.fTypingMatlabRootValue = string;
        this.fPropertyChangeSupport.firePropertyChange(MATLABROOT_TYPING_PROPERTY, string2, this.fTypingMatlabRootValue);
    }

    private String resolveMatlabrootWithTrailingSlash(String string) {
        if (string.isEmpty()) {
            return string;
        }
        if (this.getPlatformType().equals((Object)PathUtils.PlatformType.WINDOWS)) {
            if (!string.endsWith(PathUtils.Separator.BACKSLASH.toString())) {
                string = string + (Object)((Object)PathUtils.Separator.BACKSLASH);
            }
        } else if (!string.endsWith(PathUtils.Separator.SLASH.toString())) {
            string = string + (Object)((Object)PathUtils.Separator.SLASH);
        }
        return string;
    }

    private String resolveMappedDrive(String string) {
        if (string.isEmpty()) {
            return string;
        }
        if (!this.getPlatformType().isWindows() || string.startsWith("\\\\") || !PathUtils.Platform.getLocal().getPlatformType().isWindows()) {
            return string;
        }
        File file = new File(string);
        if (!file.isAbsolute()) {
            return string;
        }
        File file2 = NativeJava.resolveMappedDriveToUnc((String)string);
        try {
            string = file2.getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }

    public String getMdceDefFile() {
        String string = this.fUseDefaultMdceDefFile ? this.getDefaultMdceDefFile() : this.fUserDefinedMdceDefFile;
        return string;
    }

    public boolean isUseDefaultMdceDefFile() {
        return this.fUseDefaultMdceDefFile;
    }

    public void setUseDefaultMdceDefFile(boolean bl) {
        boolean bl2 = this.fUseDefaultMdceDefFile;
        this.fUseDefaultMdceDefFile = bl;
        this.fPropertyChangeSupport.firePropertyChange(USE_DEFAULT_MDCE_DEF_FILE_CHANGED_PROPERTY, bl2, this.fUseDefaultMdceDefFile);
    }

    public String getUserDefinedMdceDefFile() {
        return this.fUserDefinedMdceDefFile;
    }

    public void setUserDefinedMdceDefFile(String string) {
        string = this.fPlatformType.getDefaultSeparator().convertSeparators(string);
        string = this.resolveMappedDrive(string);
        String string2 = this.fUserDefinedMdceDefFile;
        this.fUserDefinedMdceDefFile = string;
        this.fTypingUserDefinedMdceDefFile = false;
        this.fPropertyChangeSupport.firePropertyChange(USER_DEFINED_MDCE_DEF_FILE_CHANGED_PROPERTY, string2, this.fUserDefinedMdceDefFile);
    }

    public void typingUserDefinedMdceDefFile(String string) {
        this.fTypingUserDefinedMdceDefFile = true;
        String string2 = this.fTypingUserDefinedMdceDefFileValue;
        this.fTypingUserDefinedMdceDefFileValue = string;
        this.fPropertyChangeSupport.firePropertyChange(USER_DEFINED_MDCE_DEF_FILE_TYPING_PROPERTY, string2, string);
    }

    public String getDefaultMdceDefFile() {
        return this.createDefaultPathToMdceDefFile(this.fMatlabRoot);
    }

    public String getDefaultMdceDefFileWhileTyping() {
        return this.createDefaultPathToMdceDefFile(this.fTypingMatlabRootValue);
    }

    private String createDefaultPathToMdceDefFile(String string) {
        String string2 = string;
        if (string2 != null && !string2.isEmpty()) {
            string2 = this.getPlatformType().equals((Object)PathUtils.PlatformType.WINDOWS) ? string2 + DEFAULT_WINDOWS_MDCE_DEFFILE_PATH : string2 + DEFAULT_UNIX_MDCE_DEFFILE_PATH;
        }
        return string2;
    }

    public static ParameterSet getParameterSet(PathUtils.PlatformType platformType) {
        ParameterSet parameterSet;
        block2: {
            HashSet<Class<? extends Command>> hashSet = new HashSet<Class<? extends Command>>();
            hashSet.add(MdceShellCommand.class);
            parameterSet = null;
            try {
                parameterSet = RemoteExecutor.getParameterSet(platformType, hashSet);
            }
            catch (NoCommonProtocolSetException noCommonProtocolSetException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)"For MDCEShellCommand there should be a common protocol set.");
            }
        }
        return parameterSet;
    }

    public ParameterMap getParameterMap() {
        return this.fParameterMap;
    }

    public void setParameterMap(ParameterMap parameterMap) {
        ParameterMap parameterMap2 = this.fParameterMap;
        this.fParameterMap = parameterMap;
        this.fPropertyChangeSupport.firePropertyChange(PARAMETERMAP_CHANGED_PROPERTY, parameterMap2, this.fParameterMap);
    }

    public int getBasePort() {
        return this.fBasePort;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fPropertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.fPropertyChangeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fPropertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    private static String getLocalMatlabRoot() {
        if (Matlab.isMatlabAvailable()) {
            return Matlab.matlabRoot();
        }
        return System.getProperty("matlabroot");
    }

    public boolean containsOnlyLocalHostname() {
        boolean bl;
        block5: {
            bl = false;
            try {
                if (this.fHostNames.size() == 1 && NetworkInfo.isHostnameLocal(this.fHostNames.get(0))) {
                    bl = true;
                }
            }
            catch (SocketException socketException) {
                assert (false) : socketException.getMessage();
            }
            catch (UnknownHostException unknownHostException) {
                if ($assertionsDisabled) break block5;
                throw new AssertionError((Object)unknownHostException.getMessage());
            }
        }
        return bl;
    }

    public boolean isLocationPageValid() {
        if (this.fTypingMatlabRoot ? this.fTypingMatlabRootValue.isEmpty() : this.fMatlabRoot.isEmpty()) {
            return false;
        }
        if (this.fUseDefaultMdceDefFile) {
            return true;
        }
        if (this.fTypingUserDefinedMdceDefFile) {
            return !this.fTypingUserDefinedMdceDefFileValue.isEmpty();
        }
        return !this.fUserDefinedMdceDefFile.isEmpty();
    }
}

