/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.instutil.wizard;

import com.mathworks.instutil.wizard.ClickDefaultButtonAction;
import com.mathworks.instutil.wizard.ComponentName;
import com.mathworks.instutil.wizard.ContextMenu;
import com.mathworks.instutil.wizard.ContextMenuAction;
import com.mathworks.instutil.wizard.ContextMenuListener;
import com.mathworks.instutil.wizard.ExceptionHandler;
import com.mathworks.instutil.wizard.SelectAllOnFocusListener;
import com.mathworks.instutil.wizard.TextComponentConfigurator;
import com.mathworks.instutil.wizard.TextComponentDropTarget;
import com.mathworks.instutil.wizard.TextComponentFactory;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.ParseException;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.JTextComponent;
import javax.swing.text.MaskFormatter;

public final class TextComponentFactoryImpl
implements TextComponentFactory,
TextComponentConfigurator {
    private final ExceptionHandler exceptionHandler;
    private final SelectAllOnFocusListener.SelectAllBehavior selectAllOnFocusBehavior;
    private ContextMenu menu;
    private ContextMenuListener listener;
    static final String CONTEXT_KEY = "context";

    public TextComponentFactoryImpl(ExceptionHandler exceptionHandler, SelectAllOnFocusListener.SelectAllBehavior selectAllBehavior) {
        this.exceptionHandler = exceptionHandler;
        this.selectAllOnFocusBehavior = selectAllBehavior;
        this.menu = new ContextMenu();
        this.listener = new ContextMenuListener(this.menu);
    }

    @Override
    public JTextComponent createActivationKeyField(ComponentName componentName, String string) {
        MaskFormatter maskFormatter;
        try {
            maskFormatter = new MyMaskFormatter("AAAAA-AAAAA-AAAAA-AAAAA-AAAAA");
        }
        catch (ParseException parseException) {
            maskFormatter = new MaskFormatter();
            this.exceptionHandler.handleException(parseException);
        }
        return this.createFormattedTextField(componentName, string, "AAAAA-AAAAA-AAAAA-AAAAA-AAAAA", "A", maskFormatter);
    }

    @Override
    public JTextComponent createPortNumberField(ComponentName componentName, String string) {
        MaskFormatter maskFormatter;
        try {
            maskFormatter = new MyMaskFormatter("#####"){

                @Override
                public Object stringToValue(String string) throws ParseException {
                    this.setMask(this.getMaskForString(string));
                    Object object = super.stringToValue(string.substring(0, this.getMask().length()));
                    this.setMask("#####");
                    return object;
                }

                private String getMaskForString(String string) {
                    StringBuilder stringBuilder = new StringBuilder();
                    if (string.length() <= 5) {
                        for (char c : string.trim().toCharArray()) {
                            stringBuilder.append('#');
                        }
                    }
                    return stringBuilder.toString();
                }
            };
        }
        catch (ParseException parseException) {
            maskFormatter = new MaskFormatter();
            this.exceptionHandler.handleException(parseException);
        }
        return this.createFormattedTextField(componentName, string, "#####", "#", maskFormatter);
    }

    @Override
    public JTextComponent createSerialNumberField(ComponentName componentName, String string) {
        MaskFormatter maskFormatter;
        try {
            maskFormatter = new MyMaskFormatter("#### - #### - #### - #### - ####");
        }
        catch (ParseException parseException) {
            maskFormatter = new MaskFormatter();
            this.exceptionHandler.handleException(parseException);
        }
        return this.createFormattedTextField(componentName, string, "#### - #### - #### - #### - ####", "#", maskFormatter);
    }

    @Override
    public void enableDragAndDrop(JComponent jComponent, JTextComponent jTextComponent) {
        TextComponentDropTarget textComponentDropTarget = new TextComponentDropTarget(this.exceptionHandler, jTextComponent);
        new DropTarget(jTextComponent, 3, textComponentDropTarget);
        new DropTarget(jComponent, 3, textComponentDropTarget);
    }

    private JTextComponent createFormattedTextField(ComponentName componentName, String string, final String string2, final String string3, final JFormattedTextField.AbstractFormatter abstractFormatter) {
        final JFormattedTextField jFormattedTextField = new JFormattedTextField(){

            @Override
            public void commitEdit() throws ParseException {
                super.commitEdit();
                new ClickDefaultButtonAction(this).actionPerformed(null);
            }

            @Override
            protected void processMouseMotionEvent(MouseEvent mouseEvent) {
                try {
                    super.processMouseMotionEvent(mouseEvent);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    TextComponentFactoryImpl.this.exceptionHandler.logException(arrayIndexOutOfBoundsException);
                }
            }

            @Override
            protected void processMouseEvent(MouseEvent mouseEvent) {
                try {
                    super.processMouseEvent(mouseEvent);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    TextComponentFactoryImpl.this.exceptionHandler.logException(arrayIndexOutOfBoundsException);
                }
            }

            @Override
            public void selectAll() {
                this.onlySelectAllIfFormattedTextFieldIsNotEmpty();
            }

            private void onlySelectAllIfFormattedTextFieldIsNotEmpty() {
                if (!TextComponentFactoryImpl.formattedTextFieldIsEmpty(string2, string3, this)) {
                    super.selectAll();
                }
            }
        };
        this.setupSelectAllOnFocusListener(jFormattedTextField);
        jFormattedTextField.setFormatterFactory(new JFormattedTextField.AbstractFormatterFactory(){

            @Override
            public JFormattedTextField.AbstractFormatter getFormatter(JFormattedTextField jFormattedTextField) {
                return abstractFormatter;
            }
        });
        jFormattedTextField.setFocusLostBehavior(3);
        jFormattedTextField.getAccessibleContext().setAccessibleName(string);
        FontUIResource fontUIResource = (FontUIResource)UIManager.get("TextField.font");
        int n = fontUIResource.getStyle();
        int n2 = fontUIResource.getSize();
        Font font = new Font("Monospaced", n, n2);
        jFormattedTextField.setFont(font);
        Dimension dimension = jFormattedTextField.getPreferredSize();
        Dimension dimension2 = new Dimension(dimension.width + 1, dimension.height);
        jFormattedTextField.setPreferredSize(dimension2);
        jFormattedTextField.setMinimumSize(dimension2);
        jFormattedTextField.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                if (caretEvent.getDot() == 0) {
                    return;
                }
                if (TextComponentFactoryImpl.formattedTextFieldIsEmpty(string2, string3, jFormattedTextField)) {
                    ((JTextComponent)caretEvent.getSource()).setCaretPosition(0);
                }
            }
        });
        jFormattedTextField.setName(componentName.toString());
        jFormattedTextField.addMouseListener(this.listener);
        InputMap inputMap = jFormattedTextField.getInputMap();
        inputMap.put(KeyStroke.getKeyStroke(525, 0), CONTEXT_KEY);
        ActionMap actionMap = jFormattedTextField.getActionMap();
        actionMap.put(CONTEXT_KEY, new ContextMenuAction(this.menu));
        return jFormattedTextField;
    }

    private static boolean formattedTextFieldIsEmpty(String string, String string2, JFormattedTextField jFormattedTextField) {
        String string3 = string.replaceAll(string2, " ");
        return jFormattedTextField.getText().equals(string3);
    }

    @Override
    public void configureTextComponent(JTextComponent jTextComponent, MouseListener mouseListener, JPopupMenu jPopupMenu) {
        jTextComponent.addMouseListener(mouseListener);
        InputMap inputMap = jTextComponent.getInputMap();
        inputMap.put(KeyStroke.getKeyStroke(525, 0), CONTEXT_KEY);
        ActionMap actionMap = jTextComponent.getActionMap();
        actionMap.put(CONTEXT_KEY, new ContextMenuAction(jPopupMenu));
    }

    @Override
    public void setupSelectAllOnFocusListener(JTextComponent jTextComponent) {
        new SelectAllOnFocusListener(jTextComponent, this.selectAllOnFocusBehavior);
    }

    @Override
    public JTextComponent createTextField(ComponentName componentName, String string) {
        JTextField jTextField = new JTextField(){

            @Override
            protected void processMouseMotionEvent(MouseEvent mouseEvent) {
                try {
                    super.processMouseMotionEvent(mouseEvent);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    TextComponentFactoryImpl.this.exceptionHandler.logException(arrayIndexOutOfBoundsException);
                }
            }
        };
        this.configureTextComponent(jTextField, this.listener, this.menu);
        this.setupSelectAllOnFocusListener(jTextField);
        jTextField.setName(componentName.toString());
        jTextField.getAccessibleContext().setAccessibleName(string);
        return jTextField;
    }

    @Override
    public JTextComponent createPasswordField(ComponentName componentName) {
        JPasswordField jPasswordField = new JPasswordField();
        jPasswordField.setName(componentName.toString());
        this.configureTextComponent(jPasswordField, this.listener, this.menu);
        this.setupSelectAllOnFocusListener(jPasswordField);
        return jPasswordField;
    }

    private static class MyMaskFormatter
    extends MaskFormatter {
        MyMaskFormatter(String string) throws ParseException {
            super(string);
        }

        @Override
        protected void invalidEdit() {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            toolkit.beep();
        }
    }
}

