/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.instutil;

import com.mathworks.instutil.PlatformImpl;
import com.mathworks.instutil.ResourceLocaleFactory;
import java.text.MessageFormat;
import java.util.MissingResourceException;

public enum InstutilResourceKeys {
    TRADEMARK("trademark.text"),
    RELEASE("releasenum.text"),
    PASSCODE("passcodeversion.text"),
    MATLABVERSION("matlabversion.text"),
    MPSVERSION("mpsversion.text"),
    CHECKSUM("exception.checksum"),
    DIALOGTITLE("dialog.title"),
    DIALOGSERVICE("dialog.service"),
    DIALOGLICENSE("dialog.license"),
    DIALOGACTIVATE("dialog.activate"),
    DIALOGCANTACTIVATE("dialog.canactivate"),
    DIALOGPROXY("dialog.proxy"),
    DIALOGREQPROPS("dialog.requiredProperties"),
    DIALOGGETLEU("dialog.getLicensedEndUser"),
    SERVERLINEEXCEPTION("exception.serverline"),
    SERVERLINEXCTITLE("exception.serverline.title"),
    LICENSEERRORTITLE("error.license.title"),
    LICENSEERRORTITLE2("error.license.title2"),
    LICENSEERROR("error.license"),
    LICENSEDIRERROR("error.license.dir"),
    LICENSEFILEERROR("error.license.file"),
    PERMISSIONERRROR("error.permissions.notset"),
    CLIENTTEMPLATE("client_template"),
    OPTIONSFILECOMMENT("optionsFile"),
    OPTIONSFILEINCLUDE("optionsFile.includeline"),
    BROWSER_ERROR_TITLE("error.browser.title"),
    BROWSER_ERROR_MESSAGE("error.browser.message"),
    X86_ARCH("x86.arch"),
    X64_ARCH("x64.arch"),
    PROFESSIONAL_USAGE_STRING("professional.usage"),
    CONTEXT_CUT("text.Cut"),
    CONTEXT_COPY("text.Copy"),
    CONTEXT_PASTE("text.Paste"),
    CONTEXT_SELECT_ALL("text.SelectAll"),
    EMAIL_VERIFICATION_TITLE("email_verification.title"),
    EMAIL_VERIFICATION_MESSAGE("email_verification.label.boxed"),
    PRINT_ERROR_TITLE("print.error.title"),
    PRINT_ERROR_MESSAGE("print.error"),
    ICON_16("icon.16"),
    ICON_32("icon.32"),
    ICON_48("icon.48"),
    PROXY_AUTHENTICATION_TOP_LABEL("proxy.authentication.text"),
    PROXY_USER_LABEL("proxy.authentication.label.user"),
    PROXY_PASSWORD_LABEL("proxy.authentication.label.password"),
    PROXY_AUTHENTICATION_TITLE("proxy.authentication.title"),
    ERROR_LICENSEFILE_TITLE("licensefile.error.title"),
    ERROR_LICENSEFILE_EXCEPTION("licensefile.error.exception"),
    ERROR_LICENSEFILE_FOLDER("licensefile.error.folder");

    private String resourceKey;
    private static final String[] PROP_SEARCH_PATH;

    private InstutilResourceKeys(String string2) {
        this.resourceKey = string2;
    }

    public String getString(Object ... objectArray) {
        return MessageFormat.format(this.getBundleString(), objectArray);
    }

    public String getBundleString() {
        String string = null;
        PlatformImpl platformImpl = new PlatformImpl();
        for (String string2 : PROP_SEARCH_PATH) {
            try {
                string = ResourceLocaleFactory.createResourceLocale(platformImpl).getBundle(string2).getString(this.resourceKey);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (string == null) {
            string = "";
        }
        return string;
    }

    public String getKey() {
        return this.resourceKey;
    }

    static {
        PROP_SEARCH_PATH = new String[]{"com.mathworks.instutil.resources.RES_generated_props", "com.mathworks.instutil.resources.RES_instutil", "com.mathworks.instutil.resources.RES_instutil_notranslation"};
    }
}

