/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.plaf;

import com.google.common.collect.Lists;
import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;

public class ControlMap {
    private List<Control> fControls;
    private int fWidth;
    private int fHeight;
    private JComponent fRoot;

    public ControlMap(JComponent jComponent) {
        this.fRoot = jComponent;
        this.update();
    }

    public List<Control> getControls() {
        return this.fControls;
    }

    public void update() {
        this.fControls = ControlMap.createControlList(this.fRoot);
        for (Control control : this.fControls) {
            Rectangle rectangle = control.fBounds;
            this.fWidth = Math.max(this.fWidth, rectangle.x + rectangle.width);
            this.fHeight = Math.max(this.fHeight, rectangle.y + rectangle.height);
        }
    }

    public Control first() {
        if (this.fControls.isEmpty()) {
            return null;
        }
        return this.fControls.get(0);
    }

    public JComponent down() {
        Control control = this.down(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner());
        return control != null ? control.fComponent : null;
    }

    public JComponent up() {
        Control control = this.up(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner());
        return control != null ? control.fComponent : null;
    }

    public JComponent right() {
        Control control = this.right(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner());
        return control != null ? control.fComponent : null;
    }

    public JComponent left() {
        Control control = this.left(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner());
        return control != null ? control.fComponent : null;
    }

    public JComponent next() {
        Control control = this.next(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner());
        return control != null ? control.fComponent : null;
    }

    public JComponent prev() {
        Control control = this.prev(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner());
        return control != null ? control.fComponent : null;
    }

    public Control next(Component component) {
        Control control = this.findControl(component);
        if (control == null) {
            return null;
        }
        int n = this.fControls.indexOf(control);
        return this.fControls.get((n + 1) % this.fControls.size());
    }

    public Control prev(Component component) {
        Control control = this.findControl(component);
        if (control == null) {
            return null;
        }
        int n = this.fControls.indexOf(control);
        return this.fControls.get((n - 1 + this.fControls.size()) % this.fControls.size());
    }

    public Control up(Component component) {
        Control control = this.findControl(component);
        if (control == null) {
            return null;
        }
        Rectangle rectangle = control.fBounds;
        List<Control> list = this.matchUp(rectangle.y);
        if (list.isEmpty()) {
            return null;
        }
        return ControlMap.findVTarget(rectangle, list);
    }

    public Control down(Component component) {
        Control control = this.findControl(component);
        if (control == null) {
            return null;
        }
        Rectangle rectangle = control.fBounds;
        List<Control> list = this.matchDown(rectangle.y + rectangle.height);
        if (list.isEmpty()) {
            return null;
        }
        return ControlMap.findVTarget(rectangle, list);
    }

    public Control right(Component component) {
        Control control = this.findControl(component);
        if (control == null) {
            return null;
        }
        Rectangle rectangle = control.fBounds;
        List<Control> list = this.matchRight(rectangle.x + rectangle.width);
        if (list.isEmpty()) {
            list = this.matchRight(0);
        }
        return ControlMap.findHTarget(rectangle, list);
    }

    public Control left(Component component) {
        Control control = this.findControl(component);
        if (control == null) {
            return null;
        }
        Rectangle rectangle = control.fBounds;
        List<Control> list = this.matchLeft(rectangle.x);
        if (list.isEmpty()) {
            list = this.matchLeft(this.fWidth);
        }
        return ControlMap.findHTarget(rectangle, list);
    }

    private static Control findHTarget(Rectangle rectangle, List<Control> list) {
        Control control = null;
        int n = rectangle.y + rectangle.height / 2;
        int n2 = Integer.MAX_VALUE;
        for (Control control2 : list) {
            Rectangle rectangle2 = control2.fBounds;
            int n3 = rectangle2.y + rectangle2.height / 2;
            if (Math.abs(n3 - n) >= n2) continue;
            n2 = Math.abs(n3 - n);
            control = control2;
        }
        return control;
    }

    private static Control findVTarget(Rectangle rectangle, List<Control> list) {
        Control control = null;
        int n = rectangle.x + rectangle.width / 2;
        int n2 = Integer.MAX_VALUE;
        for (Control control2 : list) {
            Rectangle rectangle2 = control2.fBounds;
            int n3 = rectangle2.x + rectangle2.width / 2;
            if (Math.abs(n3 - n) >= n2) continue;
            n2 = Math.abs(n3 - n);
            control = control2;
        }
        return control;
    }

    private List<Control> matchUp(int n) {
        ArrayList arrayList = Lists.newArrayList();
        for (int i = n; i >= 0 && arrayList.isEmpty(); i -= 10) {
            arrayList = Lists.newArrayList();
            for (Control control : this.fControls) {
                Rectangle rectangle = control.fBounds;
                if (rectangle.y + rectangle.height > n || rectangle.y > i || i > rectangle.y + rectangle.height) continue;
                arrayList.add(control);
            }
        }
        return arrayList;
    }

    private List<Control> matchDown(int n) {
        ArrayList arrayList = Lists.newArrayList();
        for (int i = n; i <= this.fHeight && arrayList.isEmpty(); i += 10) {
            arrayList = Lists.newArrayList();
            for (Control control : this.fControls) {
                Rectangle rectangle = control.fBounds;
                if (rectangle.y < n || rectangle.y > i || i > rectangle.y + rectangle.height) continue;
                arrayList.add(control);
            }
        }
        return arrayList;
    }

    private List<Control> matchRight(int n) {
        ArrayList arrayList = Lists.newArrayList();
        for (int i = n; i <= this.fWidth && arrayList.isEmpty(); i += 20) {
            arrayList = Lists.newArrayList();
            for (Control control : this.fControls) {
                Rectangle rectangle = control.fBounds;
                if (n > rectangle.x || rectangle.x > i || i > rectangle.x + rectangle.width) continue;
                arrayList.add(control);
            }
        }
        return arrayList;
    }

    private List<Control> matchLeft(int n) {
        ArrayList arrayList = Lists.newArrayList();
        for (int i = n; 0 <= i && arrayList.isEmpty(); i -= 20) {
            arrayList = Lists.newArrayList();
            for (Control control : this.fControls) {
                Rectangle rectangle = control.fBounds;
                if (rectangle.x + rectangle.width > n || rectangle.x > i || i > rectangle.x + rectangle.width) continue;
                arrayList.add(control);
            }
        }
        return arrayList;
    }

    private Control findControl(Component component) {
        for (Control control : this.fControls) {
            if (control.fComponent != component) continue;
            return control;
        }
        return null;
    }

    private static List<Control> createControlList(JComponent jComponent) {
        ArrayList arrayList = Lists.newArrayList();
        ControlMap.createControlList(jComponent, jComponent, arrayList);
        return arrayList;
    }

    private static void createControlList(JComponent jComponent, Container container, List<Control> list) {
        Component[] componentArray;
        for (Component component : componentArray = container.getComponents()) {
            if (ControlMap.isTSComponent(component) && component.isVisible() && component.isFocusable() && component.isEnabled()) {
                Rectangle rectangle = SwingUtilities.convertRectangle(component, new Rectangle(0, 0, component.getWidth(), component.getHeight()), jComponent);
                list.add(new Control((JComponent)component, rectangle));
                continue;
            }
            if (!(component instanceof Container)) continue;
            ControlMap.createControlList(jComponent, (Container)component, list);
        }
    }

    private static boolean isTSComponent(Component component) {
        return component instanceof AbstractButton || component instanceof JTextField || component instanceof JComboBox || component instanceof JList || component instanceof JSlider || component instanceof JSpinner || component instanceof JTable || component instanceof JTree;
    }

    public static class Control {
        private Rectangle fBounds;
        private JComponent fComponent;

        Control(JComponent jComponent, Rectangle rectangle) {
            this.fComponent = jComponent;
            this.fBounds = rectangle;
        }

        public Rectangle getBounds() {
            return this.fBounds;
        }

        public JComponent getComponent() {
            return this.fComponent;
        }
    }
}

