/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.workunit;

import com.mathworks.toolbox.distcomp.auth.AuthorisationFailedException;
import com.mathworks.toolbox.distcomp.auth.AuthorisationModule;
import com.mathworks.toolbox.distcomp.auth.UnknownUserException;
import com.mathworks.toolbox.distcomp.auth.credentials.UserIdentity;
import com.mathworks.toolbox.distcomp.auth.credentials.store.CredentialProviderLocal;
import com.mathworks.toolbox.distcomp.distcompobjects.DistcompProxy;
import com.mathworks.toolbox.distcomp.jobmanager.JobManagerProxy;
import com.mathworks.toolbox.distcomp.mjs.MJSException;
import com.mathworks.toolbox.distcomp.service.ExporterFactory;
import com.mathworks.toolbox.distcomp.storage.CredentialStorageException;
import com.mathworks.toolbox.distcomp.storage.StorageCache;
import com.mathworks.toolbox.distcomp.storage.WorkUnitNotFoundException;
import com.mathworks.toolbox.distcomp.workunit.DistcompAccessImpl;
import com.mathworks.toolbox.distcomp.workunit.DistcompListenableAccessImpl;
import com.mathworks.toolbox.distcomp.workunit.WorkUnit;
import com.mathworks.toolbox.distcomp.workunit.WorkUnitAccessRemote;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import java.util.Date;
import java.util.LinkedList;
import net.jini.id.Uuid;

public abstract class WorkUnitAccessImpl
extends DistcompListenableAccessImpl
implements WorkUnitAccessRemote {
    private AuthorisationModule fAuthorisationModule;

    protected WorkUnitAccessImpl(long l, StorageCache storageCache, String string, JobManagerProxy jobManagerProxy, AuthorisationModule authorisationModule, ExporterFactory exporterFactory) throws ExportException, DistcompProxy.SerializeProxyException {
        super(l, storageCache, string, jobManagerProxy, exporterFactory);
        this.fAuthorisationModule = authorisationModule;
    }

    protected final AuthorisationModule getAuthorisationModule() {
        return this.fAuthorisationModule;
    }

    protected void checkCredentials(WorkUnit workUnit, CredentialProviderLocal credentialProviderLocal) throws AuthorisationFailedException, CredentialStorageException {
        UserIdentity userIdentity = new UserIdentity(workUnit.getUserName());
        LinkedList<UserIdentity> linkedList = new LinkedList<UserIdentity>();
        for (String string : workUnit.getAuthorisedUsers()) {
            linkedList.add(new UserIdentity(string));
        }
        this.getAuthorisationModule().checkCredentials(userIdentity, linkedList, credentialProviderLocal);
    }

    protected void checkCredentials(Uuid uuid, CredentialProviderLocal credentialProviderLocal) throws CredentialStorageException, AuthorisationFailedException {
        try {
            this.checkCredentials(this.fStorage.readWorkUnit(uuid), credentialProviderLocal);
        }
        catch (WorkUnitNotFoundException workUnitNotFoundException) {
            throw new CredentialStorageException("Credential check failed because work unit with id: " + uuid + " did not exist in storage", workUnitNotFoundException);
        }
    }

    protected void checkCredentialsOnlyOwner(WorkUnit workUnit, CredentialProviderLocal credentialProviderLocal) throws AuthorisationFailedException, CredentialStorageException {
        UserIdentity userIdentity = new UserIdentity(workUnit.getUserName());
        this.getAuthorisationModule().checkCredentials(userIdentity, new LinkedList<UserIdentity>(), credentialProviderLocal);
    }

    protected void checkUserExists(String string) throws UnknownUserException, CredentialStorageException {
        UserIdentity userIdentity = new UserIdentity(string);
        if (!this.getAuthorisationModule().userExists(userIdentity)) {
            throw new UnknownUserException(userIdentity);
        }
    }

    @Override
    public long[] getTimeout(final Uuid[] uuidArray) throws RemoteException, MJSException {
        return (long[])this.accessInvocation(new DistcompAccessImpl.AccessInvocationSmallReturn(uuidArray){
            long[] iTimeouts;
            {
                super(uuidArray3);
                this.iTimeouts = new long[uuidArray.length];
            }

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                this.iTimeouts[n] = workUnit.getTimeout();
            }

            @Override
            protected Object getReturnValue() {
                return this.iTimeouts;
            }
        });
    }

    @Override
    public long[] getNum(final Uuid[] uuidArray) throws RemoteException, MJSException {
        return (long[])this.accessInvocation(new DistcompAccessImpl.AccessInvocationSmallReturn(uuidArray){
            long[] iNums;
            {
                super(uuidArray3);
                this.iNums = new long[uuidArray.length];
            }

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                this.iNums[n] = workUnit.getNum();
            }

            @Override
            protected Object getReturnValue() {
                return this.iNums;
            }
        });
    }

    @Override
    public int[] getState(final Uuid[] uuidArray) throws RemoteException, MJSException {
        return (int[])this.accessInvocation(new DistcompAccessImpl.AccessInvocationSmallReturn(uuidArray){
            int[] iStates;
            {
                super(uuidArray3);
                this.iStates = new int[uuidArray.length];
            }

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                this.iStates[n] = workUnit.getState();
            }

            @Override
            protected Object getReturnValue() {
                return this.iStates;
            }
        });
    }

    @Override
    public Date[] getCreateTime(final Uuid[] uuidArray) throws RemoteException, MJSException {
        return (Date[])this.accessInvocation(new DistcompAccessImpl.AccessInvocationSmallReturn(uuidArray){
            Date[] iCreateTimes;
            {
                super(uuidArray3);
                this.iCreateTimes = new Date[uuidArray.length];
            }

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                this.iCreateTimes[n] = workUnit.getCreateTime();
            }

            @Override
            protected Object getReturnValue() {
                return this.iCreateTimes;
            }
        });
    }

    @Override
    public Date[] getStartTime(final Uuid[] uuidArray) throws RemoteException, MJSException {
        return (Date[])this.accessInvocation(new DistcompAccessImpl.AccessInvocationSmallReturn(uuidArray){
            Date[] iStartTimes;
            {
                super(uuidArray3);
                this.iStartTimes = new Date[uuidArray.length];
            }

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                this.iStartTimes[n] = workUnit.getStartTime();
            }

            @Override
            protected Object getReturnValue() {
                return this.iStartTimes;
            }
        });
    }

    @Override
    public Date[] getFinishTime(final Uuid[] uuidArray) throws RemoteException, MJSException {
        return (Date[])this.accessInvocation(new DistcompAccessImpl.AccessInvocationSmallReturn(uuidArray){
            Date[] iFinishTimes;
            {
                super(uuidArray3);
                this.iFinishTimes = new Date[uuidArray.length];
            }

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                this.iFinishTimes[n] = workUnit.getFinishTime();
            }

            @Override
            protected Object getReturnValue() {
                return this.iFinishTimes;
            }
        });
    }

    @Override
    public long[] getRunningDuration(final Uuid[] uuidArray) throws RemoteException, MJSException {
        return (long[])this.accessInvocation(new DistcompAccessImpl.AccessInvocationSmallReturn(uuidArray){
            long[] iRunningDurations;
            {
                super(uuidArray3);
                this.iRunningDurations = new long[uuidArray.length];
            }

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                this.iRunningDurations[n] = workUnit.getRunningDuration();
            }

            @Override
            protected Object getReturnValue() {
                return this.iRunningDurations;
            }
        });
    }

    @Override
    public void setTimeout(Uuid[] uuidArray, final long[] lArray, final CredentialProviderLocal credentialProviderLocal) throws MJSException {
        this.accessInvocation(new DistcompAccessImpl.AccessInvocationWithoutReturn(uuidArray){

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                WorkUnitAccessImpl.this.checkCredentials(workUnit, credentialProviderLocal);
                workUnit.setTimeout(lArray[n]);
            }
        });
    }

    @Override
    public String[] getName(final Uuid[] uuidArray) throws RemoteException, MJSException {
        return (String[])this.accessInvocation(new DistcompAccessImpl.AccessInvocationSmallReturn(uuidArray){
            String[] iNames;
            {
                super(uuidArray3);
                this.iNames = new String[uuidArray.length];
            }

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                this.iNames[n] = workUnit.getName();
            }

            @Override
            protected Object getReturnValue() {
                return this.iNames;
            }
        });
    }

    @Override
    public void setName(Uuid[] uuidArray, final String[] stringArray, final CredentialProviderLocal credentialProviderLocal) throws MJSException {
        this.accessInvocation(new DistcompAccessImpl.AccessInvocationWithoutReturn(uuidArray){

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                WorkUnitAccessImpl.this.checkCredentials(workUnit, credentialProviderLocal);
                workUnit.setName(stringArray[n]);
            }
        });
    }

    @Override
    public void cancel(Uuid[] uuidArray, final String[] stringArray, final CredentialProviderLocal credentialProviderLocal) throws MJSException {
        this.accessInvocation(new DistcompAccessImpl.AccessInvocationWithoutReturn(uuidArray){

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                WorkUnitAccessImpl.this.checkCredentials(workUnit, credentialProviderLocal);
                workUnit.cancel(stringArray[n]);
            }
        });
    }

    @Override
    public void destroy(Uuid[] uuidArray, final CredentialProviderLocal credentialProviderLocal) throws MJSException {
        this.accessInvocation(new DistcompAccessImpl.AccessInvocationWithoutReturn(uuidArray){

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                WorkUnitAccessImpl.this.checkCredentials(workUnit, credentialProviderLocal);
                workUnit.destroy();
            }
        });
    }

    @Override
    public void rerunOrCancel(Uuid[] uuidArray, final String[] stringArray) throws RemoteException, MJSException {
        this.accessInvocation(new DistcompAccessImpl.AccessInvocationWithoutReturn(uuidArray){

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                workUnit.rerunOrCancel(stringArray[n]);
            }
        });
    }
}

