/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.worker;

import com.mathworks.toolbox.distcomp.distcompobjects.DistcompException;
import com.mathworks.toolbox.distcomp.jobmanager.JobManagerProxy;
import com.mathworks.toolbox.distcomp.jobmanager.WorkerRegistration;
import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.mjs.MJSException;
import com.mathworks.toolbox.distcomp.util.Accessor;
import com.mathworks.toolbox.distcomp.util.JiniAccessor;
import com.mathworks.toolbox.distcomp.util.MulticastAccessor;
import com.mathworks.toolbox.distcomp.util.UnicastAccessor;
import com.mathworks.toolbox.distcomp.worker.PackageInfo;
import java.rmi.RemoteException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.jini.core.discovery.LookupLocator;

public class RegistrationMaintainer
implements Runnable {
    private final WorkerRegistrant fWorkerRegistrant;
    private final JobManagerProxySaver fProxySaver;
    private final long fLookupServiceQueryIntervalMillis;
    private final String fJobManagerName;
    private final Accessor fAccessor;
    private WorkerRegistration fWorkerRegistration;
    private boolean fPauseRegistration = false;
    private boolean fTerminate = false;
    private Thread fRegistrationThread;
    private final ExecutorService fRegistrationExecutor = Executors.newSingleThreadExecutor();

    public RegistrationMaintainer(WorkerRegistrant workerRegistrant, JobManagerProxySaver jobManagerProxySaver, String string, long l, Accessor accessor, JobManagerProxy jobManagerProxy) {
        this.fWorkerRegistrant = workerRegistrant;
        this.fProxySaver = jobManagerProxySaver;
        this.fJobManagerName = string;
        this.fLookupServiceQueryIntervalMillis = l;
        this.fAccessor = accessor;
        this.contactJobManager(jobManagerProxy);
    }

    public RegistrationMaintainer(WorkerRegistrant workerRegistrant, JobManagerProxySaver jobManagerProxySaver, String string, long l, LookupLocator[] lookupLocatorArray, JobManagerProxy jobManagerProxy) throws DistcompException {
        this(workerRegistrant, jobManagerProxySaver, string, l, RegistrationMaintainer.createAccessor(lookupLocatorArray), jobManagerProxy);
    }

    public void start() {
        this.fRegistrationThread = new Thread(this);
        this.fRegistrationThread.start();
    }

    public void join() throws InterruptedException {
        this.fRegistrationThread.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            if (this.fWorkerRegistration == null) {
                this.findJobManager();
            }
            this.maintainRegistrationWithJobManager();
            RegistrationMaintainer registrationMaintainer = this;
            synchronized (registrationMaintainer) {
                if (this.fTerminate) {
                    return;
                }
            }
        }
    }

    synchronized void pauseRegistration() {
        this.fPauseRegistration = true;
    }

    synchronized void resumeRegistrationIfPaused() {
        if (this.fPauseRegistration) {
            this.resumeRegistration();
        }
    }

    synchronized void resumeRegistration() {
        this.fPauseRegistration = false;
        this.notifyAll();
    }

    synchronized void terminate() {
        this.fTerminate = true;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findJobManager() {
        while (true) {
            Object object;
            try {
                for (Object object2 : object = this.fAccessor.getJobManagers(this.fJobManagerName)) {
                    boolean bl = this.contactJobManager((JobManagerProxy)object2);
                    if (!bl) continue;
                    return;
                }
            }
            catch (MJSException mJSException) {
                PackageInfo.LOGGER.log(DistcompLevel.ONE, "getJobManagers threw exception.", mJSException);
            }
            object = this;
            synchronized (object) {
                if (this.fTerminate) {
                    return;
                }
                try {
                    this.wait(this.fLookupServiceQueryIntervalMillis);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private boolean contactJobManager(JobManagerProxy jobManagerProxy) {
        boolean bl;
        if (jobManagerProxy != null && (bl = jobManagerProxy.testCommunication())) {
            try {
                WorkerRegistration workerRegistration = jobManagerProxy.getWorkerRegistration();
                if (workerRegistration != null && this.fProxySaver.saveJobManagerProxy(jobManagerProxy)) {
                    this.fWorkerRegistration = workerRegistration;
                    return true;
                }
            }
            catch (Throwable throwable) {
                PackageInfo.LOGGER.log(DistcompLevel.SIX, "Getting worker registration from jobmanager failed.", throwable);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maintainRegistrationWithJobManager() {
        while (true) {
            RegistrationMaintainer registrationMaintainer = this;
            synchronized (registrationMaintainer) {
                long l;
                if (this.fTerminate) {
                    return;
                }
                if (this.fPauseRegistration) {
                    l = 0L;
                } else {
                    l = this.registerWithJobManager();
                    if (l <= 0L) {
                        this.fWorkerRegistration = null;
                        return;
                    }
                }
                try {
                    this.wait(l);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private static Accessor createAccessor(LookupLocator[] lookupLocatorArray) throws DistcompException {
        JiniAccessor jiniAccessor = lookupLocatorArray != null && lookupLocatorArray.length > 0 ? new UnicastAccessor(lookupLocatorArray) : new MulticastAccessor();
        return jiniAccessor;
    }

    private synchronized long registerWithJobManager() {
        Callable<Long> callable = new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                return RegistrationMaintainer.this.fWorkerRegistrant.register(RegistrationMaintainer.this.fWorkerRegistration);
            }
        };
        Future<Long> future = this.fRegistrationExecutor.submit(callable);
        while (true) {
            try {
                return future.get();
            }
            catch (ExecutionException executionException) {
                Throwable throwable = executionException.getCause();
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Registration failed: " + throwable.toString());
                return -1L;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public static interface WorkerRegistrant {
        public long register(WorkerRegistration var1) throws RemoteException;
    }

    public static interface JobManagerProxySaver {
        public boolean saveJobManagerProxy(JobManagerProxy var1);
    }
}

