/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.util.concurrent;

import com.mathworks.toolbox.distcomp.util.concurrent.Predicate;
import com.mathworks.toolbox.distcomp.util.concurrent.PredicateNotTrueException;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;

public class ReentrantLock
extends java.util.concurrent.locks.ReentrantLock {
    public Condition newPredicateCondition(Predicate predicate) {
        return new PredicateCondition(predicate);
    }

    @Override
    public Condition newCondition() {
        return new ConditionImpl();
    }

    private void ownLockCheck() {
        if (!this.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
    }

    private class ConditionImpl
    implements Condition {
        private final PredicateCondition fCondition;
        private final PredicateCondition fSignallingFinished;
        private int fNumToSignal = 0;
        private int fNumWaiters = 0;

        ConditionImpl() {
            this.fCondition = new PredicateCondition(new Predicate(){

                @Override
                public boolean test() {
                    return ConditionImpl.this.fNumToSignal > 0;
                }
            });
            this.fSignallingFinished = new PredicateCondition(new Predicate(){

                @Override
                public boolean test() {
                    return ConditionImpl.this.fNumToSignal <= 0;
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void await() throws InterruptedException {
            ReentrantLock.this.ownLockCheck();
            this.fSignallingFinished.await();
            try {
                this.beforeWait();
                this.fCondition.await();
                this.afterWait();
            }
            finally {
                this.onAwaitExit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void awaitUninterruptibly() {
            ReentrantLock.this.ownLockCheck();
            this.fSignallingFinished.awaitUninterruptibly();
            try {
                this.beforeWait();
                this.fCondition.awaitUninterruptibly();
                this.afterWait();
            }
            finally {
                this.onAwaitExit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long awaitNanos(long l) throws InterruptedException {
            ReentrantLock.this.ownLockCheck();
            l = this.fSignallingFinished.awaitNanos(l);
            if (l < 0L) {
                return l;
            }
            try {
                this.beforeWait();
                long l2 = this.fCondition.awaitNanos(l);
                this.afterWait();
                long l3 = l2;
                return l3;
            }
            finally {
                this.onAwaitExit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean await(long l, TimeUnit timeUnit) throws InterruptedException {
            ReentrantLock.this.ownLockCheck();
            Date date = new Date(System.currentTimeMillis() + TimeUnit.MILLISECONDS.convert(l, timeUnit));
            if (!this.fSignallingFinished.awaitDeadline(date)) {
                return false;
            }
            try {
                this.beforeWait();
                boolean bl = this.fCondition.awaitDeadline(date);
                this.afterWait();
                boolean bl2 = bl;
                return bl2;
            }
            finally {
                this.onAwaitExit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean awaitUntil(Date date) throws InterruptedException {
            ReentrantLock.this.ownLockCheck();
            if (!this.fSignallingFinished.awaitDeadline(date)) {
                return false;
            }
            try {
                this.beforeWait();
                boolean bl = this.fCondition.awaitDeadline(date);
                this.afterWait();
                boolean bl2 = bl;
                return bl2;
            }
            finally {
                this.onAwaitExit();
            }
        }

        @Override
        public void signal() {
            ReentrantLock.this.ownLockCheck();
            if (this.fNumWaiters > 0 && this.fNumToSignal < this.fNumWaiters) {
                ++this.fNumToSignal;
                this.fCondition.signal();
            }
        }

        @Override
        public void signalAll() {
            ReentrantLock.this.ownLockCheck();
            if (this.fNumWaiters > 0 && this.fNumToSignal < this.fNumWaiters) {
                this.fNumToSignal = this.fNumWaiters;
                this.fCondition.signalAll();
            }
        }

        private void beforeWait() {
            ++this.fNumWaiters;
        }

        private void afterWait() {
            if (this.fNumToSignal > 0) {
                --this.fNumToSignal;
                if (this.fNumToSignal == 0) {
                    this.fSignallingFinished.signalAll();
                }
            }
        }

        private void onAwaitExit() {
            --this.fNumWaiters;
            if (this.fNumWaiters == 0 && this.fNumToSignal > 0) {
                this.fNumToSignal = 0;
                this.fSignallingFinished.signalAll();
            }
        }
    }

    private class PredicateCondition
    implements Condition {
        private final Predicate fPredicate;
        private final Condition fCondition;

        PredicateCondition(Predicate predicate) {
            this.fPredicate = predicate;
            this.fCondition = ReentrantLock.super.newCondition();
        }

        @Override
        public void await() throws InterruptedException {
            ReentrantLock.this.ownLockCheck();
            while (!this.fPredicate.test()) {
                this.fCondition.await();
            }
        }

        @Override
        public void awaitUninterruptibly() {
            ReentrantLock.this.ownLockCheck();
            while (!this.fPredicate.test()) {
                this.fCondition.awaitUninterruptibly();
            }
        }

        @Override
        public long awaitNanos(long l) throws InterruptedException {
            ReentrantLock.this.ownLockCheck();
            while (!this.fPredicate.test()) {
                if (l > 0L) {
                    l = this.fCondition.awaitNanos(l);
                    continue;
                }
                return l;
            }
            return l;
        }

        @Override
        public boolean await(long l, TimeUnit timeUnit) throws InterruptedException {
            ReentrantLock.this.ownLockCheck();
            Date date = new Date(System.currentTimeMillis() + TimeUnit.MILLISECONDS.convert(l, timeUnit));
            return this.awaitDeadline(date);
        }

        @Override
        public boolean awaitUntil(Date date) throws InterruptedException {
            ReentrantLock.this.ownLockCheck();
            return this.awaitDeadline(date);
        }

        boolean awaitDeadline(Date date) throws InterruptedException {
            boolean bl = true;
            while (!this.fPredicate.test()) {
                if (bl) {
                    bl = this.fCondition.awaitUntil(date);
                    continue;
                }
                return false;
            }
            return true;
        }

        @Override
        public void signal() {
            ReentrantLock.this.ownLockCheck();
            if (!this.fPredicate.test()) {
                throw new PredicateNotTrueException("Predicate must be true before signalling that it is true.");
            }
            this.fCondition.signal();
        }

        @Override
        public void signalAll() {
            ReentrantLock.this.ownLockCheck();
            if (!this.fPredicate.test()) {
                throw new PredicateNotTrueException("Predicate must be true before signalling that it is true.");
            }
            this.fCondition.signalAll();
        }
    }
}

