/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.util;

import java.io.Serializable;

public class RemoteSystemProperty
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String fProperty;
    private String fValue;
    private boolean fSetAtRemoteEnd;
    private String fDefaultValue;
    private transient String fOldValue;

    public RemoteSystemProperty() {
        this.fSetAtRemoteEnd = false;
    }

    public RemoteSystemProperty(String string) {
        this.fProperty = string;
        this.fSetAtRemoteEnd = false;
    }

    public RemoteSystemProperty(String string, String string2) {
        this.fProperty = string;
        this.fValue = string2;
        this.fSetAtRemoteEnd = true;
    }

    public String getProperty() {
        return this.fProperty;
    }

    public void setValue(String string) {
        this.fValue = string;
        this.fSetAtRemoteEnd = string != null;
    }

    public String getValue() {
        if (this.fValue != null && this.fValue.length() != 0) {
            return this.fValue;
        }
        return this.fDefaultValue;
    }

    public void setDefaultValue(String string) {
        this.fDefaultValue = string;
    }

    public void exportValueIfNeeded() {
        if (!this.fSetAtRemoteEnd) {
            return;
        }
        String string = null;
        this.fOldValue = System.getProperty(this.fProperty, string);
        String string2 = this.getValue();
        if (string2 == null) {
            string2 = "";
        }
        System.setProperty(this.fProperty, string2);
    }

    public void restoreValueIfNeeded() {
        if (!this.fSetAtRemoteEnd) {
            return;
        }
        String string = this.fOldValue;
        if (string == null) {
            string = "";
        }
        System.setProperty(this.fProperty, string);
    }

    public boolean getShouldSetAtRemoteEnd() {
        return this.fSetAtRemoteEnd;
    }

    public String toString() {
        return this.fProperty + " " + this.fValue + " " + this.fSetAtRemoteEnd;
    }
}

