/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.util;

import com.mathworks.toolbox.distcomp.util.DistcompDiagnosticException;
import com.mathworks.toolbox.distcomp.util.ErrorPrinter;
import java.io.PrintStream;

public class ErrorPrinterImpl
implements ErrorPrinter {
    static final boolean STACKTRACE = true;
    static final boolean NOSTACKTRACE = false;
    private final PrintStream fOutStream;

    public ErrorPrinterImpl() {
        this.fOutStream = System.err;
    }

    public ErrorPrinterImpl(PrintStream printStream) {
        this.fOutStream = printStream;
    }

    @Override
    public void printError(String string, Exception exception) {
        this.fOutStream.println(string);
        this.printError(exception);
    }

    @Override
    public void printError(Throwable throwable) {
        if (throwable instanceof DistcompDiagnosticException) {
            this.printThrowable(throwable, false);
        } else {
            this.printThrowable(throwable, true);
        }
    }

    @Override
    public void printThrowable(Throwable throwable, boolean bl) {
        String string = "";
        if (bl) {
            throwable.printStackTrace();
            string = string + throwable.getClass().getName() + ": ";
        }
        string = string + throwable.getMessage();
        String string2 = bl ? this.getCauseMessage(throwable.getCause()) : this.getReverseCauseMessage(throwable.getCause());
        this.printError(string, string2);
    }

    @Override
    public void printError(String string, String string2) {
        this.fOutStream.println(string + "\n");
        if (string2 != null) {
            this.fOutStream.println("The cause of this problem is:\n");
            this.fOutStream.println("============================================================================");
            String string3 = "   ";
            string2 = string2.replaceAll("\n", "\n" + string3);
            string2 = string2.replaceFirst("^", string3);
            this.fOutStream.println(string2);
            this.fOutStream.println("============================================================================");
            this.fOutStream.println("");
        }
    }

    private String getReverseCauseMessage(Throwable throwable) {
        String string = "";
        while (throwable != null) {
            if (string.length() > 0) {
                string = "\n" + string;
            }
            string = throwable.getMessage() + string;
            if ((throwable = throwable.getCause()) == null) continue;
            string = "\nThis is causing:\n\n" + string;
        }
        return string;
    }

    private String getCauseMessage(Throwable throwable) {
        String string = "";
        while (throwable != null) {
            string = string + throwable.getClass().getName() + ": ";
            string = string + throwable.getMessage();
            if ((throwable = throwable.getCause()) == null) continue;
            string = string + "\n\nwhich is caused by:\n";
        }
        return string;
    }
}

