/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui.widget;

import com.jidesoft.grid.SortableTable;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.grid.TableUtils;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuideRelatedPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class TablePanel
extends StyleGuideRelatedPanel
implements PropertyChangeListener {
    private final AbstractTableModel fTableModel;
    private final SortableTable fTable;
    private JPopupMenu fContextMenu;
    private static final int TABLE_ROW_HEIGHT = 23;

    public TablePanel(AbstractTableModel abstractTableModel, String string) {
        this.fTableModel = abstractTableModel;
        this.fTable = this.createTable();
        JScrollPane jScrollPane = new JScrollPane((Component)this.fTable);
        jScrollPane.getViewport().setBackground(Color.WHITE);
        jScrollPane.setPreferredSize(new Dimension((int)this.fTable.getPreferredSize().getWidth(), (int)this.fTable.getPreferredSize().getHeight() + (int)this.fTable.getTableHeader().getPreferredSize().getHeight() + 4));
        this.addLine(jScrollPane, 8);
        this.fTable.setName(string);
    }

    public void setContextMenu(JPopupMenu jPopupMenu) {
        this.fContextMenu = jPopupMenu;
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.fTable.getSelectionModel().addListSelectionListener(listSelectionListener);
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.fTable.getSelectionModel().removeListSelectionListener(listSelectionListener);
    }

    public int getRowCount() {
        return this.fTableModel.getRowCount();
    }

    public Object getValueAt(int n, int n2) {
        return this.fTableModel.getValueAt(n, n2);
    }

    public int getSelectedRow() {
        int n = this.fTable.getSelectedRow();
        n = this.fTable.getActualRowAt(n);
        return n;
    }

    public void clearSelectedRow() {
        this.fTable.clearSelection();
    }

    public void setSelectedRow(int n) {
        ListSelectionListener[] listSelectionListenerArray;
        int n2 = this.fTable.getSortedRowAt(n);
        for (ListSelectionListener listSelectionListener : listSelectionListenerArray = ((DefaultListSelectionModel)this.fTable.getSelectionModel()).getListSelectionListeners()) {
            this.fTable.getSelectionModel().removeListSelectionListener(listSelectionListener);
        }
        this.fTable.setRowSelectionInterval(n2, n2);
        for (ListSelectionListener listSelectionListener : listSelectionListenerArray) {
            this.fTable.getSelectionModel().addListSelectionListener(listSelectionListener);
        }
        TableUtils.ensureRowVisible((JTable)this.fTable, (int)n2);
    }

    public void editSelectedCell() {
        int n = this.fTable.getSelectedRow();
        this.fTable.editCellAt(n, 0);
        this.fTable.requestFocus();
        TableCellEditor tableCellEditor = this.fTable.getCellEditor(n, 0);
        tableCellEditor.shouldSelectCell(new ListSelectionEvent(this, n, 0, true));
        if (tableCellEditor instanceof DefaultCellEditor) {
            ((DefaultCellEditor)tableCellEditor).getComponent().requestFocus();
        }
    }

    private SortableTable createTable() {
        SortableTable sortableTable = new SortableTable((TableModel)this.fTableModel);
        sortableTable.setSelectionMode(0);
        sortableTable.setShowSortOrderNumber(false);
        sortableTable.setRowHeight(23);
        sortableTable.putClientProperty((Object)"terminateEditOnFocusLost", (Object)Boolean.TRUE);
        sortableTable.putClientProperty((Object)"JTable.autoStartsEdit", (Object)Boolean.FALSE);
        TableCellRenderer tableCellRenderer = sortableTable.getTableHeader().getDefaultRenderer();
        JLabel jLabel = (JLabel)((Object)tableCellRenderer);
        jLabel.setHorizontalAlignment(0);
        this.addRightClickMenuMouseListener(sortableTable);
        return sortableTable;
    }

    private void addRightClickMenuMouseListener(SortableTable sortableTable) {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.showPopup(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                this.showPopup(mouseEvent);
            }

            private void showPopup(MouseEvent mouseEvent) {
                int n = TablePanel.this.fTable.rowAtPoint(mouseEvent.getPoint());
                int n2 = TablePanel.this.fTable.getActualRowAt(n);
                if (n2 != -1 && TablePanel.this.fTable.getActualRowAt(TablePanel.this.fTable.getSelectedRow()) != n2) {
                    int n3 = TablePanel.this.fTable.getSortedRowAt(n2);
                    TablePanel.this.fTable.setRowSelectionInterval(n3, n3);
                }
                if (mouseEvent.isPopupTrigger() && TablePanel.this.fContextMenu != null) {
                    TablePanel.this.fContextMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        };
        sortableTable.addMouseListener((MouseListener)mouseAdapter);
    }

    public void setCustomRenderer(int n, TableCellRenderer tableCellRenderer) {
        TableColumn tableColumn = this.fTable.getColumnModel().getColumn(n);
        tableColumn.setCellRenderer(tableCellRenderer);
    }

    public void setCustomEditor(int n, TableCellEditor tableCellEditor) {
        TableColumn tableColumn = this.fTable.getColumnModel().getColumn(n);
        tableColumn.setCellEditor(tableCellEditor);
    }

    public JTable getTable() {
        return this.fTable;
    }

    public void updateTable() {
        AbstractTableModel abstractTableModel = (AbstractTableModel)TableModelWrapperUtils.getActualTableModel((TableModel)this.fTable.getModel());
        abstractTableModel.fireTableDataChanged();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }
}

