/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui.widget;

import com.mathworks.mwswing.MJTextField;
import com.mathworks.toolbox.distcomp.ui.ClickAwayFocusListener;
import com.mathworks.toolbox.distcomp.ui.model.DefaultValue;
import com.mathworks.toolbox.distcomp.ui.model.Property;
import com.mathworks.toolbox.distcomp.ui.widget.ConfigurablePropertyView;
import com.mathworks.toolbox.distcomp.ui.widget.GlassPaneTextContextMenu;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class IntegerVectorView
extends ConfigurablePropertyView {
    private static final String INF = "inf";
    private static final String EMPTY_VALUE = "";

    public IntegerVectorView(Property property, String string) {
        super(property, IntegerVectorView.createUI(property), string, true);
    }

    private static JComponent createUI(final Property property) {
        final MJTextField mJTextField = new MJTextField();
        int n = (int)mJTextField.getPreferredSize().getHeight();
        mJTextField.setMinimumSize(new Dimension(210, n));
        mJTextField.setMaximumSize(new Dimension(210, n));
        mJTextField.setSize(new Dimension(210, n));
        mJTextField.setPreferredSize(new Dimension(210, n));
        mJTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = mJTextField.getText();
                IntegerVectorView.updatePropertyValue(property, string);
                mJTextField.getParent().requestFocus();
            }
        });
        mJTextField.addFocusListener((FocusListener)new ClickAwayFocusListener((JComponent)mJTextField, new Runnable(){

            @Override
            public void run() {
                String string = mJTextField.getText();
                IntegerVectorView.updatePropertyValue(property, string);
            }
        }));
        mJTextField.addContextMenu((JPopupMenu)((Object)new GlassPaneTextContextMenu()));
        return mJTextField;
    }

    @Override
    void updateUI(JComponent jComponent, Object object) {
        String string;
        if (object instanceof DefaultValue) {
            string = EMPTY_VALUE;
        } else if (object instanceof Double) {
            string = IntegerVectorView.createIntegerText((Double)object);
        } else if (object instanceof Double[]) {
            Double[] doubleArray = (Double[])object;
            StringBuilder stringBuilder = new StringBuilder();
            for (Double d : doubleArray) {
                stringBuilder.append(IntegerVectorView.createIntegerText(d));
                stringBuilder.append(" ");
            }
            stringBuilder.substring(0, stringBuilder.length() - 1);
            string = "[" + stringBuilder.substring(0, stringBuilder.length() - 1) + "]";
        } else {
            assert (false) : "Unsupported type " + object.getClass().getSimpleName();
            string = EMPTY_VALUE;
        }
        ((JTextComponent)jComponent).setText(string);
    }

    private static String createIntegerText(Double d) {
        String string;
        if (d.equals(Double.POSITIVE_INFINITY)) {
            string = INF;
        } else {
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            numberFormat.setParseIntegerOnly(true);
            numberFormat.setGroupingUsed(false);
            string = numberFormat.format(d);
        }
        return string;
    }

    @Override
    void commitEdit() {
        Property property = this.getProperty();
        JTextField jTextField = (JTextField)this.getActualComponent();
        String string = jTextField.getText();
        IntegerVectorView.updatePropertyValue(property, string);
    }

    private static void updatePropertyValue(Property property, String string) {
        Object object = IntegerVectorView.convertToDoubleArray(string);
        if (EMPTY_VALUE.equals(object)) {
            property.unsetValue();
        } else {
            property.setValue(object);
        }
    }

    private static Object convertToDoubleArray(String string) {
        if (string == null) {
            return EMPTY_VALUE;
        }
        if ((string = string.trim()).length() == 0) {
            return EMPTY_VALUE;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "[], ");
        ArrayList<Double> arrayList = new ArrayList<Double>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            arrayList.add(IntegerVectorView.createDouble(string2));
        }
        if (arrayList.size() > 1) {
            return arrayList.toArray(new Double[arrayList.size()]);
        }
        if (arrayList.size() == 1) {
            return arrayList.get(0);
        }
        return EMPTY_VALUE;
    }

    private static Double createDouble(String string) {
        Double d;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            d = Double.POSITIVE_INFINITY;
        }
        return d;
    }
}

