/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui.widget;

import com.mathworks.mwswing.MJComboBox;
import com.mathworks.toolbox.distcomp.ui.model.DefaultValue;
import com.mathworks.toolbox.distcomp.ui.model.Property;
import com.mathworks.toolbox.distcomp.ui.widget.ConfigurablePropertyView;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;

public final class BooleanView
extends ConfigurablePropertyView {
    private static final String USE_DEFAULT = sRes.getString("configurableview.common.usedefaultlabel");
    private static final String TRUE = sRes.getString("booleanview.comboxbox.truelabel");
    private static final String FALSE = sRes.getString("booleanview.comboxbox.falselabel");

    public BooleanView(Property property, String string) {
        super(property, BooleanView.createUI(property), string, false);
    }

    private static JComponent createUI(Property property) {
        MJComboBox mJComboBox = new MJComboBox((Object[])new String[]{USE_DEFAULT, TRUE, FALSE});
        int n = (int)mJComboBox.getPreferredSize().getHeight();
        mJComboBox.setMinimumSize(new Dimension(210, n));
        mJComboBox.setMaximumSize(new Dimension(210, n));
        mJComboBox.setSize(new Dimension(210, n));
        mJComboBox.setPreferredSize(new Dimension(210, n));
        mJComboBox.addActionListener(new ActionListener((JComboBox)mJComboBox, property){
            final /* synthetic */ JComboBox val$comboBox;
            final /* synthetic */ Property val$property;
            {
                this.val$comboBox = jComboBox;
                this.val$property = property;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BooleanView.updatePropertyValue(this.val$comboBox, this.val$property);
            }
        });
        return mJComboBox;
    }

    @Override
    void commitEdit() {
        Property property = this.getProperty();
        JComboBox jComboBox = (JComboBox)this.getActualComponent();
        BooleanView.updatePropertyValue(jComboBox, property);
    }

    private static void updatePropertyValue(JComboBox jComboBox, Property property) {
        if (jComboBox.getSelectedItem().equals(TRUE)) {
            property.setValue(true);
        } else if (jComboBox.getSelectedItem().equals(FALSE)) {
            property.setValue(false);
        } else if (jComboBox.getSelectedItem().equals(USE_DEFAULT)) {
            property.unsetValue();
        } else assert (false) : "Unknown selection " + jComboBox.getSelectedItem();
    }

    @Override
    void updateUI(JComponent jComponent, Object object) {
        ActionListener[] actionListenerArray;
        for (ActionListener actionListener : actionListenerArray = ((JComboBox)jComponent).getActionListeners()) {
            ((JComboBox)jComponent).removeActionListener(actionListener);
        }
        if (object instanceof DefaultValue) {
            ((JComboBox)jComponent).setSelectedItem(USE_DEFAULT);
        } else {
            assert (object instanceof Boolean) : "BooleanValue can only handle Booleans.";
            ((JComboBox)jComponent).setSelectedItem((Boolean)object != false ? TRUE : FALSE);
        }
        for (ActionListener actionListener : actionListenerArray) {
            ((JComboBox)jComponent).addActionListener(actionListener);
        }
    }
}

