/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui.remote;

import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.toolbox.distcomp.remote.Credential;
import com.mathworks.toolbox.distcomp.remote.ParameterMap;
import com.mathworks.toolbox.distcomp.remote.Password;
import com.mathworks.toolbox.distcomp.remote.PasswordCredentialDescription;
import com.mathworks.toolbox.distcomp.ui.ClickAwayFocusListener;
import com.mathworks.toolbox.distcomp.ui.remote.AbstractCredentialUI;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class PasswordCredentialUI
extends AbstractCredentialUI {
    private MJTextField fUsernameTextField;
    private JPasswordField fPasswordTextField;
    private static String sLastUsedUserName;
    private static final String DEFAULT_USERNAME = "root";
    private String fUsername;
    private Password fPassword;

    PasswordCredentialUI() {
        MJLabel mJLabel = new MJLabel(sRes.getString("remote.passwordcredential.username.label"));
        this.fUsernameTextField = new MJTextField(PasswordCredentialUI.getLastUsedUserName());
        this.fUsernameTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PasswordCredentialUI.this.setUsername(PasswordCredentialUI.this.fUsernameTextField.getText());
            }
        });
        this.fUsernameTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                PasswordCredentialUI.this.setUsername(PasswordCredentialUI.this.fUsernameTextField.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                PasswordCredentialUI.this.setUsername(PasswordCredentialUI.this.fUsernameTextField.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        this.fUsernameTextField.addFocusListener((FocusListener)new ClickAwayFocusListener((JComponent)this.fUsernameTextField, new Runnable(){

            @Override
            public void run() {
                PasswordCredentialUI.this.setUsername(PasswordCredentialUI.this.fUsernameTextField.getText());
            }
        }));
        MJLabel mJLabel2 = new MJLabel(sRes.getString("remote.passwordcredential.password.label"));
        this.fPasswordTextField = new JPasswordField();
        this.fPasswordTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PasswordCredentialUI.this.setPassword(new Password(PasswordCredentialUI.this.fPasswordTextField.getPassword()));
            }
        });
        this.fPasswordTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                PasswordCredentialUI.this.setPassword(new Password(PasswordCredentialUI.this.fPasswordTextField.getPassword()));
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                PasswordCredentialUI.this.setPassword(new Password(PasswordCredentialUI.this.fPasswordTextField.getPassword()));
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        this.fPasswordTextField.addFocusListener(new ClickAwayFocusListener(this.fPasswordTextField, new Runnable(){

            @Override
            public void run() {
                PasswordCredentialUI.this.setPassword(new Password(PasswordCredentialUI.this.fPasswordTextField.getPassword()));
            }
        }));
        this.addLine(new JComponent[][]{{mJLabel, this.fUsernameTextField}});
        this.addLine(new JComponent[][]{{mJLabel2, this.fPasswordTextField}});
        this.fUsernameTextField.setName("PasswordCredentialUI.UsernameTextField");
        this.fPasswordTextField.setName("PasswordCredentialUI.PasswordTextField");
    }

    private static String getLastUsedUserName() {
        if (sLastUsedUserName == null) {
            sLastUsedUserName = DEFAULT_USERNAME;
        }
        return sLastUsedUserName;
    }

    @Override
    Credential getCredential() {
        ParameterMap parameterMap = new ParameterMap();
        parameterMap.put(PasswordCredentialDescription.USERNAME, this.getUsername());
        parameterMap.put(PasswordCredentialDescription.PASSWORD, this.getPassword());
        return PasswordCredentialDescription.INSTANCE.create(parameterMap);
    }

    @Override
    String getLabel() {
        return sRes.getString("remote.passwordcredential.usernamepassword.label");
    }

    private String getUsername() {
        if (this.fUsername == null) {
            this.fUsername = PasswordCredentialUI.getLastUsedUserName();
        }
        return this.fUsername;
    }

    private void setUsername(String string) {
        String string2 = this.fUsername;
        this.fUsername = string;
        sLastUsedUserName = string;
        this.firePropertyChange(CREDENTIAL_CHANGED_PROPERTY, string2, this.fUsername);
    }

    private Password getPassword() {
        if (this.fPassword == null) {
            this.fPassword = new Password("");
        }
        return this.fPassword;
    }

    private void setPassword(Password password) {
        Password password2 = this.fPassword;
        this.fPassword = password;
        this.firePropertyChange(CREDENTIAL_CHANGED_PROPERTY, password2, this.fPassword);
    }
}

