/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui.profile.model;

import com.mathworks.jmi.MatlabWorker;
import com.mathworks.toolbox.distcomp.ui.model.Destroyable;
import com.mathworks.toolbox.distcomp.ui.model.MatlabNullValue;
import com.mathworks.toolbox.distcomp.ui.model.Property;
import com.mathworks.toolbox.distcomp.ui.model.PropertyChangeSupportAdaptor;
import com.mathworks.toolbox.distcomp.ui.profile.model.Profile;
import com.mathworks.toolbox.distcomp.ui.profile.model.ProfileManager;
import com.mathworks.toolbox.distcomp.ui.profile.model.ProjectComponent;
import com.mathworks.toolbox.distcomp.ui.profile.model.SchedulerComponent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public final class MatlabProfileManager
extends PropertyChangeSupportAdaptor
implements ProfileManager {
    private static final String ML_CLASS_NAME = "parallel.internal.ui.MatlabProfileManager";
    private static final String INITIALIZE_METHOD = "parallel.internal.ui.MatlabProfileManager.initialize";
    private static final String ADD_PROFILE_METHOD = "parallel.internal.ui.MatlabProfileManager.addProfile";
    private static final String CLONE_PROFILE_AND_COMPONENTS_METHODS = "parallel.internal.ui.MatlabProfileManager.cloneProfile";
    private static final String REMOVE_PROFILE_AND_NONSHARED_COMPONENTS_METHOD = "parallel.internal.ui.MatlabProfileManager.removeProfile";
    private static final String RENAME_PROFILE_METHOD = "parallel.internal.ui.MatlabProfileManager.renameProfile";
    private static final String SET_VALUES_METHOD = "parallel.internal.ui.MatlabProfileManager.setValues";
    private static final String DISCOVER_CLUSTERS_METHOD = "parallel.internal.ui.MatlabProfileManager.discoverClusters";
    private static final String EXPORT_METHOD = "parallel.internal.ui.MatlabProfileManager.export";
    private static final String EXPORT_ALL_METHOD = "parallel.internal.ui.MatlabProfileManager.exportAll";
    private static final String IMPORT_ALL_METHOD = "parallel.internal.ui.MatlabProfileManager.importAll";
    private static final String PROFILE_OPTION = "Profile";
    private Property fDefaultProfileProperty;
    private Profile fDefaultProfile;
    private final List<Profile> fProfileList = new ArrayList<Profile>();
    private final List<ProjectComponent> fProjectComponentList = new ArrayList<ProjectComponent>();
    private final List<SchedulerComponent> fSchedulerComponentList = new ArrayList<SchedulerComponent>();
    private PropertyChangeListener fDefaultPropertyListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Profile profile = MatlabProfileManager.this.fDefaultProfile;
            String string = (String)propertyChangeEvent.getNewValue();
            MatlabProfileManager.this.fDefaultProfile = MatlabProfileManager.this.getProfile(string);
            MatlabProfileManager.this.firePropertyChange("DefaultProfileChanged", profile, MatlabProfileManager.this.fDefaultProfile);
        }
    };
    private static final boolean SHOW_MATLAB_OUTPUT = false;
    private static final int NO_OUTPUTS = 0;
    private AtomicReference<State> fState = new AtomicReference<State>(State.UNINITIALIZED);

    @Override
    public void initialize() {
        if (this.fState.compareAndSet(State.UNINITIALIZED, State.INITIALIZING)) {
            new MatlabWorker(){

                public Object runOnMatlabThread() throws Exception {
                    return 2.feval((String)MatlabProfileManager.INITIALIZE_METHOD, (Object[])new Object[]{MatlabProfileManager.this}, (int)5, (boolean)false);
                }

                public void runOnAWTEventDispatchThread(Object object) {
                    Object[] objectArray = (Object[])object;
                    Property property = (Property)objectArray[0];
                    List list = (List)objectArray[1];
                    List list2 = (List)objectArray[2];
                    List list3 = (List)objectArray[3];
                    String string = (String)objectArray[4];
                    MatlabProfileManager.this.fDefaultProfileProperty = property;
                    MatlabProfileManager.this.fDefaultProfileProperty.addPropertyChangeListener(MatlabProfileManager.this.fDefaultPropertyListener);
                    MatlabProfileManager.this.fProfileList.clear();
                    MatlabProfileManager.this.fProfileList.addAll(list);
                    MatlabProfileManager.this.fDefaultProfile = MatlabProfileManager.this.getProfile(string);
                    MatlabProfileManager.this.fSchedulerComponentList.clear();
                    MatlabProfileManager.this.fSchedulerComponentList.addAll(list2);
                    MatlabProfileManager.this.fProjectComponentList.clear();
                    MatlabProfileManager.this.fProjectComponentList.addAll(list3);
                    MatlabProfileManager.this.fState.set(State.INITIALIZED);
                    MatlabProfileManager.this.firePropertyChange("Initialized", false, true);
                }
            }.start();
        }
    }

    @Override
    public boolean isInitialized() {
        return this.fState.get().equals((Object)State.INITIALIZED);
    }

    @Override
    public void addProfile() {
        assert (false) : "Not being used";
    }

    @Override
    public void addProfile(final String string) {
        new ErrorHandlingMatlabWorker(){

            public Object runOnMatlabThread() throws Exception {
                return 3.feval((String)MatlabProfileManager.ADD_PROFILE_METHOD, (Object[])new Object[]{string}, (int)0, (boolean)false);
            }

            public void runOnAWTEventDispatchThread(Object object) {
            }
        }.start();
    }

    @Override
    public void addSchedulerComponent(String string) {
        assert (false) : "Not being used";
    }

    @Override
    public void setValues(final String string, final String[] stringArray, final String[] stringArray2, final Object[] objectArray, final String string2, final String[] stringArray3, final String[] stringArray4, final Object[] objectArray2, final String string3, final String[] stringArray5, final String[] stringArray6, final Object[] objectArray3) {
        new ErrorHandlingMatlabWorker(){

            public Object runOnMatlabThread() throws Exception {
                return 4.feval((String)MatlabProfileManager.SET_VALUES_METHOD, (Object[])new Object[]{string, stringArray, stringArray2, objectArray, string2, stringArray3, stringArray4, objectArray2, string3, stringArray5, stringArray6, objectArray3}, (int)1, (boolean)false);
            }

            public void runOnAWTEventDispatchThread(Object object) {
                Comparable<ProjectComponent> comparable;
                if (!(object instanceof MatlabNullValue)) {
                    comparable = (ProjectComponent)object;
                    MatlabProfileManager.this.fProjectComponentList.add(comparable);
                }
                comparable = MatlabProfileManager.this.getProfile(string);
                MatlabProfileManager.this.firePropertyChange("UpdateValues", null, comparable);
            }

            @Override
            protected void handleException(Exception exception, boolean bl) {
                super.handleException(exception, bl);
                Profile profile = MatlabProfileManager.this.getProfile(string);
                if (bl) {
                    MatlabProfileManager.this.firePropertyChange("UpdateValuesErrored", null, profile);
                }
            }
        }.start();
    }

    @Override
    public void addProjectComponent() {
        assert (false) : "Not being used";
    }

    @Override
    public void removeProfile(final String string) {
        new ErrorHandlingMatlabWorker(){

            public Object runOnMatlabThread() throws Exception {
                return 5.feval((String)MatlabProfileManager.REMOVE_PROFILE_AND_NONSHARED_COMPONENTS_METHOD, (Object[])new Object[]{string}, (int)0, (boolean)false);
            }

            public void runOnAWTEventDispatchThread(Object object) {
            }
        }.start();
    }

    @Override
    public void removeSchedulerComponent(String string) {
        assert (false) : "Not being used";
    }

    @Override
    public void removeProjectComponent(String string) {
        assert (false) : "Not being used";
    }

    @Override
    public void renameProfile(final String string, final String string2) {
        new ErrorHandlingMatlabWorker(){

            public Object runOnMatlabThread() throws Exception {
                return 6.feval((String)MatlabProfileManager.RENAME_PROFILE_METHOD, (Object[])new Object[]{string, string2}, (int)0, (boolean)false);
            }

            public void runOnAWTEventDispatchThread(Object object) {
            }
        }.start();
    }

    @Override
    public void renameSchedulerComponent(String string, String string2) {
        assert (false) : "Not being used";
    }

    @Override
    public void renameProjectComponent(String string, String string2) {
        assert (false) : "Not being used";
    }

    @Override
    public void cloneProfile(final String string) {
        new ErrorHandlingMatlabWorker(){

            public Object runOnMatlabThread() throws Exception {
                return 7.feval((String)MatlabProfileManager.CLONE_PROFILE_AND_COMPONENTS_METHODS, (Object[])new Object[]{string}, (int)0, (boolean)false);
            }

            public void runOnAWTEventDispatchThread(Object object) {
            }
        }.start();
    }

    @Override
    public void cloneSchedulerComponent(String string) {
        assert (false) : "Not being used";
    }

    @Override
    public void cloneProjectComponent(String string) {
        assert (false) : "Not being used";
    }

    @Override
    public List<Profile> getProfiles() {
        return Collections.unmodifiableList(this.fProfileList);
    }

    @Override
    public List<SchedulerComponent> getSchedulerComponents() {
        return Collections.unmodifiableList(this.fSchedulerComponentList);
    }

    @Override
    public List<ProjectComponent> getProjectComponents() {
        return Collections.unmodifiableList(this.fProjectComponentList);
    }

    @Override
    public String getDefaultProfile() {
        if (this.fDefaultProfile == null) {
            return null;
        }
        return this.fDefaultProfile.getName();
    }

    @Override
    public void setDefaultProfile(String string) {
        this.fDefaultProfileProperty.setValue(string);
    }

    @Override
    public void importAllProfiles(final String string) {
        new ErrorHandlingMatlabWorker(){

            public Object runOnMatlabThread() throws Exception {
                return 8.feval((String)MatlabProfileManager.IMPORT_ALL_METHOD, (Object[])new Object[]{string}, (int)0, (boolean)false);
            }

            public void runOnAWTEventDispatchThread(Object object) {
            }
        }.start();
    }

    @Override
    public void exportAllProfiles(final String string) {
        new ErrorHandlingMatlabWorker(){

            public Object runOnMatlabThread() throws Exception {
                return 9.feval((String)MatlabProfileManager.EXPORT_ALL_METHOD, (Object[])new Object[]{string}, (int)0, (boolean)false);
            }

            public void runOnAWTEventDispatchThread(Object object) {
            }
        }.start();
    }

    @Override
    public void exportProfile(final String string, final String string2) {
        new ErrorHandlingMatlabWorker(){

            public Object runOnMatlabThread() throws Exception {
                return 10.feval((String)MatlabProfileManager.EXPORT_METHOD, (Object[])new Object[]{MatlabProfileManager.PROFILE_OPTION, string, string2}, (int)0, (boolean)false);
            }

            public void runOnAWTEventDispatchThread(Object object) {
            }
        }.start();
    }

    @Override
    public void exportSchedulerComponent(String string, String string2) {
        assert (false) : "Not being used";
    }

    @Override
    public void exportProjectComponent(String string, String string2) {
        assert (false) : "Not being used";
    }

    @Override
    public void discoverClusters() {
        new ErrorHandlingMatlabWorker(){

            public Object runOnMatlabThread() throws Exception {
                return 11.feval((String)MatlabProfileManager.DISCOVER_CLUSTERS_METHOD, (Object[])new Object[0], (int)0, (boolean)false);
            }

            public void runOnAWTEventDispatchThread(Object object) {
            }
        }.start();
    }

    @Override
    public void destroy() {
        for (Profile comparable : this.fProfileList) {
            comparable.destroy();
        }
        this.fProfileList.clear();
        this.fDefaultProfile = null;
        for (SchedulerComponent schedulerComponent : this.fSchedulerComponentList) {
            schedulerComponent.destroy();
        }
        this.fSchedulerComponentList.clear();
        for (ProjectComponent projectComponent : this.fProjectComponentList) {
            projectComponent.destroy();
        }
        this.fProjectComponentList.clear();
        this.fDefaultProfileProperty.removePropertyChangeListener(this.fDefaultPropertyListener);
        this.fDefaultProfileProperty.destroy();
        this.fDefaultProfileProperty = null;
    }

    @Override
    public Profile getProfile(String string) {
        Profile profile = null;
        for (Profile profile2 : this.fProfileList) {
            if (!profile2.getName().equals(string)) continue;
            profile = profile2;
        }
        return profile;
    }

    @Override
    public SchedulerComponent getSchedulerComponent(String string) {
        SchedulerComponent schedulerComponent = null;
        for (SchedulerComponent schedulerComponent2 : this.fSchedulerComponentList) {
            if (!schedulerComponent2.getName().equals(string)) continue;
            schedulerComponent = schedulerComponent2;
        }
        return schedulerComponent;
    }

    @Override
    public ProjectComponent getProjectComponent(String string) {
        for (ProjectComponent projectComponent : this.fProjectComponentList) {
            if (!projectComponent.getName().equals(string)) continue;
            return projectComponent;
        }
        return null;
    }

    public String[] getProjectComponentNames() {
        String[] stringArray = new String[this.fProjectComponentList.size()];
        for (int i = 0; i < this.fProjectComponentList.size(); ++i) {
            stringArray[i] = this.fProjectComponentList.get(i).getName();
        }
        return stringArray;
    }

    public String[] getSchedulerComponentNames() {
        String[] stringArray = new String[this.fSchedulerComponentList.size()];
        for (int i = 0; i < this.fSchedulerComponentList.size(); ++i) {
            stringArray[i] = this.fSchedulerComponentList.get(i).getName();
        }
        return stringArray;
    }

    public String[] getProfileNames() {
        String[] stringArray = new String[this.fProfileList.size()];
        for (int i = 0; i < this.fProfileList.size(); ++i) {
            stringArray[i] = this.fProfileList.get(i).getName();
        }
        return stringArray;
    }

    public void addObject(Object object) {
        String string = "";
        if (object instanceof Profile) {
            this.fProfileList.add((Profile)object);
            string = "ProfileAdded";
        } else if (object instanceof SchedulerComponent) {
            this.fSchedulerComponentList.add((SchedulerComponent)object);
            string = "SchedulerComponentAdded";
        } else if (object instanceof ProjectComponent) {
            this.fProjectComponentList.add((ProjectComponent)object);
            string = "ProjectComponentAdded";
        } else assert (false) : "Unknown object " + object;
        this.firePropertyChange(string, null, object);
    }

    public void deleteObject(Destroyable destroyable) {
        String string = "";
        if (destroyable instanceof Profile) {
            this.fProfileList.remove(destroyable);
            string = "ProfileRemoved";
        } else if (destroyable instanceof SchedulerComponent) {
            this.fSchedulerComponentList.remove(destroyable);
            string = "SchedulerComponentRemoved";
        } else if (destroyable instanceof ProjectComponent) {
            this.fProjectComponentList.remove(destroyable);
            string = "ProjectComponentRemoved";
        } else assert (false) : "Unknown object " + destroyable;
        destroyable.destroy();
        this.firePropertyChange(string, null, destroyable);
    }

    public void renameObject(Object object, String string) {
        String string2 = "";
        if (object instanceof Profile) {
            ((Profile)object).setName(string);
            string2 = "ProfileRenamed";
        } else if (object instanceof SchedulerComponent) {
            ((SchedulerComponent)object).setName(string);
            string2 = "SchedulerComponentRenamed";
        } else if (object instanceof ProjectComponent) {
            ((ProjectComponent)object).setName(string);
            string2 = "ProjectComponentRenamed";
        } else assert (false) : "Unknown object " + object;
        this.firePropertyChange(string2, null, object);
    }

    private static enum State {
        UNINITIALIZED,
        INITIALIZING,
        INITIALIZED;

    }

    private abstract class ErrorHandlingMatlabWorker
    extends MatlabWorker<Object> {
        private ErrorHandlingMatlabWorker() {
        }

        protected void handleException(Exception exception, boolean bl) {
            if (bl) {
                MatlabProfileManager.this.firePropertyChange("ErrorOccurred", null, exception.getMessage());
            } else {
                super.handleException(exception, bl);
            }
        }
    }
}

