/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui.discover;

import com.jidesoft.wizard.DefaultWizardPage;
import com.mathworks.jmi.Callback;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJMultilineCheckBox;
import com.mathworks.toolbox.distcomp.ui.discover.PageActionProvider;
import com.mathworks.toolbox.distcomp.ui.discover.model.DiscoverClusterWizardModel;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuidePanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JPanel;

final class SelectLocationPage
extends DefaultWizardPage
implements PropertyChangeListener,
PageActionProvider {
    private final DiscoverClusterWizardModel fDiscoverClusterModel;
    private final Callback fStartDiscoveryCallback = new Callback();
    private final MJMultilineCheckBox fDiscoverOnNetworkCheckBox;
    private final MJMultilineCheckBox fDiscoverInCloudCheckBox;
    private static final ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.toolbox.distcomp.ui.resources.RES_profile");

    SelectLocationPage(DiscoverClusterWizardModel discoverClusterWizardModel) {
        super(sRes.getString("DiscoverDialog.SelectLocationPage"));
        this.fDiscoverClusterModel = discoverClusterWizardModel;
        this.fDiscoverClusterModel.addPropertyChangeListener(this);
        MJLabel mJLabel = new MJLabel(sRes.getString("DiscoverDialog.SelectLocationPage.WhereLabel"));
        this.fDiscoverOnNetworkCheckBox = new MJMultilineCheckBox(sRes.getString("DiscoverDialog.SelectLocationPage.NetworkCheckBox"), this.fDiscoverClusterModel.isDiscoverNetwork());
        this.fDiscoverOnNetworkCheckBox.getCheckBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectLocationPage.this.fDiscoverClusterModel.setDiscoverNetwork(SelectLocationPage.this.fDiscoverOnNetworkCheckBox.getCheckBox().isSelected());
            }
        });
        this.fDiscoverInCloudCheckBox = new MJMultilineCheckBox(sRes.getString("DiscoverDialog.SelectLocationPage.CloudCheckBox"), this.fDiscoverClusterModel.isDiscoverCloud());
        this.fDiscoverInCloudCheckBox.getCheckBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectLocationPage.this.fDiscoverClusterModel.setDiscoverCloud(SelectLocationPage.this.fDiscoverInCloudCheckBox.getCheckBox().isSelected());
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setMinimumSize(new Dimension(0, 20));
        StyleGuidePanel styleGuidePanel = new StyleGuidePanel();
        styleGuidePanel.addLine((JComponent)mJLabel);
        styleGuidePanel.addLine(jPanel);
        styleGuidePanel.addLine((JComponent)this.fDiscoverOnNetworkCheckBox);
        styleGuidePanel.addLine((JComponent)this.fDiscoverInCloudCheckBox);
        styleGuidePanel.addLine(new JPanel(), 8);
        this.addComponent((JComponent)((Object)styleGuidePanel), true);
        this.fDiscoverOnNetworkCheckBox.getCheckBox().setName("DiscoverOnNetworkCheckBox");
        this.fDiscoverInCloudCheckBox.getCheckBox().setName("DiscoverOnCloudCheckBox");
    }

    public void setupWizardButtons() {
        super.setupWizardButtons();
        this.fireButtonEvent(3300, "BACK");
        this.fireButtonEvent(3300, "FINISH");
        this.fireButtonEvent(3299, "CANCEL");
        this.fireButtonEvent(3299, "NEXT");
        this.setupNextButton();
        this.fireButtonEvent(3301, "CANCEL");
        Component component = this.fDiscoverClusterModel.isDiscoverNetwork() || this.fDiscoverClusterModel.isDiscoverCloud() ? this.getOwner().getButtonPanel().getButtonByName("NEXT") : this.getOwner().getButtonPanel().getButtonByName("CANCEL");
        this.setDefaultFocusComponent(component);
    }

    public boolean showBannerPane() {
        return false;
    }

    @Override
    public void doCancel() {
    }

    @Override
    public void doNext() {
        this.fireButtonEvent(3302, "NEXT");
        this.fDiscoverClusterModel.discoveryStarted();
        this.fStartDiscoveryCallback.postCallback();
    }

    @Override
    public void doFinish() {
        assert (false) : "Finish should not be called";
    }

    public Callback getCallback() {
        return this.fStartDiscoveryCallback;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("DiscoverNetwork")) {
            this.fDiscoverOnNetworkCheckBox.getCheckBox().setSelected(this.fDiscoverClusterModel.isDiscoverNetwork());
            this.setupNextButton();
        } else if (string.equals("DiscoverCloud")) {
            this.fDiscoverInCloudCheckBox.getCheckBox().setSelected(this.fDiscoverClusterModel.isDiscoverCloud());
            this.setupNextButton();
        }
    }

    private void setupNextButton() {
        if (!this.fDiscoverClusterModel.isDiscoverNetwork() && !this.fDiscoverClusterModel.isDiscoverCloud()) {
            this.fireButtonEvent(3302, "NEXT");
        } else {
            this.fireButtonEvent(3301, "NEXT");
        }
    }
}

