/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui;

import com.mathworks.mlwidgets.html.HTMLPrefs;
import com.mathworks.mwswing.MJEditorPane;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.ui.PackageInfo;
import com.mathworks.toolbox.distcomp.util.ResourceBundleUtilities;
import java.awt.Component;
import java.awt.Frame;
import java.io.IOException;
import java.net.URL;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class BrowserLauncher {
    private static final ResourceBundleUtilities sRes = ResourceBundleUtilities.getInstance(BrowserLauncher.class);

    public static void launchURL(Frame frame, URL uRL) {
        if (uRL == null) {
            throw new IllegalArgumentException("URL cannot be null");
        }
        if (!uRL.getProtocol().toUpperCase().equals("HTTP") && !uRL.getProtocol().toUpperCase().equals("HTTPS")) {
            throw new IllegalArgumentException("Can only open HTTP or HTTPS URL's");
        }
        String string = System.getProperty("os.name");
        boolean bl = false;
        boolean bl2 = false;
        if (string.startsWith("Mac OS")) {
            bl = true;
        } else if (string.startsWith("Windows")) {
            bl2 = true;
        }
        if (bl) {
            try {
                Runtime.getRuntime().exec("open " + uRL);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else if (bl2) {
            try {
                Runtime.getRuntime().exec("cmd.exe /C start " + uRL);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            try {
                Runtime.getRuntime().exec(HTMLPrefs.getSystemBrowser() + " " + uRL);
            }
            catch (IOException iOException) {
                PackageInfo.LOGGER.log(DistcompLevel.ONE, "", iOException);
                int n = UIManager.getIcon("OptionPane.warningIcon").getIconWidth();
                MJEditorPane mJEditorPane = new MJEditorPane();
                mJEditorPane.setBorder((Border)new EmptyBorder(0, 0, 0, n));
                mJEditorPane.setOpaque(false);
                mJEditorPane.setEditable(false);
                mJEditorPane.setContentType("text/html");
                mJEditorPane.setText(sRes.getString("browser.error.dialog.message", uRL));
                MJOptionPane.showMessageDialog((Component)frame, (Object)mJEditorPane, (String)sRes.getString("browser.error.dialog.title", new Object[0]), (int)2);
            }
        }
    }
}

