/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.storage;

import com.mathworks.toolbox.distcomp.storage.CredentialStorage;
import com.mathworks.toolbox.distcomp.storage.DataStorage;
import com.mathworks.toolbox.distcomp.storage.DatabaseConnectionPool;
import com.mathworks.toolbox.distcomp.storage.DatabaseStorage;
import com.mathworks.toolbox.distcomp.storage.H2CredentialStorage;
import com.mathworks.toolbox.distcomp.storage.H2DatabaseConnectionPool;
import com.mathworks.toolbox.distcomp.storage.H2DatabaseStorage;
import com.mathworks.toolbox.distcomp.storage.LRUCache;
import com.mathworks.toolbox.distcomp.storage.StorageFactory;
import com.mathworks.toolbox.distcomp.storage.StorageInitException;
import com.mathworks.toolbox.distcomp.storage.fileblobs.BlobFile;
import com.mathworks.toolbox.distcomp.storage.fileblobs.BlobFileDataStorage;
import com.mathworks.toolbox.distcomp.storage.fileblobs.BlobFileFactory;
import com.mathworks.toolbox.distcomp.storage.fileblobs.H2BlobFileStorage;
import com.mathworks.toolbox.distcomp.workunit.WorkUnitImpl;
import net.jini.id.Uuid;

public class H2StorageFactory
implements StorageFactory {
    private DatabaseConnectionPool fDatabaseConnectionPool;
    private String fDirName;

    public H2StorageFactory(String string) throws StorageInitException {
        this.fDirName = string == null ? System.getProperty("user.dir") : string;
        this.fDatabaseConnectionPool = H2DatabaseConnectionPool.getH2DatabaseConnectionPool(this.fDirName);
    }

    @Override
    public DatabaseStorage createDatabaseStorage(int n) throws StorageInitException {
        LRUCache<Uuid, WorkUnitImpl> lRUCache = new LRUCache<Uuid, WorkUnitImpl>(n);
        return new H2DatabaseStorage(lRUCache, this.fDatabaseConnectionPool);
    }

    @Override
    public CredentialStorage createCredentialStorage() throws StorageInitException {
        return new H2CredentialStorage(this.fDatabaseConnectionPool);
    }

    @Override
    public DataStorage createBlobFileDataStorage(int n, int n2) throws StorageInitException {
        LRUCache<Uuid, BlobFile> lRUCache = new LRUCache<Uuid, BlobFile>(n);
        BlobFileFactory blobFileFactory = new BlobFileFactory(n2);
        H2BlobFileStorage h2BlobFileStorage = new H2BlobFileStorage(lRUCache, this.fDatabaseConnectionPool, blobFileFactory);
        return new BlobFileDataStorage(this.fDirName, h2BlobFileStorage, blobFileFactory);
    }
}

