/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.storage;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public abstract class CachedPreparedStatement {
    private String fSqlString;
    private PreparedStatement fStatement;
    private boolean fStatementAvailable = true;

    protected CachedPreparedStatement(String string) {
        this.fSqlString = string;
    }

    protected synchronized PreparedStatement getStatement(Connection connection) throws SQLException {
        if (this.fStatement == null) {
            this.fStatement = this.createStatement(connection);
        }
        if (this.fStatementAvailable && this.fStatement != null) {
            this.fStatementAvailable = false;
            return this.fStatement;
        }
        return this.createStatement(connection);
    }

    protected synchronized void releaseStatement(PreparedStatement preparedStatement) throws SQLException {
        if (this.fStatement == preparedStatement) {
            this.fStatement.clearParameters();
            this.fStatementAvailable = true;
        } else {
            preparedStatement.close();
        }
    }

    private PreparedStatement createStatement(Connection connection) throws SQLException {
        PreparedStatement preparedStatement = null;
        if (connection != null && this.fSqlString != null) {
            preparedStatement = connection.prepareStatement(this.fSqlString);
        }
        return preparedStatement;
    }
}

