/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.remote.util;

import com.mathworks.toolbox.distcomp.remote.Logger;
import com.mathworks.toolbox.distcomp.util.concurrent.SignalingAtomicBoolean;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;

public final class SingleStreamRedirector
implements Runnable {
    private final DataInputStream fInput;
    private final OutputStream fOutput;
    private final boolean fPreprendLineHeaders;
    private final String fBareLineHeader;
    private SignalingAtomicBoolean fEof = new SignalingAtomicBoolean(false);
    private static final String sLineSeparator = System.getProperty("line.separator");

    public SingleStreamRedirector(InputStream inputStream, OutputStream outputStream) {
        this(inputStream, outputStream, null);
    }

    SingleStreamRedirector(InputStream inputStream, OutputStream outputStream, String string) {
        this.fInput = new DataInputStream(inputStream);
        this.fOutput = outputStream;
        this.fPreprendLineHeaders = string != null;
        this.fBareLineHeader = string == null ? "" : string + " ";
    }

    private void signalEof() {
        this.fEof.set(true);
        Logger.LOGGER.finest(this.fBareLineHeader + ": signaled EOF");
    }

    boolean awaitEof() throws InterruptedException {
        Logger.LOGGER.finest(this.fBareLineHeader + ": waiting for EOF");
        this.fEof.awaitTrue();
        Logger.LOGGER.finest(this.fBareLineHeader + ": finished waiting for EOF");
        return this.fEof.get();
    }

    boolean isAtEoF() {
        return this.fEof.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            String string;
            Logger.LOGGER.finest(this.fBareLineHeader + ": run() Redirector.");
            do {
                if ((string = this.readLine()) == null) continue;
                if (this.fPreprendLineHeaders) {
                    string = this.prependLineHeaders(string);
                }
                if (!string.endsWith(sLineSeparator)) {
                    string = string + sLineSeparator;
                }
                this.fOutput.write(string.getBytes());
                this.fOutput.flush();
                Logger.LOGGER.finest(this.fBareLineHeader + " wrote and flushed " + new String(string.getBytes()));
            } while (string != null);
            this.fInput.close();
        }
        catch (IOException iOException) {
            Logger.LOGGER.log(Level.WARNING, this.fBareLineHeader + "Problem in Redirector.", iOException);
        }
        finally {
            this.signalEof();
            Logger.LOGGER.finest(this.fBareLineHeader + ": finished run() Redirector.");
        }
    }

    private String readLine() throws IOException {
        try {
            return this.fInput.readLine();
        }
        catch (IOException iOException) {
            if (iOException.getMessage().equals("Stream closed")) {
                Logger.LOGGER.log(Level.FINEST, "Stream closed. Returning null.", iOException);
                return null;
            }
            throw iOException;
        }
    }

    private String prependLineHeaders(String string) {
        return this.fBareLineHeader + string;
    }
}

