/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.remote.spi.plugin;

import com.mathworks.toolbox.distcomp.remote.CopyFuture;
import com.mathworks.toolbox.distcomp.remote.Logger;
import com.mathworks.toolbox.distcomp.remote.ProtocolFulfillmentException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.logging.Level;

final class ProcessCopyFuture
implements CopyFuture {
    private final Process fProcess;
    private final String fCommand;
    private final String fHostname;

    ProcessCopyFuture(Process process, String string, String string2) {
        this.fProcess = process;
        this.fCommand = string;
        this.fHostname = string2;
    }

    @Override
    public void cancel() {
        this.fProcess.destroy();
        Logger.LOGGER.fine(this.fHostname + " " + this.fCommand + " cancelled.");
    }

    @Override
    public boolean isRunning() {
        try {
            this.fProcess.exitValue();
            return false;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return true;
        }
    }

    @Override
    public void awaitEnd() throws InterruptedException, ProtocolFulfillmentException {
        Reader reader = null;
        try {
            String string;
            int n;
            reader = new InputStreamReader(new BufferedInputStream(this.fProcess.getErrorStream()));
            StringBuffer stringBuffer = new StringBuffer();
            char[] cArray = new char[1024];
            while ((n = reader.read(cArray)) != -1) {
                string = String.valueOf(cArray, 0, n);
                stringBuffer.append(string);
                cArray = new char[1024];
            }
            string = stringBuffer.toString();
            if (!"".equals(string)) {
                throw new ProtocolFulfillmentException(string);
            }
        }
        catch (IOException iOException) {
            throw new ProtocolFulfillmentException(iOException);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    Logger.LOGGER.log(Level.WARNING, this.fHostname + " " + this.fCommand + "Problem closing stderr Reader", iOException);
                }
            }
        }
        Logger.LOGGER.finest(this.fHostname + " " + this.fCommand + " waiting to complete.");
        this.fProcess.waitFor();
        Logger.LOGGER.fine(this.fHostname + " " + this.fCommand + " finished waiting.");
    }
}

