/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.remote.spi.plugin;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.mathworks.toolbox.distcomp.remote.CopyFuture;
import com.mathworks.toolbox.distcomp.remote.CopyToRemoteCommand;
import com.mathworks.toolbox.distcomp.remote.DispatchException;
import com.mathworks.toolbox.distcomp.remote.FulfillmentException;
import com.mathworks.toolbox.distcomp.remote.Logger;
import com.mathworks.toolbox.distcomp.remote.ParameterMap;
import com.mathworks.toolbox.distcomp.remote.ProtocolDispatchException;
import com.mathworks.toolbox.distcomp.remote.spi.Lease;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.JSchFutureHelper;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.JSchLeasableSession;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.JSchSCPAcknowledgeException;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.JSchSessionLeaseSource;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;

final class JSchCopyToFuture
implements CopyFuture,
Runnable {
    private final JSchFutureHelper fHelper;
    private final CopyToRemoteCommand fCommand;
    private static final int BUFFER_SIZE = 16384;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static JSchCopyToFuture createJschCopyToFuture(CopyToRemoteCommand copyToRemoteCommand, String string, ParameterMap parameterMap, String string2) throws DispatchException {
        boolean bl = false;
        Lease<JSchLeasableSession> lease = null;
        try {
            lease = JSchSessionLeaseSource.INSTANCE.getLease(string, parameterMap);
            JSchCopyToFuture jSchCopyToFuture = new JSchCopyToFuture(copyToRemoteCommand, lease, string2);
            JSchFutureHelper.startThread(jSchCopyToFuture, string2);
            bl = true;
            JSchCopyToFuture jSchCopyToFuture2 = jSchCopyToFuture;
            return jSchCopyToFuture2;
        }
        finally {
            if (!bl && lease != null) {
                lease.release();
            }
        }
    }

    private JSchCopyToFuture(CopyToRemoteCommand copyToRemoteCommand, Lease<JSchLeasableSession> lease, String string) throws ProtocolDispatchException {
        try {
            this.fCommand = copyToRemoteCommand;
            String string2 = JSchCopyToFuture.createScpCommand(copyToRemoteCommand.getLocalFile(), copyToRemoteCommand.getRemoteFile());
            ChannelExec channelExec = JSchCopyToFuture.createChannelExec(lease.getLeasedConnection().getSession(), string2, string);
            this.fHelper = new JSchFutureHelper(lease, (Channel)channelExec, string);
        }
        catch (JSchException jSchException) {
            throw new ProtocolDispatchException(string + "Could not connect to channel.", (Throwable)jSchException);
        }
    }

    private File getLocalFile() {
        return this.fCommand.getLocalFile();
    }

    private String getRemoteFile() {
        return this.fCommand.getRemoteFile();
    }

    private static String createScpCommand(File file, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("scp ");
        if (file.isDirectory()) {
            stringBuilder.append("-d -r ");
        }
        stringBuilder.append("-t ");
        stringBuilder.append("\"");
        stringBuilder.append(string);
        stringBuilder.append("\"");
        return stringBuilder.toString();
    }

    private static ChannelExec createChannelExec(Session session, String string, String string2) throws JSchException {
        ChannelExec channelExec = (ChannelExec)session.openChannel("exec");
        channelExec.setCommand(string);
        Logger.LOGGER.finest(string2 + " " + string);
        return channelExec;
    }

    @Override
    public void cancel() {
        this.fHelper.cancel();
    }

    @Override
    public boolean isRunning() {
        return this.fHelper.isRunning();
    }

    @Override
    public void awaitEnd() throws InterruptedException, FulfillmentException {
        this.fHelper.awaitEnd();
    }

    public boolean isExitStatusOfRemoteCommand() {
        return this.fHelper.isExitStatusOfRemoteCommand();
    }

    public int getExitStatus() throws InterruptedException, FulfillmentException {
        return this.fHelper.getExitStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block16: {
            try {
                try {
                    try {
                        if (this.fHelper.hasBeenCancelled()) break block16;
                        this.fHelper.connectToChannel();
                        try {
                            this.copyFiles(this.getLocalFile().getName());
                        }
                        catch (JSchSCPAcknowledgeException jSchSCPAcknowledgeException) {
                            if (jSchSCPAcknowledgeException.getAck() == 1 && jSchSCPAcknowledgeException.rawMessageIsNO_SUCH_FILE_OR_DIRECTORY()) {
                                this.createRemoteDirectoryAndCopy(jSchSCPAcknowledgeException);
                            }
                            throw jSchSCPAcknowledgeException;
                        }
                        this.fHelper.waitForChannelToClose();
                        Logger.LOGGER.fine(this.fHelper.getLogIDString() + ": completed ");
                    }
                    catch (InterruptedException interruptedException) {
                        Logger.LOGGER.log(Level.FINE, this.fHelper.getLogIDString() + ": interrupted", interruptedException);
                    }
                    catch (Exception exception) {
                        this.fHelper.handleException(exception);
                    }
                    finally {
                        this.fHelper.disconnectFromChannel();
                    }
                }
                finally {
                    this.fHelper.releaseLease();
                }
            }
            finally {
                this.fHelper.signalCompleted();
            }
        }
    }

    private void createRemoteDirectoryAndCopy(JSchSCPAcknowledgeException jSchSCPAcknowledgeException) throws JSchException, IOException, JSchSCPAcknowledgeException {
        File file = new File(this.getRemoteFile()).getParentFile();
        if (file == null) {
            throw jSchSCPAcknowledgeException;
        }
        Logger.LOGGER.finest(this.fHelper.getLogIDString() + ": " + jSchSCPAcknowledgeException.getMessage() + " Retrying, copying to " + file);
        String string = JSchCopyToFuture.createScpCommand(this.getLocalFile(), file.toString());
        try {
            ChannelExec channelExec = JSchCopyToFuture.createChannelExec(this.fHelper.getSession(), string, this.fHelper.getLogIDString());
            this.fHelper.replaceCommandAndChannel((Channel)channelExec);
            this.copyFiles(new File(this.getRemoteFile()).getName());
        }
        catch (JSchException jSchException) {
            Logger.LOGGER.log(Level.WARNING, this.fHelper.getLogIDString() + ": Problem while trying to copy to a new directory", jSchSCPAcknowledgeException);
            throw jSchException;
        }
        catch (IOException iOException) {
            Logger.LOGGER.log(Level.WARNING, this.fHelper.getLogIDString() + ": Problem while trying to copy to a new directory", jSchSCPAcknowledgeException);
            throw iOException;
        }
        catch (JSchSCPAcknowledgeException jSchSCPAcknowledgeException2) {
            Logger.LOGGER.log(Level.WARNING, this.fHelper.getLogIDString() + ": Problem while trying to copy to a new directory", jSchSCPAcknowledgeException);
            throw jSchSCPAcknowledgeException2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFiles(String string) throws IOException, JSchException, JSchSCPAcknowledgeException {
        OutputStream outputStream = null;
        try {
            outputStream = this.fHelper.getOutputStream();
            InputStream inputStream = null;
            try {
                inputStream = this.fHelper.getInputStream();
                this.checkAck(inputStream);
                this.copyFiles(this.getLocalFile(), string, inputStream, outputStream);
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    private String getFilePermissionString(File file) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (file.isDirectory() || file.canExecute()) {
            ++n2;
        }
        if (file.canWrite()) {
            n2 += 2;
        }
        if (file.canRead()) {
            n2 += 4;
        }
        return Integer.toString(n) + Integer.toString(n2) + Integer.toString(n3) + Integer.toString(n4);
    }

    private void copyFiles(File file, String string, InputStream inputStream, OutputStream outputStream) throws IOException, JSchSCPAcknowledgeException {
        if (!this.fHelper.hasBeenCancelled() && !this.fCommand.isExcluded(file)) {
            if (file.isDirectory()) {
                String string2 = "D" + this.getFilePermissionString(file) + " 0 " + string + "\n";
                this.sendCommand(string2, outputStream, inputStream);
                Logger.LOGGER.finest(this.fHelper.getLogIDString() + ": created remote directory " + string);
                for (File file2 : file.listFiles()) {
                    this.copyFiles(file2, file2.getName(), inputStream, outputStream);
                }
                this.sendCommand("E\n", outputStream, inputStream);
            } else if (file.isFile()) {
                this.copyFile(file, inputStream, outputStream);
            } else {
                Logger.LOGGER.warning(this.fHelper.getLogIDString() + ":" + file + " is not a file or a directory.");
            }
        }
    }

    private void copyFile(File file, InputStream inputStream, OutputStream outputStream) throws IOException, JSchSCPAcknowledgeException {
        if (!this.fHelper.hasBeenCancelled()) {
            String string = "C" + this.getFilePermissionString(file) + " " + file.length() + " " + file.getName() + "\n";
            this.sendCommand(string, outputStream, inputStream);
            this.sendFile(file, outputStream, inputStream);
            Logger.LOGGER.finest(this.fHelper.getLogIDString() + ": copied " + file.getAbsolutePath());
        }
    }

    private int checkAck(InputStream inputStream) throws IOException, JSchSCPAcknowledgeException {
        int n;
        int n2 = inputStream.read();
        if (n2 == 0 || n2 == -1) {
            return n2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        do {
            n = inputStream.read();
            stringBuilder.append((char)n);
        } while (n != 10 && n != -1);
        String string = stringBuilder.toString();
        String string2 = this.getRemoteFile() + " " + string;
        if (n2 == 1) {
            throw new JSchSCPAcknowledgeException("error: " + string2, string, n2);
        }
        if (n2 == 2) {
            throw new JSchSCPAcknowledgeException("fatal error: " + string2, string, n2);
        }
        throw new JSchSCPAcknowledgeException("Unknown ssh error code:" + n2 + " " + string2, string, n2);
    }

    private void sendCommand(String string, OutputStream outputStream, InputStream inputStream) throws IOException, JSchSCPAcknowledgeException {
        outputStream.write(string.getBytes());
        outputStream.flush();
        int n = this.checkAck(inputStream);
        if (n == -1) {
            throw new JSchSCPAcknowledgeException("Unexpected end of stream, ack of " + n, null, n);
        }
        if (n != 0) {
            throw new JSchSCPAcknowledgeException("Unexpected ack of " + n, null, n);
        }
    }

    private void sendZero(OutputStream outputStream) throws IOException {
        int n = 0;
        outputStream.write(n);
        outputStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendFile(File file, OutputStream outputStream, InputStream inputStream) throws IOException, JSchSCPAcknowledgeException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        FileInputStream fileInputStream = null;
        try {
            boolean bl;
            int n;
            fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[16384];
            do {
                if ((n = ((InputStream)fileInputStream).read(byArray, 0, byArray.length)) > 0) {
                    bufferedOutputStream.write(byArray, 0, n);
                }
                bl = this.fHelper.hasBeenCancelled();
            } while (n > 0 && !bl);
            if (bl) {
                Logger.LOGGER.warning(this.fHelper.getLogIDString() + ": cancelled part way through sending " + file);
            }
        }
        finally {
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
        }
        this.sendZero(bufferedOutputStream);
        bufferedOutputStream.flush();
        this.checkAck(inputStream);
    }
}

