/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.remote.cli;

import com.mathworks.toolbox.distcomp.remote.Command;
import com.mathworks.toolbox.distcomp.remote.I18nRemoteExecutionException;
import com.mathworks.toolbox.distcomp.remote.Logger;
import com.mathworks.toolbox.distcomp.remote.NoMatchingProtocolException;
import com.mathworks.toolbox.distcomp.remote.NoSuchProtocolException;
import com.mathworks.toolbox.distcomp.remote.Parameter;
import com.mathworks.toolbox.distcomp.remote.ParameterMap;
import com.mathworks.toolbox.distcomp.remote.ParameterSet;
import com.mathworks.toolbox.distcomp.remote.Password;
import com.mathworks.toolbox.distcomp.remote.ProtocolProvider;
import com.mathworks.toolbox.distcomp.remote.RemoteExecutionException;
import com.mathworks.toolbox.distcomp.remote.RemoteExecutor;
import com.mathworks.toolbox.distcomp.remote.cli.CommandCreationErrorCode;
import com.mathworks.toolbox.distcomp.remote.cli.CommandLineCanceledException;
import com.mathworks.toolbox.distcomp.remote.cli.CommandLineParser;
import com.mathworks.toolbox.distcomp.remote.cli.CommandSpecifier;
import com.mathworks.toolbox.distcomp.remote.cli.GlobalParameter;
import com.mathworks.toolbox.distcomp.remote.cli.InternalStateException;
import com.mathworks.toolbox.distcomp.remote.cli.ResourceHandler;
import com.mathworks.toolbox.distcomp.remote.spi.Protocol;
import java.io.Console;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Scanner;

final class UserPrompt {
    private ResourceHandler fHandler;

    UserPrompt(ResourceHandler resourceHandler) {
        this.fHandler = resourceHandler;
    }

    Protocol promptForProtocol(Class<? extends Command> clazz) {
        List<String> list;
        try {
            list = ProtocolProvider.getInstance().getProtocolTypes(clazz);
        }
        catch (NoMatchingProtocolException noMatchingProtocolException) {
            throw new IllegalValueException(clazz.getSimpleName(), noMatchingProtocolException);
        }
        String string = null;
        try {
            string = this.askQuestionRepeatedly(GlobalParameter.PROTOCOL, list);
        }
        catch (NoSuchElementException noSuchElementException) {
            Logger.LOGGER.fine("Standard input has been closed, the process may have been interrupted.");
        }
        if (string == null) {
            return null;
        }
        try {
            return ProtocolProvider.getInstance().getProtocolByType(string);
        }
        catch (NoSuchProtocolException noSuchProtocolException) {
            throw new IllegalValueException(string, noSuchProtocolException);
        }
    }

    void promptForParameters(CommandSpecifier commandSpecifier) {
        Object object;
        if (commandSpecifier.getProtocol() == null) {
            try {
                commandSpecifier.setProtocol(RemoteExecutor.getRecommendedProtocol(commandSpecifier.getCommand().getClass()));
            }
            catch (NoMatchingProtocolException noMatchingProtocolException) {
                throw new IllegalValueException(commandSpecifier.getCommand().getClass().getSimpleName(), noMatchingProtocolException);
            }
        }
        if (commandSpecifier.getProtocol().getParameterSet().hasCredentialParameter()) {
            if (commandSpecifier.getCredentialDescription() == null) {
                commandSpecifier.setCredentialParameter(commandSpecifier.getProtocol().getParameterSet().getCredentialParameter());
                commandSpecifier.setCredentialDescription(commandSpecifier.getProtocol().getParameterSet().getCredentialParameter().getDefaultCredentialDescription());
                commandSpecifier.setCredentialParameterMap(new ParameterMap());
            }
            try {
                for (Parameter object2 : commandSpecifier.getCredentialDescription().getParameterSet().getParameters()) {
                    this.promptForParameter(object2, commandSpecifier.getCredentialParameterMap(), null);
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                Logger.LOGGER.fine("Standard input has been closed, the process may have been interrupted.");
            }
            object = commandSpecifier.getCredentialDescription().create(commandSpecifier.getCredentialParameterMap());
            commandSpecifier.getProtocolParameterMap().put(commandSpecifier.getCredentialParameter(), object);
        }
        object = commandSpecifier.getProtocol().getParameterSet();
        try {
            for (Parameter<?> parameter : ((ParameterSet)object).getParameters()) {
                this.promptForParameter(parameter, commandSpecifier.getProtocolParameterMap(), null);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            Logger.LOGGER.fine("Standard input has been closed, the process may have been interrupted.");
        }
    }

    private <V> void promptForParameter(Parameter<V> parameter, ParameterMap parameterMap, List<V> list) {
        if (!parameterMap.containsKey(parameter) && parameter.promptFor()) {
            this.promptAndPutAnswersIntoMap(parameter, parameterMap, list);
        }
    }

    private <V> void promptAndPutAnswersIntoMap(Parameter<V> parameter, ParameterMap parameterMap, List<V> list) {
        V v = this.askQuestionRepeatedly(parameter, list);
        if (v != null) {
            parameterMap.put(parameter, v);
        }
    }

    private <V> V askQuestionRepeatedly(Parameter<V> parameter, List<V> list) {
        while (true) {
            try {
                return this.askQuestion(parameter, list);
            }
            catch (NoValidOptionException noValidOptionException) {
                System.err.println(noValidOptionException.getMessage());
                continue;
            }
            catch (CommandLineParser.InvalidParameterException invalidParameterException) {
                System.err.println(invalidParameterException.getMessage());
                continue;
            }
            break;
        }
    }

    private <V> V askQuestion(Parameter<V> parameter, List<V> list) throws CommandLineParser.InvalidParameterException, NoValidOptionException {
        V v;
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.fHandler.getResourcePrompt(parameter));
        V v2 = null;
        if (list != null && !list.isEmpty()) {
            stringBuilder.append(": ");
            object = list.iterator();
            while (object.hasNext()) {
                v = object.next();
                if (v2 == null) {
                    v2 = v;
                }
                stringBuilder.append(v);
                if (!object.hasNext()) continue;
                stringBuilder.append(", ");
            }
        } else {
            v2 = parameter.getSuggestedValue();
        }
        if (v2 != null) {
            stringBuilder.append(" [");
            stringBuilder.append(v2);
            stringBuilder.append("]");
        }
        stringBuilder.append("? ");
        if (Password.class.isAssignableFrom(parameter.getValueClass())) {
            Logger.LOGGER.finest("Parsing a password for " + parameter);
            object = UserPrompt.readPassword(stringBuilder.toString());
            if (((Object)object).length == 0) {
                return null;
            }
            return parameter.getValueClass().cast(new Password(new String((char[])object).getBytes()));
        }
        Logger.LOGGER.finest("Parsing a string for " + parameter);
        object = UserPrompt.readLine(stringBuilder.toString());
        if (((String)object).length() == 0) {
            return v2;
        }
        v = CommandLineParser.parseValue(parameter, (String)object, this.fHandler);
        if (list != null && !list.isEmpty() && !list.contains(v)) {
            throw new NoValidOptionException(v, list);
        }
        return v;
    }

    private static String readLine(String string) {
        System.out.print(string);
        Scanner scanner = new Scanner(System.in);
        return scanner.nextLine();
    }

    private static char[] readPassword(String string) {
        Console console = System.console();
        if (console == null) {
            throw new PasswordReadException("System console not available.");
        }
        char[] cArray = console.readPassword(string, new Object[0]);
        if (cArray == null) {
            throw new CommandLineCanceledException("password char[] is null. Suspect Control-C on Windows.");
        }
        return cArray;
    }

    public static final class PasswordReadException
    extends InternalStateException {
        private PasswordReadException(String string) {
            super(string);
        }
    }

    private static final class NoValidOptionException
    extends I18nRemoteExecutionException {
        private final Object fAnswer;
        private final List<?> fOptions;

        private NoValidOptionException(Object object, List<?> list) {
            super(CommandCreationErrorCode.UserPromptNoValidOption, RemoteExecutionException.ErrorCode.STARTOP);
            this.fAnswer = object;
            this.fOptions = list;
        }

        @Override
        protected Object[] getMessageArguments() {
            return new Object[]{this.fAnswer, this.fOptions};
        }
    }

    public static final class IllegalValueException
    extends InternalStateException {
        private IllegalValueException(String string, Throwable throwable) {
            super("The value " + string + " is not allowed here and caused " + "an exception.", throwable);
        }
    }
}

