/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.remote;

import com.mathworks.toolbox.distcomp.remote.Credential;
import com.mathworks.toolbox.distcomp.remote.CredentialDescription;
import com.mathworks.toolbox.distcomp.remote.IdentityFileCredential;
import com.mathworks.toolbox.distcomp.remote.InvalidValueException;
import com.mathworks.toolbox.distcomp.remote.Parameter;
import com.mathworks.toolbox.distcomp.remote.ParameterInCredential;
import com.mathworks.toolbox.distcomp.remote.ParameterMap;
import com.mathworks.toolbox.distcomp.remote.ParameterSet;
import com.mathworks.toolbox.distcomp.remote.Password;
import java.io.File;

public final class IdentityFileCredentialDescription
implements CredentialDescription {
    public static final IdentityFileCredentialDescription INSTANCE = new IdentityFileCredentialDescription();
    public static final ParameterInCredential<String> USERNAME = new ParameterInCredential<String>((Parameter.PersistentKey)PersistentKey.USERNAME, false, true, String.class, System.getProperty("user.name")){

        @Override
        public void checkValueImpl(String string) throws InvalidValueException {
            if (string == null) {
                throw new InvalidValueException(this, "The username should not be null.");
            }
            if (string.isEmpty()) {
                throw new InvalidValueException(this, "The username should not be empty.");
            }
        }
    };
    public static final ParameterInCredential<File> IDENTITY_FILE = new ParameterInCredential<File>((Parameter.PersistentKey)PersistentKey.IDENTITY_FILE, true, false, File.class){

        @Override
        public void checkValueImpl(File file) throws InvalidValueException {
            if (file == null) {
                throw new InvalidValueException(this, "The identity file should not be null.");
            }
            if (!file.exists()) {
                throw new InvalidValueException(this, file, "The identity file does not exist.");
            }
            if (!file.isFile()) {
                throw new InvalidValueException(this, file, "The identity file is not a file.");
            }
        }
    };
    public static final ParameterInCredential<Password> PASSPHRASE = new ParameterInCredential<Password>((Parameter.PersistentKey)PersistentKey.PASSPHRASE, false, true, Password.class){

        @Override
        public void checkValueImpl(Password password) throws InvalidValueException {
            if (password == null) {
                throw new InvalidValueException(this, "The passphrase should not be null.");
            }
            if (password.getPassword().length == 0) {
                throw new InvalidValueException(this, "The passphrase should not be empty.");
            }
        }
    };
    private static final ParameterSet PARAMETERS = new ParameterSet(USERNAME, IDENTITY_FILE, PASSPHRASE);

    private IdentityFileCredentialDescription() {
    }

    @Override
    public ParameterSet getParameterSet() {
        return PARAMETERS;
    }

    @Override
    public Credential create(ParameterMap parameterMap) {
        return new IdentityFileCredential(parameterMap);
    }

    private static enum PersistentKey implements Parameter.PersistentKey
    {
        USERNAME,
        IDENTITY_FILE,
        PASSPHRASE;

    }
}

