/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.peermessaging;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public final class ProtocolId
extends Enum<ProtocolId> {
    public static final /* enum */ ProtocolId TEST = new ProtocolId(4079, "test");
    public static final /* enum */ ProtocolId MJS = new ProtocolId(4091, "mjs");
    public static final /* enum */ ProtocolId WINSC = new ProtocolId(4093, "winsc");
    public static final /* enum */ ProtocolId MATLABPOOL = new ProtocolId(4111, "matlabpool");
    private final int fIdNumber;
    private final String fName;
    private static final Map<Integer, ProtocolId> IDS_TO_PROTOCOL_IDS;
    private static final /* synthetic */ ProtocolId[] $VALUES;

    public static ProtocolId[] values() {
        return (ProtocolId[])$VALUES.clone();
    }

    public static ProtocolId valueOf(String string) {
        return Enum.valueOf(ProtocolId.class, string);
    }

    private ProtocolId(int n2, String string2) {
        this.fIdNumber = n2;
        this.fName = string2;
    }

    public int getIdNumber() {
        return this.fIdNumber;
    }

    public String getName() {
        return this.fName;
    }

    private static Map<Integer, ProtocolId> createProtocolIDToNameMap() {
        EnumSet<ProtocolId> enumSet = EnumSet.allOf(ProtocolId.class);
        HashMap<Integer, ProtocolId> hashMap = new HashMap<Integer, ProtocolId>(enumSet.size());
        for (ProtocolId protocolId : enumSet) {
            hashMap.put(protocolId.fIdNumber, protocolId);
        }
        return Collections.unmodifiableMap(hashMap);
    }

    public static ProtocolId getProtocolIdForNumber(int n) {
        assert (ProtocolId.isKnownProtocol(n)) : "No protocol exists for " + n;
        return IDS_TO_PROTOCOL_IDS.get(n);
    }

    public static boolean isKnownProtocol(int n) {
        return IDS_TO_PROTOCOL_IDS.containsKey(n);
    }

    static {
        $VALUES = new ProtocolId[]{TEST, MJS, WINSC, MATLABPOOL};
        IDS_TO_PROTOCOL_IDS = ProtocolId.createProtocolIDToNameMap();
    }

    private static final class ForwardReferences {
        public static final int TEST_ID = 4079;
        public static final String TEST_NAME = "test";
        public static final int MJS_ID = 4091;
        public static final String MJS_NAME = "mjs";
        public static final int WINSC_ID = 4093;
        public static final String WINSC_NAME = "winsc";
        public static final int MATLABPOOL_ID = 4111;
        public static final String MATLABPOOL_NAME = "matlabpool";

        private ForwardReferences() {
        }
    }
}

