/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.peermessaging;

import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.pmode.io.IoConstants;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerInstance;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerMessagingException;
import com.mathworks.toolbox.distcomp.pmode.shared.Connection;
import com.mathworks.toolbox.distcomp.pmode.shared.ConnectionFactory;
import com.mathworks.toolbox.distcomp.pmode.shared.HandShake;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.ServerSocketConnectInfo;
import com.mathworks.toolbox.distcomp.util.i18n.BundleKey;
import com.mathworks.toolbox.distcomp.util.i18n.HasI18nMatlabErrorId;
import com.mathworks.toolbox.distcomp.util.i18n.MessageGenerator;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.nio.channels.UnresolvedAddressException;

public final class PeerConnector {
    public PeerConnector() {
        PackageInfo.LOGGER.log(DistcompLevel.THREE, "PeerConnector constructed.");
    }

    private SocketChannel attemptToCreateSocketChannel(InetSocketAddress inetSocketAddress, Instance instance) throws IOException {
        SocketChannel socketChannel = SocketChannel.open();
        try {
            int[] nArray = IoConstants.sSOCKET_PERFORMANCE_PREFS;
            PackageInfo.LOGGER.log(DistcompLevel.SIX, instance.toString() + " " + socketChannel + " about to be configured.");
            socketChannel.socket().setPerformancePreferences(nArray[0], nArray[1], nArray[2]);
            socketChannel.socket().setTcpNoDelay(false);
            socketChannel.configureBlocking(true);
            PackageInfo.LOGGER.log(DistcompLevel.SIX, instance.toString() + " " + socketChannel + " configured.");
        }
        catch (IOException iOException) {
            PackageInfo.LOGGER.log(DistcompLevel.TWO, "Failed to configure SocketChannel " + socketChannel + " for " + inetSocketAddress, iOException);
            this.safeCloseSocketChannel(socketChannel);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            PackageInfo.LOGGER.log(DistcompLevel.TWO, "Failed to configure SocketChannel " + socketChannel + " for " + inetSocketAddress, runtimeException);
            this.safeCloseSocketChannel(socketChannel);
            throw runtimeException;
        }
        try {
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Trying to connect() : " + inetSocketAddress);
            socketChannel.socket().connect(inetSocketAddress, 10000);
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Did connect() : " + inetSocketAddress + " : " + socketChannel);
            return socketChannel;
        }
        catch (IOException iOException) {
            PackageInfo.LOGGER.log(DistcompLevel.TWO, "Failed to connect() : " + inetSocketAddress, iOException);
            this.safeCloseSocketChannel(socketChannel);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            PackageInfo.LOGGER.log(DistcompLevel.TWO, "Failed to connect() : " + inetSocketAddress, runtimeException);
            this.safeCloseSocketChannel(socketChannel);
            throw runtimeException;
        }
    }

    private InetSocketAddress resolveLocally(InetSocketAddress inetSocketAddress) {
        return new InetSocketAddress(inetSocketAddress.getHostName(), inetSocketAddress.getPort());
    }

    private SocketChannel resolveLocallyAndAttemptToCreateSocketChannel(InetSocketAddress inetSocketAddress, Instance instance) throws IOException {
        InetSocketAddress inetSocketAddress2 = this.resolveLocally(inetSocketAddress);
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Resolved " + inetSocketAddress2 + " locally. Attempting to connect.");
        return this.attemptToCreateSocketChannel(inetSocketAddress2, instance);
    }

    private SocketChannel createSocketChannel(ServerSocketConnectInfo serverSocketConnectInfo, Instance instance) throws IOException {
        InetSocketAddress inetSocketAddress = serverSocketConnectInfo.getSocketAddress();
        try {
            return this.attemptToCreateSocketChannel(inetSocketAddress, instance);
        }
        catch (IOException iOException) {
            if (iOException instanceof SocketException || iOException instanceof UnknownHostException || iOException instanceof SocketTimeoutException) {
                return this.resolveLocallyAndAttemptToCreateSocketChannel(inetSocketAddress, instance);
            }
            throw iOException;
        }
        catch (UnresolvedAddressException unresolvedAddressException) {
            return this.resolveLocallyAndAttemptToCreateSocketChannel(inetSocketAddress, instance);
        }
    }

    private Connection connectAndConfigureConnection(ServerSocketConnectInfo serverSocketConnectInfo, Instance instance) throws HandShake.HandShakeException, ConnectRefusedRemotelyException, CouldNotConnectIOException, CouldNotConnectUnknownHostException {
        SocketChannel socketChannel;
        try {
            socketChannel = this.createSocketChannel(serverSocketConnectInfo, instance);
        }
        catch (ConnectException connectException) {
            throw new ConnectRefusedRemotelyException(serverSocketConnectInfo, instance, connectException);
        }
        catch (UnknownHostException unknownHostException) {
            throw new CouldNotConnectUnknownHostException(serverSocketConnectInfo, instance, unknownHostException);
        }
        catch (IOException iOException) {
            throw new CouldNotConnectIOException(serverSocketConnectInfo, instance, iOException);
        }
        try {
            ConnectionFactory connectionFactory = serverSocketConnectInfo.getConnectorSecurityDescription().createConnectionFactoryForConnector();
            PackageInfo.LOGGER.log(DistcompLevel.SIX, "activelyConnectTo(" + serverSocketConnectInfo + ") connectionFactory is  " + connectionFactory);
            return connectionFactory.createConnection(socketChannel, instance, serverSocketConnectInfo, true);
        }
        catch (HandShake.HandShakeException handShakeException) {
            PackageInfo.LOGGER.log(DistcompLevel.TWO, "Failed hand shake with " + socketChannel, handShakeException);
            this.safeCloseSocketChannel(socketChannel);
            throw handShakeException;
        }
    }

    private void safeCloseSocketChannel(SocketChannel socketChannel) {
        try {
            socketChannel.close();
        }
        catch (IOException iOException) {
            PackageInfo.LOGGER.log(DistcompLevel.TWO, "Failed to close " + socketChannel, iOException);
        }
    }

    public Connection activelyConnectTo(ServerSocketConnectInfo serverSocketConnectInfo, Instance instance) throws CouldNotConnectException, HandShake.HandShakeException {
        PeerMessagingException peerMessagingException = null;
        int n = 0;
        while (n++ < 5) {
            PackageInfo.LOGGER.log(DistcompLevel.SIX, "activelyConnectTo(" + serverSocketConnectInfo + ") attempt " + n);
            try {
                return this.connectAndConfigureConnection(serverSocketConnectInfo, instance);
            }
            catch (HandShake.HandShakeException handShakeException) {
                if (peerMessagingException == null) {
                    peerMessagingException = handShakeException;
                }
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "activelyConnectTo(" + serverSocketConnectInfo + ") caught exception during attempt " + n, handShakeException);
            }
            catch (ConnectRefusedRemotelyException connectRefusedRemotelyException) {
                if (peerMessagingException == null) {
                    peerMessagingException = connectRefusedRemotelyException;
                }
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "activelyConnectTo(" + serverSocketConnectInfo + ") caught exception during attempt " + n, connectRefusedRemotelyException);
            }
        }
        PackageInfo.LOGGER.log(DistcompLevel.TWO, "Failed to connect to " + serverSocketConnectInfo + " after " + 5 + " attempts.");
        if (peerMessagingException instanceof HandShake.HandShakeException) {
            throw peerMessagingException;
        }
        if (peerMessagingException instanceof ConnectRefusedRemotelyException) {
            throw (ConnectRefusedRemotelyException)peerMessagingException;
        }
        throw new IllegalStateException("firstException is " + peerMessagingException + " but code should never reach this point without setting firstException to a valid value.");
    }

    public Connection activelyConnectTo(ServerSocketConnectInfo serverSocketConnectInfo, long l, long l2, PeerInstance peerInstance) throws HandShake.HandShakeException, ConnectRefusedRemotelyException, ConnectAttemptsInterruptedException, CouldNotConnectIOException, CouldNotConnectUnknownHostException {
        long l3;
        assert (l > 0L) : "poll interval must be greater than 0 but is " + l;
        assert (l2 > 0L) : "timeout must be greater than 0 but is " + l2;
        assert (l <= l2) : "poll interval " + l + " is greater than timeout " + l2 + ". It'll still try twice.";
        PackageInfo.LOGGER.log(DistcompLevel.SIX, "Starting to poll on accept every " + l + " ms for " + l2 + " ms");
        long l4 = System.currentTimeMillis();
        PeerMessagingException peerMessagingException = null;
        do {
            try {
                return this.connectAndConfigureConnection(serverSocketConnectInfo, peerInstance);
            }
            catch (HandShake.HandShakeException handShakeException) {
                if (peerMessagingException == null) {
                    peerMessagingException = handShakeException;
                }
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "activelyConnectTo(" + serverSocketConnectInfo + ") caught exception", handShakeException);
            }
            catch (ConnectRefusedRemotelyException connectRefusedRemotelyException) {
                if (peerMessagingException == null) {
                    peerMessagingException = connectRefusedRemotelyException;
                }
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "activelyConnectTo(" + serverSocketConnectInfo + ") caught exception", connectRefusedRemotelyException);
            }
            try {
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new ConnectAttemptsInterruptedException(serverSocketConnectInfo, peerInstance, interruptedException);
            }
        } while (l2 > (l3 = System.currentTimeMillis()) - l4);
        try {
            return this.connectAndConfigureConnection(serverSocketConnectInfo, peerInstance);
        }
        catch (HandShake.HandShakeException handShakeException) {
            if (peerMessagingException == null) {
                peerMessagingException = handShakeException;
            }
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "activelyConnectTo(" + serverSocketConnectInfo + ") caught exception during last attempt", handShakeException);
        }
        catch (ConnectRefusedRemotelyException connectRefusedRemotelyException) {
            if (peerMessagingException == null) {
                peerMessagingException = connectRefusedRemotelyException;
            }
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "activelyConnectTo(" + serverSocketConnectInfo + ") caught exception during last attempt", connectRefusedRemotelyException);
        }
        PackageInfo.LOGGER.log(DistcompLevel.TWO, "Failed to connect to " + serverSocketConnectInfo + " after " + l2 + " ms");
        if (peerMessagingException instanceof HandShake.HandShakeException) {
            throw peerMessagingException;
        }
        if (peerMessagingException instanceof ConnectRefusedRemotelyException) {
            throw (ConnectRefusedRemotelyException)peerMessagingException;
        }
        throw new IllegalStateException("firstException is " + peerMessagingException + " but code should never reach this point without setting firstException to a valid value.");
    }

    public static enum PeerConnectorErrorCode implements HasI18nMatlabErrorId
    {
        ConnectRefusedRemotelyException,
        ConnectAttemptsInterruptedException,
        CouldNotConnectUnknownHostException,
        CouldNotConnectIOException;

        private static final String RESOURCE_BASE_NAME = "com.mathworks.toolbox.distcomp.pmode.peermessaging.resources.RES_peermessaging";
        private static final String RESOURCE_BUNDLE_KEY_PREFIX = "parallel.peermessaging.";
        private static final String MATLAB_ERROR_ID_PREFIX = "parallel:peermessaging:";

        @Override
        public String getMatlabErrorId() {
            return MATLAB_ERROR_ID_PREFIX + this.toString();
        }

        @Override
        public String getResourceBundleName() {
            return RESOURCE_BASE_NAME;
        }

        @Override
        public String getBundleKey() {
            return RESOURCE_BUNDLE_KEY_PREFIX + this.toString();
        }

        @Override
        public String createMessage(Object ... objectArray) {
            return MessageGenerator.createMessage((BundleKey)this, true, objectArray);
        }

        @Override
        public String createLocalizedMessage(Object ... objectArray) {
            return MessageGenerator.createLocalizedMessage(this, true, objectArray);
        }
    }

    public static final class CouldNotConnectIOException
    extends CouldNotConnectException {
        private CouldNotConnectIOException(ServerSocketConnectInfo serverSocketConnectInfo, Instance instance, IOException iOException) {
            super(PeerConnectorErrorCode.CouldNotConnectIOException, serverSocketConnectInfo, instance, iOException);
        }

        @Override
        protected Object[] getMessageArguments() {
            return new Object[]{this.getConnectInfo().getSocketAddress(), this.getLocalPeerInstance(), this.getCause().getLocalizedMessage()};
        }
    }

    public static final class CouldNotConnectUnknownHostException
    extends CouldNotConnectException {
        private CouldNotConnectUnknownHostException(ServerSocketConnectInfo serverSocketConnectInfo, Instance instance, IOException iOException) {
            super(PeerConnectorErrorCode.CouldNotConnectUnknownHostException, serverSocketConnectInfo, instance, iOException);
        }

        @Override
        protected Object[] getMessageArguments() {
            return new Object[]{this.getConnectInfo().getSocketAddress(), this.getLocalPeerInstance(), this.getCause().getLocalizedMessage()};
        }
    }

    public static final class ConnectAttemptsInterruptedException
    extends CouldNotConnectException {
        private ConnectAttemptsInterruptedException(ServerSocketConnectInfo serverSocketConnectInfo, Instance instance, InterruptedException interruptedException) {
            super(PeerConnectorErrorCode.ConnectAttemptsInterruptedException, serverSocketConnectInfo, instance, interruptedException);
        }

        @Override
        protected Object[] getMessageArguments() {
            return new Object[]{this.getConnectInfo().getSocketAddress(), this.getLocalPeerInstance(), this.getCause().getLocalizedMessage()};
        }
    }

    public static final class ConnectRefusedRemotelyException
    extends CouldNotConnectException {
        private ConnectRefusedRemotelyException(ServerSocketConnectInfo serverSocketConnectInfo, Instance instance, ConnectException connectException) {
            super(PeerConnectorErrorCode.ConnectRefusedRemotelyException, serverSocketConnectInfo, instance, connectException);
        }

        @Override
        protected Object[] getMessageArguments() {
            return new Object[]{this.getConnectInfo().getSocketAddress(), this.getLocalPeerInstance(), this.getCause().getLocalizedMessage()};
        }
    }

    public static abstract class CouldNotConnectException
    extends PeerMessagingException {
        private final ServerSocketConnectInfo fConnectInfo;
        private final Instance fLocalPeerInstance;

        CouldNotConnectException(PeerConnectorErrorCode peerConnectorErrorCode, ServerSocketConnectInfo serverSocketConnectInfo, Instance instance, Exception exception) {
            super(peerConnectorErrorCode, exception);
            this.fConnectInfo = serverSocketConnectInfo;
            this.fLocalPeerInstance = instance;
        }

        public ServerSocketConnectInfo getConnectInfo() {
            return this.fConnectInfo;
        }

        public Instance getLocalPeerInstance() {
            return this.fLocalPeerInstance;
        }
    }
}

