/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.io.broker;

import com.mathworks.toolbox.distcomp.pmode.io.broker.BrokerConnectInfoDispatcher;
import com.mathworks.toolbox.distcomp.pmode.io.broker.Log;
import com.mathworks.toolbox.distcomp.pmode.shared.ErrorHandler;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.ShutdownHandler;
import java.io.EOFException;
import java.util.logging.Level;

public final class BrokerConnectInfoErrorHandler
implements ErrorHandler {
    private static final String LOG_PREFIX = "NonFatalErrorHandler: ";
    private final BrokerConnectInfoDispatcher fBrokerConnectInfoDispatcher;

    public BrokerConnectInfoErrorHandler(BrokerConnectInfoDispatcher brokerConnectInfoDispatcher) {
        this.fBrokerConnectInfoDispatcher = brokerConnectInfoDispatcher;
    }

    @Override
    public void readError(Instance instance, Throwable throwable) {
        this.fBrokerConnectInfoDispatcher.removeInstance(instance);
        Log.LOGGER.log(Level.FINER, "NonFatalErrorHandler: readError from " + instance, throwable);
    }

    @Override
    public void writeError(Instance instance, Throwable throwable) {
        this.fBrokerConnectInfoDispatcher.removeInstance(instance);
        Log.LOGGER.log(Level.FINER, "NonFatalErrorHandler: writeError to " + instance, throwable);
    }

    @Override
    public void lostCommunication(Instance instance, Throwable throwable) {
        this.fBrokerConnectInfoDispatcher.removeInstance(instance);
        if (throwable instanceof EOFException) {
            Log.LOGGER.log(Level.FINER, "NonFatalErrorHandler: lostCommunication to " + instance + " due to EOF");
        } else {
            Log.LOGGER.log(Level.FINER, "NonFatalErrorHandler: lostCommunication to " + instance, throwable);
        }
    }

    @Override
    public void executorError(Throwable throwable) {
        Log.LOGGER.log(Level.FINER, "NonFatalErrorHandler: executorError.", throwable);
    }

    @Override
    public void activate(ShutdownHandler shutdownHandler) {
    }

    @Override
    public void deactivate() {
    }
}

