/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.io;

import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.pmode.io.MatlabPoolConnector;
import com.mathworks.toolbox.distcomp.pmode.io.MatlabPoolPeerInstance;
import com.mathworks.toolbox.distcomp.pmode.io.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerConnector;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerMessagingException;
import com.mathworks.toolbox.distcomp.pmode.shared.ConnectInfo;
import com.mathworks.toolbox.distcomp.pmode.shared.Connection;
import com.mathworks.toolbox.distcomp.pmode.shared.ConnectorPlainSecurityDescription;
import com.mathworks.toolbox.distcomp.pmode.shared.ProcessInstance;
import com.mathworks.toolbox.distcomp.pmode.shared.ServerSocketConnectInfo;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;

final class MatlabPoolSocketConnector
extends MatlabPoolConnector {
    private final PeerConnector fPeerConnector;
    private MatlabPoolPeerInstance fLocalPeer;
    private Map<ProcessInstance, ConnectInfo> fProcessInstancesToConnectInfos;

    MatlabPoolSocketConnector(MatlabPoolPeerInstance matlabPoolPeerInstance) throws PeerMessagingException {
        this.fLocalPeer = matlabPoolPeerInstance;
        this.fPeerConnector = new PeerConnector();
        this.fProcessInstancesToConnectInfos = new HashMap<ProcessInstance, ConnectInfo>();
        PackageInfo.LOGGER.log(DistcompLevel.THREE, "ConnectionManager (" + matlabPoolPeerInstance + ") constructed.");
    }

    @Override
    ProcessInstance registerClientConnectInfo(ConnectInfo connectInfo) {
        ProcessInstance processInstance = ProcessInstance.getClientInstance();
        String string = System.getenv("MDCE_OVERRIDE_CLIENT_HOST");
        if (string != null && string.length() > 0 && connectInfo instanceof ServerSocketConnectInfo && ((ServerSocketConnectInfo)connectInfo).getSocketAddress() instanceof InetSocketAddress) {
            ServerSocketConnectInfo serverSocketConnectInfo = (ServerSocketConnectInfo)connectInfo;
            InetSocketAddress inetSocketAddress = serverSocketConnectInfo.getSocketAddress();
            PackageInfo.LOGGER.log(DistcompLevel.THREE, "Using overriding client hostname: " + string + " to override " + inetSocketAddress);
            InetSocketAddress inetSocketAddress2 = new InetSocketAddress(string, inetSocketAddress.getPort());
            ConnectorPlainSecurityDescription connectorPlainSecurityDescription = new ConnectorPlainSecurityDescription();
            ServerSocketConnectInfo serverSocketConnectInfo2 = new ServerSocketConnectInfo(inetSocketAddress2, connectInfo.getGroupUUID(), connectorPlainSecurityDescription, connectInfo.getHandShakeTimeout());
            this.fProcessInstancesToConnectInfos.put(processInstance, serverSocketConnectInfo2);
        } else {
            this.fProcessInstancesToConnectInfos.put(processInstance, connectInfo);
        }
        return processInstance;
    }

    @Override
    Connection activelyConnectTo(ProcessInstance processInstance) throws PeerMessagingException {
        if (!this.fProcessInstancesToConnectInfos.containsKey(processInstance)) {
            assert (false) : "No address for: " + processInstance;
            return null;
        }
        ConnectInfo connectInfo = this.fProcessInstancesToConnectInfos.get(processInstance);
        if (connectInfo instanceof ServerSocketConnectInfo) {
            ServerSocketConnectInfo serverSocketConnectInfo = (ServerSocketConnectInfo)connectInfo;
            Connection connection = this.fPeerConnector.activelyConnectTo(serverSocketConnectInfo, this.fLocalPeer);
            connection.switchToMatlabPoolProcessInstance();
            return connection;
        }
        throw new IllegalArgumentException("Does not understand how to connect using a " + connectInfo.getClass());
    }

    @Override
    void close() {
    }

    public String toString() {
        return "MatlabPoolSocketConnector{, fPeerConnector=" + this.fPeerConnector + ", fLocalPeer=" + this.fLocalPeer + ", fProcessInstancesToConnectInfos.size()=" + this.fProcessInstancesToConnectInfos.size() + '}';
    }
}

