/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.io;

import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.pmode.io.ConnectionManager;
import com.mathworks.toolbox.distcomp.pmode.io.MatlabPoolAcceptor;
import com.mathworks.toolbox.distcomp.pmode.io.MatlabPoolPeerInstance;
import com.mathworks.toolbox.distcomp.pmode.io.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerActiveAcceptor;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerMessagingException;
import com.mathworks.toolbox.distcomp.pmode.shared.ConnectInfo;
import com.mathworks.toolbox.distcomp.pmode.shared.Connection;
import com.mathworks.toolbox.distcomp.pmode.shared.ServerSocketAcceptInfo;

final class MatlabPoolServerSocketAcceptor
extends MatlabPoolAcceptor {
    private final PeerActiveAcceptor fPeerAcceptor;
    private MatlabPoolPeerInstance fLocalPeer;

    MatlabPoolServerSocketAcceptor(String string, MatlabPoolPeerInstance matlabPoolPeerInstance, ServerSocketAcceptInfo serverSocketAcceptInfo) throws PeerMessagingException {
        this.fLocalPeer = matlabPoolPeerInstance;
        this.fPeerAcceptor = new PeerActiveAcceptor(string, matlabPoolPeerInstance, serverSocketAcceptInfo);
        PackageInfo.LOGGER.log(DistcompLevel.THREE, "MatlabPoolServerSocketAcceptor (" + matlabPoolPeerInstance + ") constructed.");
    }

    @Override
    ConnectInfo getInfoToConnect() {
        return this.fPeerAcceptor.getInfoToConnect();
    }

    @Override
    ConnectionManager.ConnectionAndNumberOfLabs activelyAccept() {
        Connection connection = this.fPeerAcceptor.activelyAccept();
        if (connection != null) {
            int n = ((MatlabPoolPeerInstance)connection.getRemoteInstance()).getNumberOfLabs();
            connection.switchToMatlabPoolProcessInstance();
            return new ConnectionManager.ConnectionAndNumberOfLabs(connection, n);
        }
        return null;
    }

    @Override
    void close() {
        this.fPeerAcceptor.close();
    }

    public String toString() {
        return "MatlabPoolServerSocketAcceptor{, fLocalPeer=" + this.fLocalPeer + ", fPeerAcceptor=" + this.fPeerAcceptor + '}';
    }
}

