/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.io;

import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.pmode.io.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.ProtocolId;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.ProcessInstance;
import java.nio.ByteBuffer;
import java.util.UUID;

public final class MatlabPoolPeerInstance
implements Instance {
    private final UUID fUuid;
    private final UUID fGroupUuid;
    private final ProcessInstance fAliasedProcessInstance;
    private final int fNumberOfLabs;
    private static final int BYTE_LENGTH_OF_UUID = 16;
    private static final int BYTE_LENGTH_OF_INT = 4;

    public MatlabPoolPeerInstance(UUID uUID, UUID uUID2, ProcessInstance processInstance, int n) {
        this.fUuid = uUID2;
        this.fGroupUuid = uUID;
        this.fAliasedProcessInstance = processInstance;
        this.fNumberOfLabs = n;
    }

    @Override
    public UUID getUuid() {
        return this.fUuid;
    }

    @Override
    public UUID getGroupUuid() {
        return this.fGroupUuid;
    }

    public ProcessInstance getAliasedProcessInstance() {
        return this.fAliasedProcessInstance;
    }

    public int getNumberOfLabs() {
        return this.fNumberOfLabs;
    }

    public int getLabIndex() {
        return ProcessInstance.ProcessType.LAB.equals((Object)this.fAliasedProcessInstance.getProcessType()) ? this.fAliasedProcessInstance.getLabIndex() : -1;
    }

    @Override
    public ProtocolId getProtocolId() {
        return ProtocolId.MATLABPOOL;
    }

    @Override
    public int getByteLengthOfInstanceBootstrap() {
        return 40;
    }

    @Override
    public void encodeInstanceBootstrap(ByteBuffer byteBuffer) {
        byteBuffer.putLong(this.getGroupUuid().getMostSignificantBits());
        byteBuffer.putLong(this.getGroupUuid().getLeastSignificantBits());
        byteBuffer.putLong(this.getUuid().getMostSignificantBits());
        byteBuffer.putLong(this.getUuid().getLeastSignificantBits());
        byteBuffer.putInt(this.getLabIndex());
        byteBuffer.putInt(this.getNumberOfLabs());
        PackageInfo.LOGGER.log(DistcompLevel.SIX, "Encoded " + this);
    }

    @Override
    public MatlabPoolPeerInstance decodeRemoteInstanceBootstrap(ByteBuffer byteBuffer) {
        long l = byteBuffer.getLong();
        long l2 = byteBuffer.getLong();
        long l3 = byteBuffer.getLong();
        long l4 = byteBuffer.getLong();
        int n = byteBuffer.getInt();
        int n2 = byteBuffer.getInt();
        UUID uUID = new UUID(l, l2);
        UUID uUID2 = new UUID(l3, l4);
        MatlabPoolPeerInstance matlabPoolPeerInstance = this.decode(uUID, uUID2, n, n2);
        PackageInfo.LOGGER.log(DistcompLevel.SIX, "Decoded " + matlabPoolPeerInstance);
        return matlabPoolPeerInstance;
    }

    private MatlabPoolPeerInstance decode(UUID uUID, UUID uUID2, int n, int n2) {
        ProcessInstance processInstance = n == -1 ? ProcessInstance.getClientInstance() : ProcessInstance.getLabInstance(n);
        return new MatlabPoolPeerInstance(uUID, uUID2, processInstance, n2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MatlabPoolPeerInstance matlabPoolPeerInstance = (MatlabPoolPeerInstance)object;
        if (this.fNumberOfLabs != matlabPoolPeerInstance.fNumberOfLabs) {
            return false;
        }
        if (this.fAliasedProcessInstance != null ? !this.fAliasedProcessInstance.equals(matlabPoolPeerInstance.fAliasedProcessInstance) : matlabPoolPeerInstance.fAliasedProcessInstance != null) {
            return false;
        }
        if (this.fGroupUuid != null ? !this.fGroupUuid.equals(matlabPoolPeerInstance.fGroupUuid) : matlabPoolPeerInstance.fGroupUuid != null) {
            return false;
        }
        return !(this.fUuid != null ? !this.fUuid.equals(matlabPoolPeerInstance.fUuid) : matlabPoolPeerInstance.fUuid != null);
    }

    public int hashCode() {
        int n = this.fUuid != null ? this.fUuid.hashCode() : 0;
        n = 31 * n + (this.fGroupUuid != null ? this.fGroupUuid.hashCode() : 0);
        n = 31 * n + (this.fAliasedProcessInstance != null ? this.fAliasedProcessInstance.hashCode() : 0);
        n = 31 * n + this.fNumberOfLabs;
        return n;
    }

    public String toString() {
        return "MatlabPoolPeerInstance{fUuid=" + this.fUuid + ", fGroupUuid=" + this.fGroupUuid + ", fAliasedProcessInstance=" + this.fAliasedProcessInstance + ", fNumberOfLabs=" + this.fNumberOfLabs + '}';
    }
}

