/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.io;

import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.pmode.io.BufferType;
import com.mathworks.toolbox.distcomp.pmode.io.HeaderPayload;
import com.mathworks.toolbox.distcomp.pmode.io.PackageInfo;
import com.mathworks.toolbox.distcomp.util.ByteBufferHandle;

final class DefaultHeaderPayload
implements HeaderPayload {
    private ByteBufferHandle fHeaderBuf;
    private ByteBufferHandle[] fPayloadBufs;
    private ByteBufferHandle[] fAllBufs;
    private boolean fGotAllBufs;

    DefaultHeaderPayload(ByteBufferHandle byteBufferHandle, ByteBufferHandle[] byteBufferHandleArray) {
        this.fHeaderBuf = byteBufferHandle;
        this.fPayloadBufs = byteBufferHandleArray;
        this.iBuildAllBufs();
    }

    DefaultHeaderPayload(ByteBufferHandle byteBufferHandle) {
        this(byteBufferHandle, new ByteBufferHandle[0]);
        this.fAllBufs = null;
        this.fGotAllBufs = false;
    }

    @Override
    public ByteBufferHandle getHeaderMessage() {
        return this.fHeaderBuf;
    }

    @Override
    public boolean isHeaderCompletelyTransmitted() {
        return !this.fHeaderBuf.get().hasRemaining();
    }

    @Override
    public ByteBufferHandle[] getAllMessages() {
        assert (this.fGotAllBufs) : "Must have all buffers available to return them";
        return this.fAllBufs;
    }

    @Override
    public ByteBufferHandle[] getPayloadMessages() {
        return this.fPayloadBufs;
    }

    @Override
    public void setPayloadMessages(ByteBufferHandle[] byteBufferHandleArray) {
        this.fPayloadBufs = byteBufferHandleArray;
        this.iBuildAllBufs();
    }

    private void iBuildAllBufs() {
        this.fAllBufs = new ByteBufferHandle[1 + this.fPayloadBufs.length];
        this.fAllBufs[0] = this.fHeaderBuf;
        int n = 1;
        for (ByteBufferHandle byteBufferHandle : this.fPayloadBufs) {
            this.fAllBufs[n++] = byteBufferHandle;
        }
        this.fGotAllBufs = true;
    }

    @Override
    public boolean isPayloadCompletelyTransmitted() {
        for (ByteBufferHandle byteBufferHandle : this.fPayloadBufs) {
            if (!byteBufferHandle.get().hasRemaining()) continue;
            PackageInfo.LOGGER.log(DistcompLevel.SIX, "Remaining data for " + byteBufferHandle);
            return false;
        }
        return true;
    }

    private int getKBytes(BufferType bufferType) {
        int n = 0;
        boolean bl = bufferType == BufferType.DIRECT;
        n += this.fHeaderBuf.get().isDirect() == bl ? this.fHeaderBuf.get().capacity() : 0;
        for (ByteBufferHandle byteBufferHandle : this.fPayloadBufs) {
            n += byteBufferHandle.get().isDirect() == bl ? byteBufferHandle.get().capacity() : 0;
        }
        return n / 1024;
    }

    @Override
    public int heapKBytes() {
        return this.getKBytes(BufferType.HEAP);
    }

    @Override
    public int directKBytes() {
        return this.getKBytes(BufferType.DIRECT);
    }
}

