/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.io;

import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.pmode.io.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.io.Selectable;
import com.mathworks.toolbox.distcomp.pmode.io.TransmissionChannel;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerMessagingRuntimeException;
import com.mathworks.toolbox.distcomp.pmode.shared.Connection;
import com.mathworks.toolbox.distcomp.pmode.shared.Dispatcher;
import com.mathworks.toolbox.distcomp.pmode.shared.ErrorHandler;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.Message;
import com.mathworks.toolbox.distcomp.pmode.shared.MessageObserver;
import com.mathworks.toolbox.distcomp.pmode.shared.ObservableMessage;
import com.mathworks.toolbox.distcomp.pmode.shared.ObservableMessageRegistry;
import com.mathworks.toolbox.distcomp.pmode.shared.OutputGroup;
import com.mathworks.toolbox.distcomp.pmode.shared.ProcessInstance;
import com.mathworks.toolbox.distcomp.pmode.shared.ReturnGroup;
import com.mathworks.toolbox.distcomp.pmode.shared.ReturnMessage;
import com.mathworks.toolbox.distcomp.util.Executor;
import com.mathworks.toolbox.distcomp.util.concurrent.ReentrantLock;
import java.io.EOFException;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;

public final class CommunicationGroup
implements Runnable,
OutputGroup,
ReturnGroup {
    private final Selector fSelector;
    private final Map<Instance, TransmissionChannel> fTransmissionChannelAddressBook;
    private final ConcurrentUniqueQueue<Runnable> fRunnables = new ConcurrentUniqueQueue();
    private Dispatcher<Message> fDispatch = null;
    private Executor fDispatchExec = null;
    private final AtomicBoolean fKeepGoing;
    private Thread fThread;
    private final ObservableMessageRegistry fReturnRegistry;
    private final ErrorHandler fErrorHandler;
    private final int fInitialNumLabs;
    private final Instance fThisInstance;
    private final Set<Instance> fExpectedInstances = new HashSet<Instance>();

    private CommunicationGroup(ErrorHandler errorHandler, ObservableMessageRegistry observableMessageRegistry, Collection<Connection> collection, Instance instance) {
        PackageInfo.LOGGER.log(DistcompLevel.FIVE, "In CommunicationGroup constructor with " + collection.size() + " Connections.");
        this.fErrorHandler = errorHandler;
        this.fReturnRegistry = observableMessageRegistry;
        this.fInitialNumLabs = collection.size();
        this.fThisInstance = instance;
        this.fKeepGoing = new AtomicBoolean(true);
        this.fTransmissionChannelAddressBook = Collections.synchronizedMap(new HashMap());
        PackageInfo.LOGGER.log(DistcompLevel.SIX, "About to call Selector.open()");
        try {
            this.fSelector = Selector.open();
        }
        catch (IOException iOException) {
            throw new PeerMessagingRuntimeException("Unexpected IOException while opening a selector for " + instance, iOException);
        }
        PackageInfo.LOGGER.log(DistcompLevel.SIX, "Called Selector.open()");
        for (Connection connection : collection) {
            this.addConnection(connection);
        }
        PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Exiting CommunicationGroup constructor.");
    }

    public static CommunicationGroup build(ErrorHandler errorHandler, ObservableMessageRegistry observableMessageRegistry, Collection<Connection> collection, Instance instance) {
        CommunicationGroup communicationGroup = new CommunicationGroup(errorHandler, observableMessageRegistry, collection, instance);
        communicationGroup.startSelectThread();
        return communicationGroup;
    }

    public static CommunicationGroup build(ErrorHandler errorHandler, ObservableMessageRegistry observableMessageRegistry, Connection[] connectionArray, Instance[] instanceArray, Instance instance) throws IOException {
        assert (connectionArray.length == instanceArray.length) : "Must construct with same length arrays";
        List<Connection> list = Arrays.asList(connectionArray);
        CommunicationGroup communicationGroup = new CommunicationGroup(errorHandler, observableMessageRegistry, list, instance);
        communicationGroup.startSelectThread();
        return communicationGroup;
    }

    private void startSelectThread() {
        this.fThread = new Thread((Runnable)this, "CommGroup select thread " + this.toString());
        this.fThread.setDaemon(true);
        this.fThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransmissionChannel[] getAllTransmissionChannels() {
        Map<Instance, TransmissionChannel> map = this.fTransmissionChannelAddressBook;
        synchronized (map) {
            TransmissionChannel[] transmissionChannelArray = new TransmissionChannel[this.fTransmissionChannelAddressBook.values().size()];
            return this.fTransmissionChannelAddressBook.values().toArray(transmissionChannelArray);
        }
    }

    public void setDispatcher(Dispatcher<Message> dispatcher, Executor executor) {
        this.fDispatch = dispatcher;
        this.fDispatchExec = executor;
        PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Attaching dispatcher: " + dispatcher + " to " + this.getAddressBookSize() + " channels");
        for (TransmissionChannel transmissionChannel : this.getAllTransmissionChannels()) {
            transmissionChannel.setDispatcher(dispatcher, executor);
        }
    }

    @Override
    public void sendToAll(Message message) {
        this.assertOnClientProcessInstance();
        PackageInfo.LOGGER.log(DistcompLevel.FIVE, "sendToAll - that's " + this.getAddressBookSize());
        for (TransmissionChannel transmissionChannel : this.getAllTransmissionChannels()) {
            this.sendToChannel(transmissionChannel, message);
        }
    }

    @Override
    public void returnTo(Instance instance, ReturnMessage returnMessage) {
        this.sendTo(instance, returnMessage);
    }

    @Override
    public void returnToAll(ReturnMessage returnMessage) {
        PackageInfo.LOGGER.log(DistcompLevel.FIVE, "returnToAll - that's " + this.getAddressBookSize());
        for (TransmissionChannel transmissionChannel : this.getAllTransmissionChannels()) {
            this.sendToChannel(transmissionChannel, returnMessage);
        }
    }

    @Override
    public void sendToAll(ObservableMessage observableMessage, MessageObserver messageObserver) {
        this.assertOnClientProcessInstance();
        PackageInfo.LOGGER.log(DistcompLevel.FIVE, "sendToAll with observer - that's " + this.getAddressBookSize());
        for (TransmissionChannel transmissionChannel : this.getAllTransmissionChannels()) {
            this.fReturnRegistry.addReturnMessageObserver(observableMessage, transmissionChannel.getRemoteProcess(), messageObserver);
            this.sendToChannel(transmissionChannel, observableMessage);
        }
    }

    @Override
    public void sendTo(Instance instance, ObservableMessage observableMessage, MessageObserver messageObserver) {
        TransmissionChannel transmissionChannel = this.fTransmissionChannelAddressBook.get(instance);
        if (transmissionChannel == null) {
            PackageInfo.LOGGER.log(DistcompLevel.TWO, "Unable to enqueue message: " + observableMessage + " - No channel for " + instance);
            throw new NoSuchDestinationException(observableMessage, instance);
        }
        PackageInfo.LOGGER.log(DistcompLevel.FIVE, "sendTo with observer: " + messageObserver + " of message: " + observableMessage + " to: " + instance);
        this.fReturnRegistry.addReturnMessageObserver(observableMessage, instance, messageObserver);
        this.sendToChannel(transmissionChannel, observableMessage);
    }

    @Override
    public void sendTo(Instance instance, Message message) {
        TransmissionChannel transmissionChannel = this.fTransmissionChannelAddressBook.get(instance);
        if (transmissionChannel == null) {
            PackageInfo.LOGGER.log(DistcompLevel.TWO, "Unable to enqueue message: " + message + " - No channel for " + instance);
            throw new NoSuchDestinationException(message, instance);
        }
        this.sendToChannel(transmissionChannel, message);
    }

    private void sendToChannel(TransmissionChannel transmissionChannel, Message message) {
        try {
            PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Enqueuing a message: " + message + " to: " + transmissionChannel.getRemoteProcess());
            transmissionChannel.enqueueMessageForSending(message);
            this.invokeOnSelectThread(new AddOpWrite(transmissionChannel));
        }
        catch (IOException iOException) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "IOException during sendTo", iOException);
            this.fErrorHandler.writeError(transmissionChannel.getRemoteProcess(), iOException);
        }
        catch (InterruptedException interruptedException) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "InterruptedException during sendTo", interruptedException);
            this.fErrorHandler.writeError(transmissionChannel.getRemoteProcess(), interruptedException);
        }
    }

    @Override
    @Deprecated
    public int getNumDestinations() {
        this.assertOnClientProcessInstance();
        return this.fInitialNumLabs;
    }

    private int getAddressBookSize() {
        return this.fTransmissionChannelAddressBook.size();
    }

    private void assertOnClientProcessInstance() {
        assert (this.fThisInstance instanceof ProcessInstance) : "This method must only be called on a ProcessInstance, not a " + this.fThisInstance.getClass().getSimpleName();
        assert (((ProcessInstance)this.fThisInstance).getProcessType() == ProcessInstance.ProcessType.CLIENT) : "This method must only be called on the CLIENT process";
    }

    @Override
    public void closeStreams() {
        PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Closing channels");
        this.fKeepGoing.set(false);
        this.fSelector.wakeup();
        try {
            this.fThread.join(200L);
            PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Joined select() thread, closing channels. fThread.isAlive() = " + this.fThread.isAlive());
        }
        catch (InterruptedException interruptedException) {
            PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Interruption during join", interruptedException);
        }
        for (TransmissionChannel transmissionChannel : this.getAllTransmissionChannels()) {
            try {
                transmissionChannel.close();
            }
            catch (IOException iOException) {
                PackageInfo.LOGGER.log(DistcompLevel.TWO, "IOException during close: ", iOException);
            }
        }
        PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Clearing TransmissionChannelAddressBook");
        this.fTransmissionChannelAddressBook.clear();
        try {
            this.fSelector.close();
        }
        catch (IOException iOException) {
            PackageInfo.LOGGER.log(DistcompLevel.TWO, "IOException during selector close: ", iOException);
        }
    }

    public void addConnection(final Connection connection) {
        final TransmissionChannel transmissionChannel = new TransmissionChannel(connection, this.fErrorHandler);
        this.fTransmissionChannelAddressBook.put(connection.getRemoteInstance(), transmissionChannel);
        this.invokeOnSelectThread(new Runnable(){

            @Override
            public void run() {
                try {
                    PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Registering " + transmissionChannel + " with selector.");
                    transmissionChannel.registerWithSelector(CommunicationGroup.this.fSelector, 1, transmissionChannel);
                    CommunicationGroup.this.fExpectedInstances.add(connection.getRemoteInstance());
                    if (CommunicationGroup.this.fDispatch != null) {
                        PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Adding dispatcher to " + transmissionChannel);
                        transmissionChannel.setDispatcher(CommunicationGroup.this.fDispatch, CommunicationGroup.this.fDispatchExec);
                    }
                }
                catch (IOException iOException) {
                    PackageInfo.LOGGER.log(DistcompLevel.TWO, "IOException while adding a new connection", iOException);
                }
            }

            public String toString() {
                return "addConnection( " + connection + " )";
            }
        });
    }

    public void removeInstance(final Instance instance) {
        final TransmissionChannel transmissionChannel = this.fTransmissionChannelAddressBook.remove(instance);
        if (transmissionChannel == null) {
            PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Attempted to remove " + instance + " that is not in address book");
        }
        this.invokeOnSelectThread(new Runnable(){

            @Override
            public void run() {
                this.safeCloseTransmissionChannel(transmissionChannel);
                CommunicationGroup.this.fExpectedInstances.remove(instance);
            }

            private void safeCloseTransmissionChannel(TransmissionChannel transmissionChannel2) {
                if (transmissionChannel2 == null) {
                    return;
                }
                try {
                    transmissionChannel2.close();
                }
                catch (IOException iOException) {
                    PackageInfo.LOGGER.log(DistcompLevel.TWO, "IOException closing " + transmissionChannel2, iOException);
                }
            }

            public String toString() {
                return "removeInstance( " + instance + " )";
            }
        });
    }

    private void invokeOnSelectThread(Runnable runnable) {
        ((ConcurrentUniqueQueue)this.fRunnables).add(runnable);
        this.fSelector.wakeup();
    }

    @Override
    public void run() {
        long l = -1L;
        long l2 = 5000L;
        while (true) {
            if (!this.fKeepGoing.get() && l == -1L) {
                PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Shutting down select() thread");
                l = System.currentTimeMillis() + 100L;
                l2 = 50L;
            }
            if (l != -1L && System.currentTimeMillis() > l) {
                PackageInfo.LOGGER.log(DistcompLevel.FIVE, "select() thread returning");
                return;
            }
            this.drainRunnableQueue();
            if (this.doSelect(l2)) {
                return;
            }
            this.detectLostInstances();
        }
    }

    private void drainRunnableQueue() {
        Runnable runnable = (Runnable)((ConcurrentUniqueQueue)this.fRunnables).poll();
        while (runnable != null) {
            try {
                PackageInfo.LOGGER.log(DistcompLevel.SIX, "Running " + runnable + " on select thread");
                runnable.run();
            }
            catch (RuntimeException runtimeException) {
                PackageInfo.LOGGER.log(DistcompLevel.ONE, "Exception thrown by runnable on select thread.", runtimeException);
            }
            runnable = (Runnable)((ConcurrentUniqueQueue)this.fRunnables).poll();
        }
    }

    private boolean doSelect(long l) {
        int n;
        try {
            n = this.fSelector.select(l);
        }
        catch (CancelledKeyException cancelledKeyException) {
            CommunicationGroup.logInvalidKeys(DistcompLevel.FIVE, this.fSelector);
            PackageInfo.LOGGER.log(DistcompLevel.TWO, "CancelledKeyException calling select() - select thread will continue.");
            return false;
        }
        catch (IOException iOException) {
            PackageInfo.LOGGER.log(DistcompLevel.TWO, "IOException calling select() - returning", iOException);
            return true;
        }
        catch (ClosedSelectorException closedSelectorException) {
            if (this.fKeepGoing.get()) {
                PackageInfo.LOGGER.log(DistcompLevel.TWO, "Selector was closed unexpectedly - returning", closedSelectorException);
            } else {
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Selector was closed as expected - returning", closedSelectorException);
            }
            return true;
        }
        if (n != 0) {
            LinkedList<BrokenInstance> linkedList = new LinkedList<BrokenInstance>();
            Iterator<SelectionKey> iterator = this.fSelector.selectedKeys().iterator();
            while (iterator.hasNext()) {
                SelectionKey selectionKey = iterator.next();
                iterator.remove();
                Object object = selectionKey.attachment();
                if (object instanceof Selectable) {
                    Selectable selectable = (Selectable)object;
                    try {
                        selectable.handleSelect();
                    }
                    catch (EOFException eOFException) {
                        PackageInfo.LOGGER.log(DistcompLevel.SIX, "EOF during handleSelect() on " + this.fThisInstance);
                        linkedList.add(new BrokenInstance(selectable.getRemoteProcess(), eOFException));
                    }
                    catch (IOException iOException) {
                        PackageInfo.LOGGER.log(DistcompLevel.ONE, "Exception during handleSelect() on " + this.fThisInstance + ": ", iOException);
                        linkedList.add(new BrokenInstance(selectable.getRemoteProcess(), iOException));
                    }
                    catch (RuntimeException runtimeException) {
                        PackageInfo.LOGGER.log(DistcompLevel.ONE, "Exception during handleSelect() on " + this.fThisInstance + ": ", runtimeException);
                        linkedList.add(new BrokenInstance(selectable.getRemoteProcess(), runtimeException));
                    }
                    continue;
                }
                PackageInfo.LOGGER.log(DistcompLevel.ONE, "Couldn't handle attachment: " + object);
                assert (false) : "Failed to handle SelectionKey attachment";
            }
            if (!linkedList.isEmpty()) {
                this.removeInstancesAndNotifyErrorHandler(linkedList);
            }
        }
        return false;
    }

    private static void logInvalidKeys(Level level, Selector selector) {
        if (PackageInfo.LOGGER.isLoggable(DistcompLevel.FIVE)) {
            for (SelectionKey selectionKey : selector.keys()) {
                if (selectionKey.isValid()) continue;
                PackageInfo.LOGGER.log(level, selectionKey + " is not valid.");
            }
        }
    }

    private void removeInstancesAndNotifyErrorHandler(List<BrokenInstance> list) {
        for (BrokenInstance brokenInstance : list) {
            brokenInstance.removeInstanceAndNotifyErrorHandler(this);
        }
    }

    private void detectLostInstances() {
        if (this.fKeepGoing.get()) {
            Collection<Instance> collection = this.getRegisteredInstances();
            Collection<Instance> collection2 = this.setdiff(this.fExpectedInstances, collection);
            for (Instance instance : collection2) {
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Expected " + instance + " to be registered with selector but it was not");
                this.removeInstance(instance);
                this.notifyLostCommunication(instance, null);
            }
            Collection<Instance> collection3 = this.setdiff(collection, this.fExpectedInstances);
            if (!collection3.isEmpty()) {
                PackageInfo.LOGGER.log(DistcompLevel.ONE, "CommunicationGroup in unexpected state - there are Instances registered with the selector that we did not put there.");
                assert (false) : "Unexpected instance registered with selector";
            }
        }
    }

    private Collection<Instance> setdiff(Collection<Instance> collection, Collection<Instance> collection2) {
        ArrayList<Instance> arrayList = new ArrayList<Instance>(collection);
        arrayList.removeAll(collection2);
        return arrayList;
    }

    private Collection<Instance> getRegisteredInstances() {
        int n = this.fSelector.keys().size();
        Vector<Instance> vector = new Vector<Instance>(n);
        for (SelectionKey selectionKey : this.fSelector.keys()) {
            Object object = selectionKey.attachment();
            if (object instanceof Selectable) {
                Selectable selectable = (Selectable)object;
                vector.add(selectable.getRemoteProcess());
                continue;
            }
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "CommunicationGroup in unexpected state - found non-Selectable [" + object + "] attached to selection key.");
            assert (false) : "Found non-Selectable attached to selection key";
        }
        return vector;
    }

    private void notifyLostCommunication(Instance instance, Throwable throwable) {
        assert (instance != null) : "Must specify the instance we've lost communication to";
        PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Notifying error handler of loss of communication to " + instance);
        this.fErrorHandler.lostCommunication(instance, throwable);
    }

    private static final class ConcurrentUniqueQueue<E> {
        private final ReentrantLock fLock = new ReentrantLock();
        private final Queue<E> fQueue = new LinkedList();
        private final Set<E> fSet = new HashSet();

        private ConcurrentUniqueQueue() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void add(E e) {
            if (e == null) {
                throw new NullPointerException("A ConcurrentUniqueQueue can not contain nulls");
            }
            this.fLock.lock();
            try {
                if (this.fSet.add(e)) {
                    this.fQueue.add(e);
                }
            }
            finally {
                this.fLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private E poll() {
            this.fLock.lock();
            try {
                E e = this.fQueue.poll();
                if (e != null) {
                    this.fSet.remove(e);
                }
                E e2 = e;
                return e2;
            }
            finally {
                this.fLock.unlock();
            }
        }
    }

    private static final class AddOpWrite
    implements Runnable {
        private final TransmissionChannel fTransmissionChannel;

        private AddOpWrite(TransmissionChannel transmissionChannel) {
            this.fTransmissionChannel = transmissionChannel;
        }

        @Override
        public void run() {
            this.fTransmissionChannel.addInterestOps(4);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            AddOpWrite addOpWrite = (AddOpWrite)object;
            return this.fTransmissionChannel.equals(addOpWrite.fTransmissionChannel);
        }

        public int hashCode() {
            return this.fTransmissionChannel.hashCode();
        }

        public String toString() {
            return "addInterestOps(SelectionKey.OP_WRITE) for " + this.fTransmissionChannel;
        }
    }

    private static class BrokenInstance {
        private final Instance fInstance;
        private final Throwable fThrownException;

        private BrokenInstance(Instance instance, Throwable throwable) {
            this.fInstance = instance;
            this.fThrownException = throwable;
        }

        private void removeInstanceAndNotifyErrorHandler(CommunicationGroup communicationGroup) {
            communicationGroup.removeInstance(this.fInstance);
            communicationGroup.notifyLostCommunication(this.fInstance, this.fThrownException);
        }
    }

    public static class NoSuchDestinationException
    extends RuntimeException {
        public NoSuchDestinationException(Message message, Instance instance) {
            super("Unable to send message " + message + ". No entry for " + instance + " in address book.");
        }
    }
}

