/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.pmode.CannotAcquireLabsException;
import com.mathworks.toolbox.distcomp.pmode.CmdWinOutput;
import com.mathworks.toolbox.distcomp.pmode.DrainableOutput;
import com.mathworks.toolbox.distcomp.pmode.DrainableOutputImpl;
import com.mathworks.toolbox.distcomp.pmode.FevalResult;
import com.mathworks.toolbox.distcomp.pmode.MFevalCommand;
import com.mathworks.toolbox.distcomp.pmode.MessageTracker;
import com.mathworks.toolbox.distcomp.pmode.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.RemoteCompositeAssistant;
import com.mathworks.toolbox.distcomp.pmode.Session;
import com.mathworks.toolbox.distcomp.pmode.SessionConstants;
import com.mathworks.toolbox.distcomp.pmode.SessionDestroyedException;
import com.mathworks.toolbox.distcomp.pmode.SpmdBlock;
import com.mathworks.toolbox.distcomp.pmode.SpmdBlockResult;
import com.mathworks.toolbox.distcomp.pmode.SpmdController;
import com.mathworks.toolbox.distcomp.pmode.SpmdInterrupt;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.MessageObserver;
import com.mathworks.toolbox.distcomp.pmode.shared.OutputGroup;
import com.mathworks.toolbox.distcomp.pmode.shared.ProcessInstance;
import com.mathworks.toolbox.distcomp.pmode.shared.ResourceManager;
import com.mathworks.toolbox.distcomp.pmode.shared.ReturnMessage;
import com.mathworks.toolbox.distcomp.pmode.shared.SessionService;
import com.mathworks.toolbox.distcomp.util.ByteBufferHandle;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public final class SpmdControllerImpl
implements SpmdController {
    private static final AtomicInteger sTAG_GEN = new AtomicInteger(0);
    private final int fTag;
    private final ResourceManager fResourceManager;
    private final OutputGroup fOutGroup;
    private final SessionService fSession;
    private final RemoteCompositeAssistant fRemoteCompositeAssistant;
    private Map<ProcessInstance, Integer> fLabs;
    private int fNumlabs;
    private DrainableOutput fDrainableOutput;
    private Map<ProcessInstance, Long> fBlockSequences;
    private MessageTracker fBlockExecutionTracker;
    private MessageTracker fCleanupTracker;
    private MessageTracker fKeyFlushTracker;
    private AtomicBoolean fInterruptsSent;
    private AtomicBoolean fInterruptsWaited;
    private Semaphore fBlockSendCompleted;
    private Semaphore fInterruptSendCompleted;
    private Instance fProcessCausingInterrupt = null;
    private ReturnMessage fMessageCausingInterrupt = null;

    @Override
    public synchronized Instance getProcessCausingInterrupt() {
        return this.fProcessCausingInterrupt;
    }

    @Override
    public synchronized ReturnMessage getMessageCausingInterrupt() {
        return this.fMessageCausingInterrupt;
    }

    static SpmdControllerImpl create(Session session, OutputGroup outputGroup) throws SessionDestroyedException, CannotAcquireLabsException {
        Object object;
        int n = sTAG_GEN.incrementAndGet();
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Creating a new SpmdControllerImpl " + n);
        ResourceManager resourceManager = session.getResourceManager();
        RemoteCompositeAssistant remoteCompositeAssistant = session.getCompositeAssistant();
        if (!session.isSessionRunning()) {
            throw new SessionDestroyedException();
        }
        try {
            object = resourceManager.acquireCurrentHolderToken(SessionConstants.sPARFOR_CREATION_TIMEOUT);
        }
        catch (InterruptedException interruptedException) {
            object = null;
        }
        if (object == null) {
            throw new CannotAcquireLabsException("Failed to create a SpmdController - timeout reached waiting for the previous one to have all messages returned");
        }
        SpmdControllerImpl spmdControllerImpl = new SpmdControllerImpl(remoteCompositeAssistant, resourceManager, session, outputGroup, n);
        resourceManager.setCurrentHolder(spmdControllerImpl, object);
        return spmdControllerImpl;
    }

    private SpmdControllerImpl(RemoteCompositeAssistant remoteCompositeAssistant, ResourceManager resourceManager, SessionService sessionService, OutputGroup outputGroup, int n) {
        this.fTag = n;
        this.fResourceManager = resourceManager;
        this.fOutGroup = outputGroup;
        this.fSession = sessionService;
        this.fRemoteCompositeAssistant = remoteCompositeAssistant;
        this.fLabs = new TreeMap<ProcessInstance, Integer>();
        this.fBlockSequences = new TreeMap<ProcessInstance, Long>();
        this.fNumlabs = -1;
    }

    @Override
    public ReturnMessage getCleanupResult(ProcessInstance processInstance) {
        return this.fCleanupTracker.getResult(processInstance);
    }

    @Override
    public ReturnMessage getBlockResult(ProcessInstance processInstance) {
        return this.fBlockExecutionTracker.getResult(processInstance);
    }

    @Override
    public ReturnMessage getKeyFlushResult(ProcessInstance processInstance) {
        return this.fKeyFlushTracker.getResult(processInstance);
    }

    public boolean acquireLabs(ProcessInstance processInstance) throws SessionDestroyedException {
        return this.acquireLabs(new ProcessInstance[]{processInstance});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean acquireLabs(ProcessInstance[] processInstanceArray) throws SessionDestroyedException {
        if (!this.fSession.isSessionRunning()) {
            throw new SessionDestroyedException();
        }
        Map<ProcessInstance, Integer> map = this.fLabs;
        synchronized (map) {
            for (int i = 0; i < processInstanceArray.length; ++i) {
                this.fLabs.put(processInstanceArray[i], i);
            }
        }
        this.fNumlabs = processInstanceArray.length;
        boolean bl = true;
        this.fDrainableOutput = new DrainableOutputImpl(ProcessInstance.getAllLabs(this.fNumlabs), bl, SessionConstants.sMAX_STORED_STR_LENGTH_PER_LAB);
        this.fBlockExecutionTracker = new MessageTracker(this.fNumlabs);
        this.fCleanupTracker = new MessageTracker(this.fNumlabs);
        this.fKeyFlushTracker = new MessageTracker(this.fNumlabs);
        this.fInterruptsSent = new AtomicBoolean(false);
        this.fInterruptsWaited = new AtomicBoolean(false);
        this.fBlockSendCompleted = new Semaphore(0);
        this.fInterruptSendCompleted = new Semaphore(0);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initiateRemoteSpmdBlock(ByteBufferHandle byteBufferHandle, ByteBufferHandle byteBufferHandle2) {
        boolean bl = this.fBlockExecutionTracker.markSent();
        assert (!bl) : "Attempt to send block twice";
        try {
            MessageObserver messageObserver = new MessageObserver(){

                @Override
                public void completed(ReturnMessage returnMessage, Instance instance) {
                    SpmdControllerImpl.this.handleBlockReturn(returnMessage, instance);
                }
            };
            for (ProcessInstance processInstance : this.fLabs.keySet()) {
                Object object = this.fRemoteCompositeAssistant.returnRemoteClearKeys(processInstance);
                SpmdBlock spmdBlock = new SpmdBlock(byteBufferHandle, byteBufferHandle2, object);
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "SPMD " + this.fTag + "sending execution with sequence " + spmdBlock.getSequenceNumber());
                this.fOutGroup.sendTo(processInstance, spmdBlock, messageObserver);
                this.fBlockSequences.put(processInstance, spmdBlock.getSequenceNumber());
            }
            this.fCleanupTracker.markSent();
        }
        finally {
            PackageInfo.LOGGER.log(DistcompLevel.SIX, "SPMD " + this.fTag + " release fBlockSendCompleted semaphore");
            this.fBlockSendCompleted.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initiateKeyFlush() {
        Object object = null;
        try {
            object = this.fResourceManager.acquireCurrentHolderToken(SessionConstants.sPARFOR_CREATION_TIMEOUT);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (object == null) {
            this.fKeyFlushTracker.skip();
            return;
        }
        this.fResourceManager.setCurrentHolder(this, object);
        boolean bl = false;
        try {
            boolean bl2 = this.fKeyFlushTracker.markSent();
            assert (!bl2) : "Attempt to send block twice";
            MessageObserver messageObserver = new MessageObserver(){

                @Override
                public void completed(ReturnMessage returnMessage, Instance instance) {
                    SpmdControllerImpl.this.handleKeyFlushReturn(returnMessage, instance);
                }
            };
            for (ProcessInstance processInstance : this.fLabs.keySet()) {
                Object object2 = this.fRemoteCompositeAssistant.returnRemoteClearKeys(processInstance);
                if (object2 != null) {
                    MFevalCommand mFevalCommand = new MFevalCommand(SessionConstants.sSPMD_REMOTE_CLEAR, new Object[]{object2}, SessionConstants.sSPMD_REMOTE_CLEAR_NARGOUT);
                    this.fOutGroup.sendTo(processInstance, mFevalCommand, messageObserver);
                    bl = true;
                    continue;
                }
                this.fKeyFlushTracker.messageReturned(processInstance, null);
            }
        }
        finally {
            if (!bl) {
                this.fResourceManager.releaseCurrentHolder(this);
            }
        }
    }

    public boolean awaitKeyFlush(long l, TimeUnit timeUnit) {
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Awaiting " + this.fTag + " key flush...");
        boolean bl = this.fKeyFlushTracker.await(l, timeUnit);
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Awaiting " + this.fTag + " block: " + bl);
        return bl;
    }

    @Override
    public void interrupt() {
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Executing " + this.fTag + " block interrupt");
        if (!this.fBlockExecutionTracker.alreadySent()) {
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Interrupt for SPMD " + this.fTag + " but block was never sent - simply dispose");
        } else {
            this.sendInterrupt();
        }
    }

    private void sendInterrupt() {
        boolean bl = this.fInterruptsSent.getAndSet(true);
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "SPMD sendInterrupt() - interrupts already sent? " + bl);
        if (!bl) {
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "SPMD sendInterrupt() - actually sending interrupt for tag " + this.fTag);
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    PackageInfo.LOGGER.log(DistcompLevel.SIX, "SPMD sendInterrupt() - acquiring semaphore");
                    try {
                        SpmdControllerImpl.this.fBlockSendCompleted.acquire();
                    }
                    catch (InterruptedException interruptedException) {
                        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "SPMD sendInterrupt() - caught InterruptedException", interruptedException);
                    }
                    PackageInfo.LOGGER.log(DistcompLevel.SIX, "SPMD sendInterrupt() - acquired semaphore");
                    try {
                        for (ProcessInstance processInstance : SpmdControllerImpl.this.fLabs.keySet()) {
                            SpmdInterrupt spmdInterrupt = new SpmdInterrupt((Long)SpmdControllerImpl.this.fBlockSequences.get(processInstance));
                            SpmdControllerImpl.this.fOutGroup.sendTo(processInstance, spmdInterrupt);
                        }
                        PackageInfo.LOGGER.log(DistcompLevel.SIX, "SPMD sendInterrupt() - finished sending interrupts for " + SpmdControllerImpl.this.fTag);
                    }
                    finally {
                        SpmdControllerImpl.this.fInterruptSendCompleted.release();
                        PackageInfo.LOGGER.log(DistcompLevel.SIX, "SPMD sendInterrupt() - released fInterruptSendCompleted " + SpmdControllerImpl.this.fTag);
                    }
                }
            };
            Thread thread = new Thread(runnable);
            thread.start();
        }
    }

    private void waitForInterruptsToCompleteSending() {
        boolean bl;
        boolean bl2 = this.fInterruptsSent.get();
        if (bl2 && !(bl = this.fInterruptsWaited.getAndSet(true))) {
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "SPMD " + this.fTag + " interrupts were sent but not yet waited, waiting for them to complete");
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "SPMD " + this.fTag + " wait - fInterruptSendCompleted.availablePermits(): " + this.fInterruptSendCompleted.availablePermits());
            try {
                this.fInterruptSendCompleted.acquire();
            }
            catch (InterruptedException interruptedException) {
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "SPMD waitForInterruptsToCompleteSending() - caught InterruptedException", interruptedException);
            }
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "SPMD " + this.fTag + " interrupts were completely sent");
        }
    }

    @Override
    public void dispose() {
        if (!this.fBlockExecutionTracker.alreadySent()) {
            this.fBlockExecutionTracker.skip();
            this.fCleanupTracker.skip();
            this.fKeyFlushTracker.skip();
            this.fResourceManager.releaseCurrentHolder(this);
        } else if (this.fSession.isSessionRunning()) {
            if (!this.fBlockExecutionTracker.isComplete()) {
                this.interrupt();
            }
            this.waitForInterruptsToCompleteSending();
        }
    }

    private void handleKeyFlushReturn(ReturnMessage returnMessage, Instance instance) {
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "SPMD " + this.fTag + " dealing with key flush return " + returnMessage.getOriginalSequenceNumber() + " from " + instance);
        if (returnMessage instanceof FevalResult) {
            this.fKeyFlushTracker.messageReturned(instance, returnMessage);
        }
        if (this.fKeyFlushTracker.isComplete()) {
            this.fResourceManager.releaseCurrentHolder(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleBlockReturn(ReturnMessage returnMessage, Instance instance) {
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "SPMD " + this.fTag + " dealing with block return sequence " + returnMessage.getOriginalSequenceNumber() + " from " + instance);
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "SPMD handleBlockReturn( " + returnMessage.getClass() + " )");
        if (returnMessage instanceof FevalResult) {
            this.fCleanupTracker.messageReturned(instance, returnMessage);
            if (!this.fBlockExecutionTracker.hasReturnFrom(instance)) {
                this.fBlockExecutionTracker.messageReturned(instance, SpmdBlockResult.NO_ERROR_RESULT);
            }
            if (this.fCleanupTracker.isComplete()) {
                this.fResourceManager.releaseCurrentHolder(this);
            }
        } else if (returnMessage instanceof SpmdBlockResult) {
            this.fBlockExecutionTracker.messageReturned(instance, returnMessage);
            if (((SpmdBlockResult)returnMessage).isError()) {
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "SPMD - spotted an error, interrupting");
                SpmdControllerImpl spmdControllerImpl = this;
                synchronized (spmdControllerImpl) {
                    this.fProcessCausingInterrupt = instance;
                    this.fMessageCausingInterrupt = returnMessage;
                }
                this.interrupt();
            } else assert (false) : "An SpmdBlockResult was returned when an error did not occur";
        } else if (returnMessage instanceof CmdWinOutput) {
            this.fDrainableOutput.addOutput(instance, ((CmdWinOutput)returnMessage).getStrings());
        }
    }

    @Override
    public boolean awaitBlock(long l, TimeUnit timeUnit) {
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Awaiting " + this.fTag + " block...");
        boolean bl = this.fBlockExecutionTracker.await(l, timeUnit);
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Awaiting " + this.fTag + " block: " + bl);
        return bl;
    }

    @Override
    public boolean awaitCleanup(long l, TimeUnit timeUnit) {
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Awaiting " + this.fTag + " interrupt send completion if necessary");
        this.waitForInterruptsToCompleteSending();
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Awaiting " + this.fTag + " cleanup...");
        boolean bl = this.fCleanupTracker.await(l, timeUnit);
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Awaiting " + this.fTag + " cleanup: " + bl);
        return bl;
    }

    public void drainIO(boolean bl) {
        String[] stringArray = bl ? this.fDrainableOutput.drainAllOutput() : this.fDrainableOutput.drainOutput();
        for (String string : stringArray) {
            if (string.length() <= 0) continue;
            System.out.println(string);
        }
    }

    public String toString() {
        return this.getClass().getName() + "[fTag = " + this.fTag + ", fNumlabs = " + this.fNumlabs + "]";
    }
}

