/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.toolbox.distcomp.pmode.DrainableOutput;
import com.mathworks.toolbox.distcomp.pmode.DrainableOutputImpl;
import com.mathworks.toolbox.distcomp.pmode.shared.LabsCompletionObserver;
import com.mathworks.toolbox.distcomp.pmode.shared.ProcessInstance;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class RunOnAllCompletionObserver
implements LabsCompletionObserver {
    private final CountDownLatch fNumLabsFinished;
    private final boolean fUseDrainableOutput;
    private final DrainableOutput fDrainableOutput;

    public RunOnAllCompletionObserver(int n) {
        this(n, false);
    }

    public RunOnAllCompletionObserver(int n, boolean bl) {
        this.fNumLabsFinished = new CountDownLatch(n);
        this.fUseDrainableOutput = bl;
        this.fDrainableOutput = this.fUseDrainableOutput ? new DrainableOutputImpl(ProcessInstance.getAllLabs(n), false) : null;
    }

    public boolean waitForCompletion(long l, TimeUnit timeUnit) throws InterruptedException {
        return this.fNumLabsFinished.await(l, timeUnit);
    }

    @Override
    public void handleOutput(String string, ProcessInstance processInstance) {
        if (this.fUseDrainableOutput) {
            String[] stringArray = new String[]{string};
            this.fDrainableOutput.addOutput(processInstance, stringArray);
        } else {
            System.out.print(string);
        }
    }

    @Override
    public void handleExecStatus(int n, ProcessInstance processInstance) {
        this.fNumLabsFinished.countDown();
    }

    public DrainableOutput getDrainableOutput() {
        return this.fDrainableOutput;
    }
}

