/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.jmi.Matlab;
import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.pmode.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.shared.ProcessInstance;

class RawMatlabStatusTracker {
    private static final int[] sEXEC_STATES_NO_CTRLC = new int[]{0, 2};
    private static final int[] sEXEC_STATES_W_CTRLC = new int[]{0, 2, 4, 3};
    private static final int[] sCOMPLETE_PROMPT_STATE_W_CTRLC = new int[]{Matlab.BASE_PROMPT, Matlab.NO_PROMPT};
    private int[] fRawStatus;
    private boolean fCurrentPossiblyInterrupted;
    private boolean fPreviousPossiblyInterrupted;

    public RawMatlabStatusTracker(int n) {
        this.fRawStatus = new int[n];
        this.fCurrentPossiblyInterrupted = false;
        this.fPreviousPossiblyInterrupted = false;
    }

    public void prepareForNewCommand() {
        for (int i = 0; i < this.fRawStatus.length; ++i) {
            this.fRawStatus[i] = 0;
        }
        this.fPreviousPossiblyInterrupted = this.fCurrentPossiblyInterrupted;
        this.fCurrentPossiblyInterrupted = false;
    }

    public void setStatus(int n, ProcessInstance processInstance) {
        this.fRawStatus[processInstance.getLabIndex() - 1] = n;
    }

    public void setPossiblyInterrupted() {
        this.fCurrentPossiblyInterrupted = true;
    }

    public boolean isOK() {
        int n;
        int n2;
        int[] nArray = new int[this.fRawStatus.length];
        boolean bl = this.fCurrentPossiblyInterrupted || this.fPreviousPossiblyInterrupted;
        String string = "Ctrl-C " + (bl ? "is" : " is not ") + " accepted.";
        for (n2 = 0; n2 < this.fRawStatus.length; ++n2) {
            nArray[n2] = Matlab.getInputRequester((int)this.fRawStatus[n2]);
        }
        n2 = (bl ? RawMatlabStatusTracker.areStatusesInSet(nArray, sCOMPLETE_PROMPT_STATE_W_CTRLC) : RawMatlabStatusTracker.areAllStatusesEqualTo(nArray, Matlab.BASE_PROMPT)) ? 1 : 0;
        boolean bl2 = RawMatlabStatusTracker.areAllStatusesEqualTo(nArray, Matlab.INCOMPLETE_BLOCK_PROMPT);
        if (n2 == 0 && !bl2) {
            String string2 = "Returning false in command consistency checking due to prompt status. " + string;
            PackageInfo.LOGGER.log(DistcompLevel.ZERO, string2);
            return false;
        }
        for (n = 0; n < this.fRawStatus.length; ++n) {
            nArray[n] = Matlab.getCodeBlockStatus((int)this.fRawStatus[n]);
        }
        n = RawMatlabStatusTracker.areAllStatusesEqualTo(nArray, 0) ? 1 : 0;
        boolean bl3 = RawMatlabStatusTracker.areAllStatusesEqualTo(nArray, 1);
        boolean bl4 = RawMatlabStatusTracker.areAllStatusesEqualTo(nArray, 2);
        if (n == 0 && !bl3 && !bl4) {
            PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Returning false in command consistency checking due to block status.");
            return false;
        }
        if (bl2 != bl3) {
            PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Returning false in command consistency checking due to the combination of prompt and block status.");
            return false;
        }
        for (int i = 0; i < this.fRawStatus.length; ++i) {
            nArray[i] = Matlab.getExecutionStatus((int)this.fRawStatus[i]);
        }
        int[] nArray2 = bl ? sEXEC_STATES_W_CTRLC : sEXEC_STATES_NO_CTRLC;
        boolean bl5 = RawMatlabStatusTracker.areStatusesInSet(nArray, nArray2);
        boolean bl6 = RawMatlabStatusTracker.areAllStatusesEqualTo(nArray, 1);
        if (!bl6 && !bl5) {
            String string3 = "Returning false in command consistency checking due to command execution status.  " + string;
            PackageInfo.LOGGER.log(DistcompLevel.ZERO, string3);
            return false;
        }
        return true;
    }

    public String toString() {
        int n;
        String string = "Execution statuses: ";
        for (n = 0; n < this.fRawStatus.length; ++n) {
            string = string + "  " + Matlab.getExecutionStatus((int)this.fRawStatus[n]);
        }
        string = string + "\nCode block statuses: ";
        for (n = 0; n < this.fRawStatus.length; ++n) {
            string = string + "  " + Matlab.getCodeBlockStatus((int)this.fRawStatus[n]);
        }
        string = string + "\nPrompts: ";
        for (n = 0; n < this.fRawStatus.length; ++n) {
            string = string + "  " + Matlab.getInputRequester((int)this.fRawStatus[n]);
        }
        string = string + "\nCurrent possibly interrupted: " + this.fCurrentPossiblyInterrupted + "\nPrevious possibly interrupted: " + this.fPreviousPossiblyInterrupted;
        return string;
    }

    private static boolean areStatusesInSet(int[] nArray, int[] nArray2) {
        for (int i = 0; i < nArray.length; ++i) {
            boolean bl = false;
            for (int j = 0; j < nArray2.length; ++j) {
                if (nArray[i] != nArray2[j]) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    private static boolean areAllStatusesEqualTo(int[] nArray, int n) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == n) continue;
            return false;
        }
        return true;
    }
}

