/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.pmode.CmdExecResults;
import com.mathworks.toolbox.distcomp.pmode.CmdWinOutput;
import com.mathworks.toolbox.distcomp.pmode.Labs;
import com.mathworks.toolbox.distcomp.pmode.LabsStateListener;
import com.mathworks.toolbox.distcomp.pmode.LabsStateTracker;
import com.mathworks.toolbox.distcomp.pmode.LabsStateTrackerImpl;
import com.mathworks.toolbox.distcomp.pmode.MFevalCommand;
import com.mathworks.toolbox.distcomp.pmode.MInteractiveEvalCommand;
import com.mathworks.toolbox.distcomp.pmode.MInteractiveInterrupt;
import com.mathworks.toolbox.distcomp.pmode.MInterruptResult;
import com.mathworks.toolbox.distcomp.pmode.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.PendingCommand;
import com.mathworks.toolbox.distcomp.pmode.RemoteResultsHandler;
import com.mathworks.toolbox.distcomp.pmode.RemoteResultsHandlerImpl;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.LabsCompletionObserver;
import com.mathworks.toolbox.distcomp.pmode.shared.MessageObserver;
import com.mathworks.toolbox.distcomp.pmode.shared.OutputGroup;
import com.mathworks.toolbox.distcomp.pmode.shared.ProcessInstance;
import com.mathworks.toolbox.distcomp.pmode.shared.ReturnMessage;
import com.mathworks.toolbox.distcomp.pmode.shared.SessionService;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;

public class LabsImpl
implements Labs {
    private final OutputGroup fOutGroup;
    private final List<PendingCommand> fPendingQueue;
    private final AtomicBoolean fLabsAreBusy;
    private final LabsStateTracker fLabsStateTracker;
    private final RemoteResultsHandler fResultsHandler;

    public static LabsImpl create(SessionService sessionService, OutputGroup outputGroup) {
        LabsImpl labsImpl = new LabsImpl(sessionService, outputGroup);
        labsImpl.init();
        return labsImpl;
    }

    private LabsImpl(SessionService sessionService, OutputGroup outputGroup) {
        this.fOutGroup = outputGroup;
        this.fPendingQueue = Collections.synchronizedList(new LinkedList());
        this.fLabsAreBusy = new AtomicBoolean(false);
        this.fLabsStateTracker = new LabsStateTrackerImpl(sessionService, outputGroup.getNumDestinations());
        this.fResultsHandler = new RemoteResultsHandlerImpl(sessionService, this.fLabsStateTracker);
    }

    private void init() {
        this.fLabsStateTracker.setIdleListener(new LabsStateListener(){

            @Override
            public void labsAreIdle() {
                LabsImpl.this.onLabsAreIdle();
            }
        });
    }

    public synchronized void eval(String string) {
        this.eval(string, null);
    }

    public synchronized void evalConsoleOutput(String string) {
        LabsCompletionObserver labsCompletionObserver = new LabsCompletionObserver(){

            @Override
            public void handleOutput(String string, ProcessInstance processInstance) {
                System.out.print(string);
            }

            @Override
            public void handleExecStatus(int n, ProcessInstance processInstance) {
            }
        };
        this.eval(string, labsCompletionObserver);
    }

    @Override
    public synchronized void eval(String string, LabsCompletionObserver labsCompletionObserver) {
        assert (string != null) : "M command string must not be null.";
        if (this.fLabsAreBusy.get()) {
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Adding command to pending queue: " + string);
            this.fPendingQueue.add(new PendingCommand(string, labsCompletionObserver));
        } else {
            this.runCommand(string, labsCompletionObserver);
        }
    }

    public synchronized BlockingQueue<ReturnMessage> fevalOnLab(int n, String string, Object[] objectArray, int n2) {
        assert (string != null) : "Function string must not be null.";
        assert (n > 0 && n <= this.getNumLabs()) : "labindex must be between 1 and numlabs.";
        assert (n2 >= 0) : "nlhs cannot be less than zero";
        final LinkedBlockingQueue<ReturnMessage> linkedBlockingQueue = new LinkedBlockingQueue<ReturnMessage>();
        MFevalCommand mFevalCommand = new MFevalCommand(string, objectArray, n2, MFevalCommand.ConsoleOutput.Return);
        MessageObserver messageObserver = new MessageObserver(){

            @Override
            public void completed(ReturnMessage returnMessage, Instance instance) {
                try {
                    linkedBlockingQueue.put(returnMessage);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (returnMessage instanceof CmdWinOutput) {
                    String[] stringArray;
                    for (String string : stringArray = ((CmdWinOutput)returnMessage).getStrings()) {
                        System.out.print(string);
                    }
                }
            }
        };
        this.fOutGroup.sendTo(ProcessInstance.getLabInstance(n), mFevalCommand, messageObserver);
        return linkedBlockingQueue;
    }

    @Override
    public int getNumLabs() {
        return this.fOutGroup.getNumDestinations();
    }

    public int getNumPending() {
        return this.fPendingQueue.size();
    }

    public boolean isRunningCommand() {
        return this.fLabsAreBusy.get();
    }

    @Override
    public synchronized void interrupt() {
        this.interrupt(null);
    }

    @Override
    public synchronized void interrupt(LabsCompletionObserver labsCompletionObserver) {
        this.doInterrupt(labsCompletionObserver);
    }

    @Override
    public synchronized void interruptAndRemovePendingCommands() {
        this.interruptAndRemovePendingCommands(null);
    }

    @Override
    public synchronized void interruptAndRemovePendingCommands(LabsCompletionObserver labsCompletionObserver) {
        this.fPendingQueue.clear();
        this.doInterrupt(labsCompletionObserver);
    }

    private void doInterrupt(final LabsCompletionObserver labsCompletionObserver) {
        MInteractiveInterrupt mInteractiveInterrupt = new MInteractiveInterrupt();
        this.fLabsStateTracker.interruptStarting();
        if (labsCompletionObserver == null) {
            this.fOutGroup.sendToAll(mInteractiveInterrupt);
        } else {
            MessageObserver messageObserver = new MessageObserver(){

                @Override
                public void completed(ReturnMessage returnMessage, Instance instance) {
                    assert (instance instanceof ProcessInstance) : instance.toString() + " is not a ProcessInstance";
                    ProcessInstance processInstance = (ProcessInstance)instance;
                    if (returnMessage instanceof MInterruptResult) {
                        MInterruptResult mInterruptResult = (MInterruptResult)returnMessage;
                        labsCompletionObserver.handleExecStatus(mInterruptResult.getRawStatus(), processInstance);
                    }
                }
            };
            this.fOutGroup.sendToAll(mInteractiveInterrupt, messageObserver);
        }
    }

    private void evalNextCommand() {
        if (!this.fPendingQueue.isEmpty()) {
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Evaluating a pending command.");
            PendingCommand pendingCommand = this.fPendingQueue.remove(0);
            this.runCommand(pendingCommand.fCommand, pendingCommand.fObserver);
        }
    }

    private void runCommand(String string, LabsCompletionObserver labsCompletionObserver) {
        assert (!this.fLabsAreBusy.get()) : "In runCommand while labs are busy.";
        MInteractiveEvalCommand mInteractiveEvalCommand = new MInteractiveEvalCommand(string);
        long l = mInteractiveEvalCommand.getSequenceNumber();
        this.fResultsHandler.setCurrentCommand(l, labsCompletionObserver);
        this.fLabsAreBusy.set(true);
        this.fLabsStateTracker.cmdStarting(l);
        MessageObserver messageObserver = new MessageObserver(){

            @Override
            public void completed(ReturnMessage returnMessage, Instance instance) {
                assert (instance instanceof ProcessInstance) : instance.toString() + " is not a ProcessInstance";
                ProcessInstance processInstance = (ProcessInstance)instance;
                LabsImpl.this.handleReturnMessage(returnMessage, processInstance);
            }
        };
        this.fOutGroup.sendToAll(mInteractiveEvalCommand, messageObserver);
    }

    private void handleReturnMessage(ReturnMessage returnMessage, ProcessInstance processInstance) {
        if (returnMessage instanceof CmdWinOutput) {
            CmdWinOutput cmdWinOutput = (CmdWinOutput)returnMessage;
            this.fResultsHandler.handleOutput(cmdWinOutput, processInstance);
        } else if (returnMessage instanceof CmdExecResults) {
            if (this.fResultsHandler == null) {
                PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Should not receive command execution results on the labs.");
                assert (false) : "Should not receive command execution results on the labs.";
            }
            CmdExecResults cmdExecResults = (CmdExecResults)returnMessage;
            this.fResultsHandler.handleExecStatus(cmdExecResults, processInstance);
        }
    }

    private synchronized void onLabsAreIdle() {
        PackageInfo.LOGGER.log(DistcompLevel.THREE, "LabsImpl informed us that labs became idle.");
        this.fLabsAreBusy.set(false);
        this.evalNextCommand();
    }
}

